/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import doggytalents.DoggyBlocks;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.block.model.DogBedItemOverride;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class DogBedModel
implements BakedModel {
    public static DogBedItemOverride ITEM_OVERIDE = new DogBedItemOverride();
    private static final ResourceLocation MISSING_TEXTURE = new ResourceLocation("missingno");
    private ModelBakery modelLoader;
    private BlockModel model;
    private BakedModel bakedModel;
    private final Map<Triple<ICasingMaterial, IBeddingMaterial, Direction>, BakedModel> cache = Maps.newConcurrentMap();

    public DogBedModel(ModelBakery modelLoader, BlockModel model, BakedModel bakedModel) {
        this.modelLoader = modelLoader;
        this.model = model;
        this.bakedModel = bakedModel;
    }

    public BakedModel getModelVariant(@Nonnull ModelData data) {
        return this.getModelVariant((ICasingMaterial)data.get(DogBedTileEntity.CASING), (IBeddingMaterial)data.get(DogBedTileEntity.BEDDING), (Direction)data.get(DogBedTileEntity.FACING));
    }

    public BakedModel getModelVariant(ICasingMaterial casing, IBeddingMaterial bedding, Direction facing) {
        ImmutableTriple key = ImmutableTriple.of((Object)casing, (Object)bedding, (Object)(facing != null ? facing : Direction.NORTH));
        return this.cache.computeIfAbsent((Triple<ICasingMaterial, IBeddingMaterial, Direction>)key, k -> this.bakeModelVariant((ICasingMaterial)k.getLeft(), (IBeddingMaterial)k.getMiddle(), (Direction)k.getRight()));
    }

    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        return this.getModelVariant(null, null, Direction.NORTH).getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData data, @Nullable RenderType renderType) {
        return this.getModelVariant(data).getQuads(state, side, rand, data, renderType);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        return this.getModelVariant(data).getParticleIcon(data);
    }

    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ICasingMaterial casing = null;
        IBeddingMaterial bedding = null;
        Direction facing = Direction.NORTH;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof DogBedTileEntity) {
            casing = ((DogBedTileEntity)tile).getCasing();
            bedding = ((DogBedTileEntity)tile).getBedding();
        }
        if (state.m_61138_((Property)DogBedBlock.FACING)) {
            facing = (Direction)state.m_61143_((Property)DogBedBlock.FACING);
        }
        return tileData.derive().with(DogBedTileEntity.CASING, (Object)casing).with(DogBedTileEntity.BEDDING, (Object)bedding).with(DogBedTileEntity.FACING, (Object)facing).build();
    }

    public BakedModel bakeModelVariant(final @Nullable ICasingMaterial casingResource, final @Nullable IBeddingMaterial beddingResource, final @Nonnull Direction facing) {
        List parts = this.model.m_111436_();
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>(parts.size());
        for (BlockElement part : parts) {
            elements.add(new BlockElement(part.f_111308_, part.f_111309_, (Map)Maps.newHashMap((Map)part.f_111310_), part.f_111311_, part.f_111312_));
        }
        final BlockModel newModel = new BlockModel(this.model.getParentLocation(), elements, (Map)Maps.newHashMap((Map)this.model.f_111417_), this.model.m_111476_(), this.model.m_111479_(), this.model.m_111491_(), new ArrayList(this.model.m_111484_()));
        newModel.f_111416_ = this.model.f_111416_;
        newModel.f_111418_ = this.model.f_111418_;
        Either<Material, String> casingTexture = this.findCasingTexture(casingResource);
        newModel.f_111417_.put("bedding", this.findBeddingTexture(beddingResource));
        newModel.f_111417_.put("casing", casingTexture);
        newModel.f_111417_.put("particle", casingTexture);
        return new ModelBaker(){

            @Nullable
            public BakedModel bake(ResourceLocation location, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
                return newModel.m_111449_((ModelBaker)this, newModel, Material::m_119204_, (ModelState)DogBedModel.this.getModelRotation(facing), DogBedModel.this.createResourceVariant(casingResource, beddingResource, facing), true);
            }

            public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
                return Material::m_119204_;
            }

            public UnbakedModel m_245361_(ResourceLocation location) {
                return newModel;
            }

            @Nullable
            public BakedModel m_245240_(ResourceLocation location, ModelState state) {
                return this.bake(location, state, this.getModelTextureGetter());
            }
        }.bake(null, null, null);
    }

    private ResourceLocation createResourceVariant(@Nonnull ICasingMaterial casingResource, @Nonnull IBeddingMaterial beddingResource, @Nonnull Direction facing) {
        String beddingKey = beddingResource != null ? beddingResource.toString().replace(':', '.') : "doggytalents.dogbed.bedding.missing";
        String casingKey = beddingResource != null ? casingResource.toString().replace(':', '.') : "doggytalents.dogbed.casing.missing";
        return new ModelResourceLocation(DoggyBlocks.DOG_BED.getId(), "bedding=" + beddingKey + ",casing=" + casingKey + ",facing=" + facing.m_122433_());
    }

    private Either<Material, String> findCasingTexture(@Nullable ICasingMaterial resource) {
        return this.findTexture(resource != null ? resource.getTexture() : null);
    }

    private Either<Material, String> findBeddingTexture(@Nullable IBeddingMaterial resource) {
        return this.findTexture(resource != null ? resource.getTexture() : null);
    }

    private Either<Material, String> findTexture(@Nullable ResourceLocation resource) {
        if (resource == null) {
            resource = MISSING_TEXTURE;
        }
        return Either.left((Object)new Material(InventoryMenu.f_39692_, resource));
    }

    private BlockModelRotation getModelRotation(@Nonnull Direction dir) {
        switch (dir) {
            default: {
                return BlockModelRotation.X0_Y0;
            }
            case EAST: {
                return BlockModelRotation.X0_Y90;
            }
            case SOUTH: {
                return BlockModelRotation.X0_Y180;
            }
            case WEST: 
        }
        return BlockModelRotation.X0_Y270;
    }

    public boolean m_7541_() {
        return this.bakedModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.bakedModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.bakedModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.bakedModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.bakedModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.bakedModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return ITEM_OVERIDE;
    }
}

