/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.addon.jei;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public final class DogBedRecipeMaker {
    public static List<CraftingRecipe> createDogBedRecipes() {
        Collection beddingMaterials = DoggyTalentsAPI.BEDDING_MATERIAL.get().getValues();
        Collection casingMaterials = DoggyTalentsAPI.CASING_MATERIAL.get().getValues();
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>(beddingMaterials.size() * casingMaterials.size());
        String group = "doggytalents.dogbed";
        for (IBeddingMaterial beddingId : DoggyTalentsAPI.BEDDING_MATERIAL.get().getValues()) {
            for (ICasingMaterial casingId : DoggyTalentsAPI.CASING_MATERIAL.get().getValues()) {
                Ingredient beddingIngredient = beddingId.getIngredient();
                Ingredient casingIngredient = casingId.getIngredient();
                NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{casingIngredient, beddingIngredient, casingIngredient, casingIngredient, beddingIngredient, casingIngredient, casingIngredient, casingIngredient, casingIngredient});
                ItemStack output = DogBedUtil.createItemStack(casingId, beddingId);
                ResourceLocation id = Util.getResource(output.m_41778_());
                ShapedRecipe recipe = new ShapedRecipe(id, group, CraftingBookCategory.BUILDING, 3, 3, inputs, output);
                recipes.add((CraftingRecipe)recipe);
            }
        }
        return recipes;
    }
}

