/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyEntityTypes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class DTLootTableProvider
extends LootTableProvider {
    public DTLootTableProvider(PackOutput packOutput) {
        super(packOutput, BuiltInLootTables.m_78766_(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(Entities::new, LootContextParamSets.f_81415_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
    }

    private static class Entities
    extends EntityLootSubProvider {
        protected Entities() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.registerNoLoot((Supplier<? extends EntityType<?>>)DoggyEntityTypes.DOG);
        }

        protected void registerNoLoot(Supplier<? extends EntityType<?>> type) {
            this.m_245309_(type.get(), LootTable.m_79147_());
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return DoggyEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get);
        }
    }

    private static class Blocks
    extends BlockLootSubProvider {
        protected Blocks() {
            super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
        }

        public void m_245660_() {
            this.dropsSelf((Supplier<? extends Block>)DoggyBlocks.DOG_BATH);
            this.dropDogBed((Supplier<? extends Block>)DoggyBlocks.DOG_BED);
            this.dropsSelf((Supplier<? extends Block>)DoggyBlocks.FOOD_BOWL);
        }

        private void dropDogBed(Supplier<? extends Block> block) {
            LootTable.Builder lootTableBuilder = LootTable.m_79147_().m_79161_(((LootPool.Builder)this.m_247733_((ItemLike)block.get(), (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)block.get())).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("casingId", "doggytalents.casingId").m_80279_("beddingId", "doggytalents.beddingId").m_80279_("ownerId", "doggytalents.ownerId").m_80279_("name", "doggytalents.name").m_80279_("ownerName", "doggytalents.ownerName"))));
            this.m_247577_(block.get(), lootTableBuilder);
        }

        private void dropsSelf(Supplier<? extends Block> block) {
            this.m_245724_(block.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return DoggyBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

