/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Predicates;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.feature.EnumMode;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.util.EntityUtil;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class DoggyBeamEntity
extends ThrowableProjectile
implements IEntityAdditionalSpawnData {
    public DoggyBeamEntity(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public DoggyBeamEntity(Level worldIn, LivingEntity livingEntityIn) {
        super((EntityType)DoggyEntityTypes.DOG_BEAM.get(), livingEntityIn, worldIn);
    }

    public DoggyBeamEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)DoggyEntityTypes.DOG_BEAM.get(), worldIn);
    }

    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entityHit = ((EntityHitResult)result).m_82443_();
            Entity thrower = this.m_37282_();
            if (thrower instanceof LivingEntity && entityHit instanceof LivingEntity) {
                LivingEntity livingThrower = (LivingEntity)thrower;
                LivingEntity livingEntity = (LivingEntity)entityHit;
                this.f_19853_.m_45976_(DogEntity.class, this.m_20191_().m_82377_(64.0, 16.0, 64.0)).stream().filter(Predicates.not(TamableAnimal::m_21825_)).filter(d -> d.isMode(EnumMode.AGGRESIVE, EnumMode.TACTICAL, EnumMode.BERSERKER)).filter(d -> d.canInteract(livingThrower)).filter(d -> d != livingEntity && d.m_7757_(livingEntity, d.m_21826_())).filter(d -> (double)d.m_20270_(entityHit) < EntityUtil.getFollowRange((LivingEntity)d)).forEach(d -> d.m_6710_(livingEntity));
            }
            for (int j = 0; j < 8; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123754_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        UUID ownerId = this.f_19820_;
        buffer.writeBoolean(ownerId != null);
        if (ownerId != null) {
            buffer.m_130077_(ownerId);
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        boolean hasThrower = buffer.readBoolean();
        if (hasThrower) {
            this.f_19820_ = buffer.m_130259_();
        }
    }

    protected void m_8097_() {
    }
}

