/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.inventory.container.slot.DogInventorySlot;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class DogInventoriesContainer
extends AbstractContainerMenu {
    private Level world;
    private Player player;
    private DataSlot position;
    private SimpleContainerData trackableArray;
    private final List<DogInventorySlot> dogSlots = new ArrayList<DogInventorySlot>();
    private int possibleSlots = 0;

    public DogInventoriesContainer(int windowId, Inventory playerInventory, SimpleContainerData trackableArray) {
        super((MenuType)DoggyContainerTypes.DOG_INVENTORIES.get(), windowId);
        this.world = playerInventory.f_35978_.f_19853_;
        this.player = playerInventory.f_35978_;
        this.position = DataSlot.m_39401_();
        DogInventoriesContainer.m_38886_((ContainerData)trackableArray, (int)1);
        this.m_38895_(this.position);
        this.trackableArray = trackableArray;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
        this.addDogSlots();
    }

    public void addDogSlots() {
        int TOTAL_COLUMNS = 9;
        int page = this.position.m_6501_();
        int drawingColumn = 0;
        for (int i = 0; i < this.trackableArray.m_6499_(); ++i) {
            DogEntity dog;
            PackPuppyItemHandler packInventory;
            int entityId = this.trackableArray.m_6413_(i);
            Entity entity = this.world.m_6815_(entityId);
            if (!(entity instanceof DogEntity) || (packInventory = (PackPuppyItemHandler)(dog = (DogEntity)entity).getTalent((Supplier)DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null)) == null) continue;
            int level = Mth.m_14045_((int)dog.getDogLevel((Supplier)DoggyTalents.PACK_PUPPY), (int)0, (int)5);
            int numCols = Mth.m_14045_((int)level, (int)0, (int)Math.max(0, 9));
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < numCols; ++col) {
                    DogInventorySlot slot = new DogInventorySlot(dog, this.player, (IItemHandler)packInventory, drawingColumn + col, row, col, col * 3 + row, 8 + 18 * (drawingColumn + col - page), 18 * row + 18);
                    this.addDogSlot(slot);
                    int adjustedColumn = slot.getOverallColumn() - page;
                    if (adjustedColumn - page >= 0 && adjustedColumn - page < 9) continue;
                    slot.setEnabled(false);
                }
            }
            this.possibleSlots += level;
            drawingColumn += numCols;
        }
    }

    public void m_7511_(int id, int data) {
        super.m_7511_(id, data);
        if (id == 0) {
            for (int i = 0; i < this.dogSlots.size(); ++i) {
                DogInventorySlot slot = this.dogSlots.get(i);
                DogInventorySlot newSlot = new DogInventorySlot(slot, 8 + 18 * (slot.getOverallColumn() - data));
                this.replaceDogSlot(i, newSlot);
                int adjustedColumn = slot.getOverallColumn() - data;
                if (adjustedColumn >= 0 && adjustedColumn < 9) continue;
                newSlot.setEnabled(false);
            }
        }
    }

    private void addDogSlot(DogInventorySlot slotIn) {
        this.m_38897_((Slot)slotIn);
        this.dogSlots.add(slotIn);
    }

    private void replaceDogSlot(int i, DogInventorySlot slotIn) {
        this.dogSlots.set(i, slotIn);
        DogInventorySlot s = slotIn;
        this.f_38839_.set(((Slot)s).f_40219_, (Object)slotIn);
    }

    public int getTotalNumColumns() {
        return this.possibleSlots;
    }

    public int getPage() {
        return this.position.m_6501_();
    }

    public void setPage(int page) {
        this.position.m_6422_(page);
    }

    public List<DogInventorySlot> getSlots() {
        return this.dogSlots;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int i) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(i);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int startIndex = this.f_38839_.size() - this.dogSlots.size() + this.position.m_6501_() * 3;
            int endIndex = Math.min(startIndex + 27, this.f_38839_.size());
            if (i >= this.f_38839_.size() - this.dogSlots.size() && i < this.f_38839_.size() ? !this.m_38903_(itemstack1, 0, this.f_38839_.size() - this.dogSlots.size(), true) : !this.m_38903_(itemstack1, this.f_38839_.size() - this.dogSlots.size(), this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return itemstack;
    }
}

