/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Lists;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.feature.EnumMode;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.NBTUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DogRespawnData
implements IDogData {
    private final DogRespawnStorage storage;
    private final UUID uuid;
    private CompoundTag data;
    private static final List<String> TAGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"Pos", "Health", "Motion", "Rotation", "FallDistance", "Fire", "Air", "OnGround", "Dimension", "PortalCooldown", "Passengers", "Leash", "InLove", "Leash", "HurtTime", "HurtByTimestamp", "DeathTime", "AbsorptionAmount", "FallFlying", "Brain", "Sitting"});

    protected DogRespawnData(DogRespawnStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    public String getDogName() {
        Component name = NBTUtil.getTextComponent(this.data, "CustomName");
        return name == null ? "" : name.getString();
    }

    @Override
    public UUID getOwnerId() {
        String str = this.data.m_128461_("OwnerUUID");
        return "".equals(str) ? null : UUID.fromString(str);
    }

    @Override
    public String getOwnerName() {
        Component name = NBTUtil.getTextComponent(this.data, "lastKnownOwnerName");
        return name == null ? "" : name.getString();
    }

    public void populate(DogEntity dogIn) {
        this.data = new CompoundTag();
        dogIn.m_20240_(this.data);
        for (String tag : TAGS_TO_REMOVE) {
            this.data.m_128473_(tag);
        }
        this.data.m_128473_("UUID");
        this.data.m_128473_("LoveCause");
    }

    @Nullable
    public DogEntity respawn(ServerLevel worldIn, Player playerIn, BlockPos pos) {
        DogEntity dog = (DogEntity)((EntityType)DoggyEntityTypes.DOG.get()).m_20592_(worldIn, (ItemStack)null, playerIn, pos, MobSpawnType.TRIGGERED, true, false);
        if (dog == null) {
            return null;
        }
        CompoundTag compoundnbt = dog.m_20240_(new CompoundTag());
        UUID uuid = dog.m_20148_();
        compoundnbt.m_128391_(this.data);
        dog.m_20084_(uuid);
        dog.m_20258_(compoundnbt);
        dog.setMode(EnumMode.DOCILE);
        dog.m_21839_(true);
        return dog;
    }

    public void read(CompoundTag compound) {
        this.data = compound.m_128469_("data");
    }

    public CompoundTag write(CompoundTag compound) {
        compound.m_128365_("data", (Tag)this.data);
        return compound;
    }
}

