/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyAttributes;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WolfMountTalent
extends TalentInstance {
    private static final UUID WOLF_MOUNT_JUMP = UUID.fromString("7f338124-f223-4630-8515-70ee0bfbc653");

    public WolfMountTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDogEntity dogIn) {
        dogIn.setAttributeModifier((Attribute)DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void set(AbstractDogEntity dogIn, int level) {
        dogIn.setAttributeModifier((Attribute)DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    public AttributeModifier createSpeedModifier(AbstractDogEntity dogIn, UUID uuidIn) {
        if (this.level() > 0) {
            double speed = 0.06 * (double)this.level();
            if (this.level() >= 5) {
                speed += 0.04;
            }
            return new AttributeModifier(uuidIn, "Wolf Mount", speed, AttributeModifier.Operation.ADDITION);
        }
        return null;
    }

    @Override
    public InteractionResult processInteract(AbstractDogEntity dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (stack.m_41619_() && dogIn.canInteract((LivingEntity)playerIn) && this.level() > 0 && playerIn.m_20202_() == null && !playerIn.m_20096_()) {
            if (!dogIn.f_19853_.f_46443_) {
                dogIn.m_21839_(false);
                playerIn.m_146922_(dogIn.m_146908_());
                playerIn.m_146926_(dogIn.m_146909_());
                playerIn.m_20329_((Entity)dogIn);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void livingTick(AbstractDogEntity dog) {
        if (dog.m_20160_() && dog.getDogHunger() < 1.0f) {
            dog.m_6688_().m_213846_((Component)Component.m_237110_((String)"talent.doggytalents.wolf_mount.exhausted", (Object[])new Object[]{dog.m_7755_()}));
            dog.m_20153_();
        }
    }

    @Override
    public InteractionResultHolder<Integer> hungerTick(AbstractDogEntity dogIn, int hungerTick) {
        if (dogIn.m_6109_()) {
            return InteractionResultHolder.m_19090_((Object)(hungerTick += this.level() < 5 ? 3 : 1));
        }
        return InteractionResultHolder.m_19098_((Object)hungerTick);
    }

    @Override
    public InteractionResultHolder<Float> calculateFallDistance(AbstractDogEntity dogIn, float distance) {
        if (this.level() >= 5) {
            return InteractionResultHolder.m_19090_((Object)Float.valueOf(distance - 1.0f));
        }
        return InteractionResultHolder.m_19098_((Object)Float.valueOf(0.0f));
    }

    @Override
    public InteractionResult hitByEntity(AbstractDogEntity dogIn, Entity entity) {
        return dogIn.m_20365_(entity) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }
}

