/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyTalents2;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.IForgeRegistry;

public class NBTUtil {
    public static void putUniqueId(CompoundTag compound, String key, @Nullable UUID uuid) {
        if (uuid != null) {
            compound.m_128362_(key, uuid);
        }
    }

    @Nullable
    public static UUID getUniqueId(CompoundTag compound, String key) {
        if (compound.m_128403_(key)) {
            return compound.m_128342_(key);
        }
        if (NBTUtil.hasOldUniqueId(compound, key)) {
            return NBTUtil.getOldUniqueId(compound, key);
        }
        return null;
    }

    public static UUID getOldUniqueId(CompoundTag compound, String key) {
        return new UUID(compound.m_128454_(key + "Most"), compound.m_128454_(key + "Least"));
    }

    public static boolean hasOldUniqueId(CompoundTag compound, String key) {
        return compound.m_128425_(key + "Most", 99) && compound.m_128425_(key + "Least", 99);
    }

    public static void removeOldUniqueId(CompoundTag compound, String key) {
        compound.m_128473_(key + "Most");
        compound.m_128473_(key + "Least");
    }

    public static void putResourceLocation(CompoundTag compound, String key, @Nullable ResourceLocation rl) {
        if (rl != null) {
            compound.m_128359_(key, rl.toString());
        }
    }

    @Nullable
    public static ResourceLocation getResourceLocation(CompoundTag compound, String key) {
        if (compound.m_128425_(key, 8)) {
            return ResourceLocation.m_135820_((String)compound.m_128461_(key));
        }
        return null;
    }

    @Nullable
    public static void putVector3d(CompoundTag compound, @Nullable Vec3 vec3d) {
        if (vec3d != null) {
            compound.m_128347_("x", vec3d.m_7096_());
            compound.m_128347_("y", vec3d.m_7098_());
            compound.m_128347_("z", vec3d.m_7094_());
        }
    }

    @Nullable
    public static Vec3 getVector3d(CompoundTag compound) {
        if (compound.m_128425_("x", 99) && compound.m_128425_("y", 99) && compound.m_128425_("z", 99)) {
            return new Vec3(compound.m_128459_("x"), compound.m_128459_("y"), compound.m_128459_("z"));
        }
        return null;
    }

    public static void putTextComponent(CompoundTag compound, String key, @Nullable Component component) {
        if (component != null) {
            compound.m_128359_(key, Component.Serializer.m_130703_((Component)component));
        }
    }

    @Nullable
    public static Component getTextComponent(CompoundTag compound, String key) {
        if (compound.m_128425_(key, 8)) {
            return Component.Serializer.m_130701_((String)compound.m_128461_(key));
        }
        return null;
    }

    @Nullable
    public static <T> T getRegistryValue(CompoundTag compound, String key, IForgeRegistry<T> registry) {
        ResourceLocation rl = NBTUtil.getResourceLocation(compound, key);
        if (rl != null) {
            Object delegate = registry.getValue(rl);
            if (delegate != null) {
                return (T)delegate;
            }
            DoggyTalents2.LOGGER.warn("Unable to load registry value in registry {} with resource location {}", (Object)registry.getRegistryName(), (Object)rl);
        } else {
            DoggyTalents2.LOGGER.warn("Unable to load resource location in NBT:{}, for {} registry", (Object)key, (Object)registry.getRegistryName());
        }
        return null;
    }

    @Nullable
    public static <T> Holder.Reference<T> getRegistryDelegate(CompoundTag compound, String key, IForgeRegistry<T> registry) {
        ResourceLocation rl = NBTUtil.getResourceLocation(compound, key);
        if (rl != null) {
            Optional delegate = registry.getDelegate(rl);
            if (delegate.isPresent()) {
                return (Holder.Reference)delegate.get();
            }
            DoggyTalents2.LOGGER.warn("Unable to load registry value in registry {} with resource location {}", (Object)registry.getRegistryName(), (Object)rl);
        } else {
            DoggyTalents2.LOGGER.warn("Unable to load resource location in NBT:{}, for {} registry", (Object)key, (Object)registry.getRegistryName());
        }
        return null;
    }

    public static <T> void putRegistryValue(CompoundTag compound, String key, Holder.Reference<T> value) {
        if (value != null) {
            NBTUtil.putResourceLocation(compound, key, value.m_205785_().m_135782_());
        }
    }

    public static <T> void putRegistryValue(CompoundTag compound, String key, T value, IForgeRegistry<T> registry) {
        if (value != null) {
            NBTUtil.putResourceLocation(compound, key, registry.getKey(value));
        }
    }

    public static void putBlockPos(CompoundTag compound, @Nullable BlockPos vec3d) {
        if (vec3d != null) {
            compound.m_128405_("x", vec3d.m_123341_());
            compound.m_128405_("y", vec3d.m_123342_());
            compound.m_128405_("z", vec3d.m_123343_());
        }
    }

    @Nullable
    public static BlockPos getBlockPos(CompoundTag compound) {
        if (compound.m_128425_("x", 99) && compound.m_128425_("y", 99) && compound.m_128425_("z", 99)) {
            return new BlockPos(compound.m_128451_("x"), compound.m_128451_("y"), compound.m_128451_("z"));
        }
        return null;
    }

    public static void putBlockPos(CompoundTag compound, String key, Optional<BlockPos> vec3d) {
        if (vec3d.isPresent()) {
            CompoundTag posNBT = new CompoundTag();
            NBTUtil.putBlockPos(posNBT, vec3d.get());
            compound.m_128365_(key, (Tag)posNBT);
        }
    }

    public static Optional<BlockPos> getBlockPos(CompoundTag compound, String key) {
        if (compound.m_128425_(key, 10)) {
            return Optional.of(NBTUtil.getBlockPos(compound.m_128469_(key)));
        }
        return Optional.empty();
    }

    public static void putBlockPos(CompoundTag compound, String key, @Nullable BlockPos vec3d) {
        if (vec3d != null) {
            CompoundTag posNBT = new CompoundTag();
            NBTUtil.putBlockPos(posNBT, vec3d);
            compound.m_128365_(key, (Tag)posNBT);
        }
    }

    public static void writeItemStack(CompoundTag compound, String key, ItemStack stackIn) {
        if (!stackIn.m_41619_()) {
            compound.m_128365_(key, (Tag)stackIn.m_41739_(new CompoundTag()));
        }
    }

    @Nonnull
    public static ItemStack readItemStack(CompoundTag compound, String key) {
        if (compound.m_128425_(key, 10)) {
            return ItemStack.m_41712_((CompoundTag)compound.m_128469_(key));
        }
        return ItemStack.f_41583_;
    }
}

