/*
 * Decompiled with CFR 0.152.
 */
package net.dualwielding.mixin;

import net.dualwielding.access.PlayerAccess;
import net.dualwielding.init.ParticleInit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1890;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements PlayerAccess {
    private int lastAttackedOffhandTicks;
    @Nullable
    private class_1297 target;
    private boolean offHandAttack;

    @Inject(method={"Lnet/minecraft/entity/player/PlayerEntity;tick()V"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/PlayerEntity;lastAttackedTicks:I", ordinal=0)})
    private void tickMixin(CallbackInfo info) {
        ++this.lastAttackedOffhandTicks;
    }

    @Override
    public void resetLastOffhandAttackTicks() {
        this.lastAttackedOffhandTicks = 0;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/enchantment/EnchantmentHelper;getAttackDamage(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/EntityGroup;)F"), ordinal=0)
    private float attackDamageMixin(float original) {
        class_1792 item = ((class_1657)this).method_6079().method_7909();
        if (this.offHandAttack) {
            if (item instanceof class_1829) {
                class_1829 swordItem = (class_1829)item;
                return swordItem.method_8020() + 1.0f;
            }
            class_1766 miningToolItem = (class_1766)item;
            return miningToolItem.method_26366() + 1.0f;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F", shift=At.Shift.BEFORE), ordinal=1)
    private float attackEnchantmentDamageMixin(float original) {
        class_1799 itemStack = ((class_1657)this).method_6079();
        if (this.offHandAttack) {
            float h = this.target != null && this.target instanceof class_1309 ? class_1890.method_8218((class_1799)itemStack, (class_1310)((class_1309)this.target).method_6046()) : class_1890.method_8218((class_1799)itemStack, (class_1310)class_1310.field_6290);
            return h;
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F"), ordinal=2)
    private float cooldownProgressMixin(float original) {
        if (this.offHandAttack) {
            return this.getAttackCooldownProgressOffhand(0.5f);
        }
        return original;
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;resetLastAttackedTicks()V")})
    private void attackResetLastAttackedTickskMixin(CallbackInfo info) {
        if (this.offHandAttack) {
            this.resetLastOffhandAttackTicks();
        }
    }

    @Inject(method={"resetLastAttackedTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void resetLastAttackedTickskMixin(CallbackInfo info) {
        if (this.offHandAttack) {
            info.cancel();
        }
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;postHit(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/player/PlayerEntity;)V"))
    private void attackPostHitMixin(class_1799 itemstack, class_1309 livingEntity, class_1657 playerEntity) {
        if (this.offHandAttack) {
            playerEntity.method_6079().method_7979(livingEntity, playerEntity);
        } else {
            itemstack.method_7979(livingEntity, playerEntity);
        }
    }

    @Inject(method={"attack"}, at={@At(value="TAIL")})
    public void attackMixin(CallbackInfo info) {
        if (this.offHandAttack) {
            this.offHandAttack = false;
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    public void attackMixin(class_1297 target, CallbackInfo info) {
        if (target.method_5732()) {
            this.target = target;
        }
    }

    @Inject(method={"spawnSweepAttackParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;spawnParticles(Lnet/minecraft/particle/ParticleEffect;DDDIDDDD)I")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    public void spawnSweepAttackParticles(CallbackInfo info, double d, double e) {
        if (this.offHandAttack) {
            class_1657 playerEntity = (class_1657)this;
            ((class_3218)playerEntity.field_6002).method_14199((class_2394)ParticleInit.OFFHAND_SWEEPING, playerEntity.method_23317() + d, playerEntity.method_23323(0.5), playerEntity.method_23321() + e, 0, d, 0.0, e, 0.0);
            info.cancel();
        }
    }

    @Shadow
    public float method_7279() {
        return 1.0f;
    }

    @Override
    public void setOffhandAttack() {
        this.offHandAttack = true;
    }

    @Override
    public boolean isOffhandAttack() {
        return this.offHandAttack;
    }

    @Override
    public float getAttackCooldownProgressOffhand(float baseTime) {
        return class_3532.method_15363((float)(((float)this.lastAttackedOffhandTicks + baseTime) / this.method_7279()), (float)0.0f, (float)1.0f);
    }
}

