/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;
import nl.requios.effortlessbuilding.capability.ModeCapabilityManager;
import nl.requios.effortlessbuilding.capability.ModifierCapabilityManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.network.AddUndoMessage;
import nl.requios.effortlessbuilding.network.ClearUndoMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.network.RequestLookAtMessage;

@Mod.EventBusSubscriber(modid="effortlessbuilding", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof FakePlayer) {
            return;
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("effortlessbuilding", "build_modifier"), (ICapabilityProvider)new ModifierCapabilityManager.Provider());
            event.addCapability(new ResourceLocation("effortlessbuilding", "build_mode"), (ICapabilityProvider)new ModeCapabilityManager.Provider());
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings((Player)player).getBuildMode();
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((Player)player);
        if (buildMode != BuildModes.BuildModeEnum.NORMAL) {
            ItemStack currentItemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (currentItemStack.m_41720_() instanceof BlockItem || CompatHelper.isItemBlockProxy(currentItemStack) && !player.m_6144_()) {
                event.setCanceled(true);
            }
        } else if (modifierSettings.doQuickReplace()) {
            event.setCanceled(true);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestLookAtMessage(true));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AddUndoMessage(event.getPos(), event.getBlockSnapshot().getReplacedBlock(), event.getState()));
        } else {
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestLookAtMessage(false));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AddUndoMessage(event.getPos(), event.getBlockSnapshot().getReplacedBlock(), event.getState()));
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings(event.getPlayer()).getBuildMode();
        if (buildMode != BuildModes.BuildModeEnum.NORMAL && ReachHelper.canBreakFar(event.getPlayer())) {
            event.setCanceled(true);
        } else {
            PacketDistributor.PacketTarget packetTarget;
            BuildModes.onBlockBroken(event.getPlayer(), event.getPos(), false);
            if (event.getPlayer() instanceof ServerPlayer && event.getState() != null && event.getPos() != null && (packetTarget = PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer())) != null) {
                PacketHandler.INSTANCE.send(packetTarget, (Object)new AddUndoMessage(event.getPos(), event.getState(), Blocks.f_50016_.m_49966_()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_20193_().f_46443_) {
            return;
        }
        UndoRedo.clear(player);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClearUndoMessage());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_20193_().f_46443_) {
            return;
        }
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        modeSettings.setBuildMode(BuildModes.BuildModeEnum.NORMAL);
        ModeSettingsManager.setModeSettings(player, modeSettings);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        modifierSettings.getMirrorSettings().enabled = false;
        modifierSettings.getRadialMirrorSettings().enabled = false;
        modifierSettings.getArraySettings().enabled = false;
        ModifierSettingsManager.setModifierSettings(player, modifierSettings);
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
        UndoRedo.clear(player);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClearUndoMessage());
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        Player newPlayer = event.getEntity();
        ModifierSettingsManager.setModifierSettings(newPlayer, ModifierSettingsManager.getModifierSettings(oldPlayer));
        ModeSettingsManager.setModeSettings(newPlayer, ModeSettingsManager.getModeSettings(oldPlayer));
    }
}

