/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.buildmode.BaseBuildMode;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.helper.ReachHelper;

public abstract class ThreeClicksBuildMode
extends BaseBuildMode {
    protected Dictionary<UUID, BlockPos> secondPosTable = new Hashtable<UUID, BlockPos>();

    public static BlockPos findHeight(Player player, BlockPos secondPos, boolean skipRaytrace) {
        Vec3 look = BuildModes.getPlayerLookVec(player);
        Vec3 start = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        ArrayList<HeightCriteria> criteriaList = new ArrayList<HeightCriteria>(3);
        Vec3 xBound = BuildModes.findXBound(secondPos.m_123341_(), start, look);
        criteriaList.add(new HeightCriteria(xBound, secondPos, start));
        Vec3 zBound = BuildModes.findZBound(secondPos.m_123343_(), start, look);
        criteriaList.add(new HeightCriteria(zBound, secondPos, start));
        int reach = ReachHelper.getPlacementReach(player) * 4;
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        HeightCriteria selected = (HeightCriteria)criteriaList.get(0);
        if (criteriaList.size() > 1) {
            for (int i = 1; i < criteriaList.size(); ++i) {
                HeightCriteria criteria2 = (HeightCriteria)criteriaList.get(i);
                if (criteria2.distToLineSq < 2.0 && selected.distToLineSq < 2.0) {
                    if (!(criteria2.distToPlayerSq < selected.distToPlayerSq)) continue;
                    selected = criteria2;
                    continue;
                }
                if (!(criteria2.distToLineSq < selected.distToLineSq)) continue;
                selected = criteria2;
            }
        }
        return new BlockPos(selected.lineBound);
    }

    @Override
    public void initialize(Player player) {
        super.initialize(player);
        this.secondPosTable.put(player.m_20148_(), BlockPos.f_121853_);
    }

    @Override
    public List<BlockPos> onRightClick(Player player, BlockPos blockPos, Direction sideHit, Vec3 hitVec, boolean skipRaytrace) {
        ArrayList<BlockPos> list = new ArrayList();
        Dictionary rightClickTable = player.f_19853_.f_46443_ ? this.rightClickClientTable : this.rightClickServerTable;
        int rightClickNr = (Integer)rightClickTable.get(player.m_20148_());
        rightClickTable.put(player.m_20148_(), ++rightClickNr);
        if (rightClickNr == 1) {
            if (blockPos == null) {
                rightClickTable.put(player.m_20148_(), 0);
                return list;
            }
            this.firstPosTable.put(player.m_20148_(), blockPos);
            this.sideHitTable.put(player.m_20148_(), sideHit);
            this.hitVecTable.put(player.m_20148_(), hitVec);
        } else if (rightClickNr == 2) {
            BlockPos firstPos = (BlockPos)this.firstPosTable.get(player.m_20148_());
            BlockPos secondPos = this.findSecondPos(player, firstPos, true);
            if (secondPos == null) {
                rightClickTable.put(player.m_20148_(), 1);
                return list;
            }
            this.secondPosTable.put(player.m_20148_(), secondPos);
        } else {
            list = this.findCoordinates(player, blockPos, skipRaytrace);
            rightClickTable.put(player.m_20148_(), 0);
        }
        return list;
    }

    @Override
    public List<BlockPos> findCoordinates(Player player, BlockPos blockPos, boolean skipRaytrace) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        Dictionary rightClickTable = player.f_19853_.f_46443_ ? this.rightClickClientTable : this.rightClickServerTable;
        int rightClickNr = (Integer)rightClickTable.get(player.m_20148_());
        if (rightClickNr == 0) {
            if (blockPos != null) {
                list.add(blockPos);
            }
        } else if (rightClickNr == 1) {
            BlockPos firstPos = (BlockPos)this.firstPosTable.get(player.m_20148_());
            BlockPos secondPos = this.findSecondPos(player, firstPos, true);
            if (secondPos == null) {
                return list;
            }
            int axisLimit = ReachHelper.getMaxBlocksPerAxis(player);
            int x1 = firstPos.m_123341_();
            int x2 = secondPos.m_123341_();
            int y1 = firstPos.m_123342_();
            int y2 = secondPos.m_123342_();
            int z1 = firstPos.m_123343_();
            int z2 = secondPos.m_123343_();
            if (x2 - x1 >= axisLimit) {
                x2 = x1 + axisLimit - 1;
            }
            if (x1 - x2 >= axisLimit) {
                x2 = x1 - axisLimit + 1;
            }
            if (y2 - y1 >= axisLimit) {
                y2 = y1 + axisLimit - 1;
            }
            if (y1 - y2 >= axisLimit) {
                y2 = y1 - axisLimit + 1;
            }
            if (z2 - z1 >= axisLimit) {
                z2 = z1 + axisLimit - 1;
            }
            if (z1 - z2 >= axisLimit) {
                z2 = z1 - axisLimit + 1;
            }
            list.addAll(this.getIntermediateBlocks(player, x1, y1, z1, x2, y2, z2));
        } else {
            BlockPos secondPos;
            BlockPos firstPos = (BlockPos)this.firstPosTable.get(player.m_20148_());
            BlockPos thirdPos = this.findThirdPos(player, firstPos, secondPos = this.secondPosTable.get(player.m_20148_()), skipRaytrace);
            if (thirdPos == null) {
                return list;
            }
            int axisLimit = ReachHelper.getMaxBlocksPerAxis(player);
            int x1 = firstPos.m_123341_();
            int x2 = secondPos.m_123341_();
            int x3 = thirdPos.m_123341_();
            int y1 = firstPos.m_123342_();
            int y2 = secondPos.m_123342_();
            int y3 = thirdPos.m_123342_();
            int z1 = firstPos.m_123343_();
            int z2 = secondPos.m_123343_();
            int z3 = thirdPos.m_123343_();
            if (x2 - x1 >= axisLimit) {
                x2 = x1 + axisLimit - 1;
            }
            if (x1 - x2 >= axisLimit) {
                x2 = x1 - axisLimit + 1;
            }
            if (y2 - y1 >= axisLimit) {
                y2 = y1 + axisLimit - 1;
            }
            if (y1 - y2 >= axisLimit) {
                y2 = y1 - axisLimit + 1;
            }
            if (z2 - z1 >= axisLimit) {
                z2 = z1 + axisLimit - 1;
            }
            if (z1 - z2 >= axisLimit) {
                z2 = z1 - axisLimit + 1;
            }
            if (x3 - x1 >= axisLimit) {
                x3 = x1 + axisLimit - 1;
            }
            if (x1 - x3 >= axisLimit) {
                x3 = x1 - axisLimit + 1;
            }
            if (y3 - y1 >= axisLimit) {
                y3 = y1 + axisLimit - 1;
            }
            if (y1 - y3 >= axisLimit) {
                y3 = y1 - axisLimit + 1;
            }
            if (z3 - z1 >= axisLimit) {
                z3 = z1 + axisLimit - 1;
            }
            if (z1 - z3 >= axisLimit) {
                z3 = z1 - axisLimit + 1;
            }
            list.addAll(this.getFinalBlocks(player, x1, y1, z1, x2, y2, z2, x3, y3, z3));
        }
        return list;
    }

    protected abstract BlockPos findSecondPos(Player var1, BlockPos var2, boolean var3);

    protected abstract BlockPos findThirdPos(Player var1, BlockPos var2, BlockPos var3, boolean var4);

    protected abstract List<BlockPos> getIntermediateBlocks(Player var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract List<BlockPos> getFinalBlocks(Player var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    static class HeightCriteria {
        Vec3 planeBound;
        Vec3 lineBound;
        double distToLineSq;
        double distToPlayerSq;

        HeightCriteria(Vec3 planeBound, BlockPos secondPos, Vec3 start) {
            this.planeBound = planeBound;
            this.lineBound = this.toLongestLine(this.planeBound, secondPos);
            this.distToLineSq = this.lineBound.m_82546_(this.planeBound).m_82556_();
            this.distToPlayerSq = this.planeBound.m_82546_(start).m_82556_();
        }

        private Vec3 toLongestLine(Vec3 boundVec, BlockPos secondPos) {
            BlockPos bound = new BlockPos(boundVec);
            return new Vec3((double)secondPos.m_123341_(), (double)bound.m_123342_(), (double)secondPos.m_123343_());
        }

        public boolean isValid(Vec3 start, Vec3 look, int reach, Player player, boolean skipRaytrace) {
            return BuildModes.isCriteriaValid(start, look, reach, player, skipRaytrace, this.lineBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

