/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.buildmode.BaseBuildMode;
import nl.requios.effortlessbuilding.helper.ReachHelper;

public abstract class TwoClicksBuildMode
extends BaseBuildMode {
    @Override
    public List<BlockPos> onRightClick(Player player, BlockPos blockPos, Direction sideHit, Vec3 hitVec, boolean skipRaytrace) {
        ArrayList<BlockPos> list = new ArrayList();
        Dictionary rightClickTable = player.f_19853_.f_46443_ ? this.rightClickClientTable : this.rightClickServerTable;
        int rightClickNr = (Integer)rightClickTable.get(player.m_20148_());
        rightClickTable.put(player.m_20148_(), ++rightClickNr);
        if (rightClickNr == 1) {
            if (blockPos == null) {
                rightClickTable.put(player.m_20148_(), 0);
                return list;
            }
            this.firstPosTable.put(player.m_20148_(), blockPos);
            this.sideHitTable.put(player.m_20148_(), sideHit);
            this.hitVecTable.put(player.m_20148_(), hitVec);
        } else {
            list = this.findCoordinates(player, blockPos, skipRaytrace);
            rightClickTable.put(player.m_20148_(), 0);
        }
        return list;
    }

    @Override
    public List<BlockPos> findCoordinates(Player player, BlockPos blockPos, boolean skipRaytrace) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        Dictionary rightClickTable = player.f_19853_.f_46443_ ? this.rightClickClientTable : this.rightClickServerTable;
        int rightClickNr = (Integer)rightClickTable.get(player.m_20148_());
        BlockPos firstPos = (BlockPos)this.firstPosTable.get(player.m_20148_());
        if (rightClickNr == 0) {
            if (blockPos != null) {
                list.add(blockPos);
            }
        } else {
            BlockPos secondPos = this.findSecondPos(player, firstPos, skipRaytrace);
            if (secondPos == null) {
                return list;
            }
            int axisLimit = ReachHelper.getMaxBlocksPerAxis(player);
            int x1 = firstPos.m_123341_();
            int x2 = secondPos.m_123341_();
            int y1 = firstPos.m_123342_();
            int y2 = secondPos.m_123342_();
            int z1 = firstPos.m_123343_();
            int z2 = secondPos.m_123343_();
            if (x2 - x1 >= axisLimit) {
                x2 = x1 + axisLimit - 1;
            }
            if (x1 - x2 >= axisLimit) {
                x2 = x1 - axisLimit + 1;
            }
            if (y2 - y1 >= axisLimit) {
                y2 = y1 + axisLimit - 1;
            }
            if (y1 - y2 >= axisLimit) {
                y2 = y1 - axisLimit + 1;
            }
            if (z2 - z1 >= axisLimit) {
                z2 = z1 + axisLimit - 1;
            }
            if (z1 - z2 >= axisLimit) {
                z2 = z1 - axisLimit + 1;
            }
            list.addAll(this.getAllBlocks(player, x1, y1, z1, x2, y2, z2));
        }
        return list;
    }

    protected abstract BlockPos findSecondPos(Player var1, BlockPos var2, boolean var3);

    protected abstract List<BlockPos> getAllBlocks(Player var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

