/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;

public class Array {
    public static List<BlockPos> findCoordinates(Player player, BlockPos startPos) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        ArraySettings a = ModifierSettingsManager.getModifierSettings(player).getArraySettings();
        if (!Array.isEnabled(a)) {
            return coordinates;
        }
        BlockPos pos = startPos;
        Vec3i offset = new Vec3i(a.offset.m_123341_(), a.offset.m_123342_(), a.offset.m_123343_());
        for (int i = 0; i < a.count; ++i) {
            pos = pos.m_121955_(offset);
            coordinates.add(pos);
        }
        return coordinates;
    }

    public static List<BlockState> findBlockStates(Player player, BlockPos startPos, BlockState blockState, ItemStack itemStack, List<ItemStack> itemStacks) {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        ArraySettings a = ModifierSettingsManager.getModifierSettings(player).getArraySettings();
        if (!Array.isEnabled(a)) {
            return blockStates;
        }
        BlockPos pos = startPos;
        Vec3i offset = new Vec3i(a.offset.m_123341_(), a.offset.m_123342_(), a.offset.m_123343_());
        AbstractRandomizerBagItem randomizerBagItem = null;
        IItemHandler bagInventory = null;
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof AbstractRandomizerBagItem) {
            randomizerBagItem = (AbstractRandomizerBagItem)itemStack.m_41720_();
            bagInventory = randomizerBagItem.getBagInventory(itemStack);
        }
        for (int i = 0; i < a.count; ++i) {
            pos = pos.m_121955_(offset);
            if (randomizerBagItem != null) {
                itemStack = randomizerBagItem.pickRandomStack(bagInventory);
                blockState = BuildModifiers.getBlockStateFromItem(itemStack, player, startPos, Direction.UP, new Vec3(0.0, 0.0, 0.0), InteractionHand.MAIN_HAND);
            }
            blockStates.add(blockState);
            itemStacks.add(itemStack);
        }
        return blockStates;
    }

    public static boolean isEnabled(ArraySettings a) {
        if (a == null || !a.enabled) {
            return false;
        }
        return a.offset.m_123341_() != 0 || a.offset.m_123342_() != 0 || a.offset.m_123343_() != 0;
    }

    public static class ArraySettings {
        public boolean enabled = false;
        public BlockPos offset = BlockPos.f_121853_;
        public int count = 5;

        public ArraySettings() {
        }

        public ArraySettings(boolean enabled, BlockPos offset, int count) {
            this.enabled = enabled;
            this.offset = offset;
            this.count = count;
        }

        public int getReach() {
            int x = Math.abs(this.offset.m_123341_());
            int y = Math.abs(this.offset.m_123342_());
            int z = Math.abs(this.offset.m_123343_());
            int largestOffset = Math.max(Math.max(x, y), z);
            return largestOffset * this.count;
        }
    }
}

