/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.gui.elements.GuiCheckBoxFixed;
import nl.requios.effortlessbuilding.gui.elements.GuiCollapsibleScrollEntry;
import nl.requios.effortlessbuilding.gui.elements.GuiNumberField;
import nl.requios.effortlessbuilding.gui.elements.GuiScrollPane;
import nl.requios.effortlessbuilding.helper.ReachHelper;

@OnlyIn(value=Dist.CLIENT)
public class ArraySettingsGui
extends GuiCollapsibleScrollEntry {
    protected List<GuiNumberField> arrayNumberFieldList = new ArrayList<GuiNumberField>();
    private GuiCheckBoxFixed buttonArrayEnabled;
    private GuiNumberField textArrayOffsetX;
    private GuiNumberField textArrayOffsetY;
    private GuiNumberField textArrayOffsetZ;
    private GuiNumberField textArrayCount;

    public ArraySettingsGui(GuiScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public void init(List<Renderable> renderables) {
        super.init(renderables);
        int y = this.top;
        this.buttonArrayEnabled = new GuiCheckBoxFixed(this.left - 15 + 8, y, "", false){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                ArraySettingsGui.this.setCollapsed(!ArraySettingsGui.this.buttonArrayEnabled.isChecked());
            }
        };
        renderables.add((Renderable)this.buttonArrayEnabled);
        y = this.top + 20;
        this.textArrayOffsetX = new GuiNumberField(this.font, renderables, this.left + 70, y, 50, 18);
        this.textArrayOffsetX.setNumber(0.0);
        this.textArrayOffsetX.setTooltip((Component)Component.m_237113_((String)"How much each copy is shifted."));
        this.arrayNumberFieldList.add(this.textArrayOffsetX);
        this.textArrayOffsetY = new GuiNumberField(this.font, renderables, this.left + 140, y, 50, 18);
        this.textArrayOffsetY.setNumber(0.0);
        this.textArrayOffsetY.setTooltip((Component)Component.m_237113_((String)"How much each copy is shifted."));
        this.arrayNumberFieldList.add(this.textArrayOffsetY);
        this.textArrayOffsetZ = new GuiNumberField(this.font, renderables, this.left + 210, y, 50, 18);
        this.textArrayOffsetZ.setNumber(0.0);
        this.textArrayOffsetZ.setTooltip((Component)Component.m_237113_((String)"How much each copy is shifted."));
        this.arrayNumberFieldList.add(this.textArrayOffsetZ);
        y = this.top + 50;
        this.textArrayCount = new GuiNumberField(this.font, renderables, this.left + 55, y, 50, 18);
        this.textArrayCount.setNumber(5.0);
        this.textArrayCount.setTooltip((Component)Component.m_237113_((String)"How many copies should be made."));
        this.arrayNumberFieldList.add(this.textArrayCount);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((Player)this.mc.f_91074_);
        if (modifierSettings != null) {
            Array.ArraySettings a = modifierSettings.getArraySettings();
            this.buttonArrayEnabled.setIsChecked(a.enabled);
            this.textArrayOffsetX.setNumber(a.offset.m_123341_());
            this.textArrayOffsetY.setNumber(a.offset.m_123342_());
            this.textArrayOffsetZ.setNumber(a.offset.m_123343_());
            this.textArrayCount.setNumber(a.count);
        }
        this.setCollapsed(!this.buttonArrayEnabled.isChecked());
    }

    @Override
    public void updateScreen() {
        this.arrayNumberFieldList.forEach(GuiNumberField::update);
    }

    @Override
    public void drawEntry(PoseStack ms, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int yy = y;
        int offset = 8;
        this.buttonArrayEnabled.m_86412_(ms, mouseX, mouseY, partialTicks);
        if (this.buttonArrayEnabled.isChecked()) {
            this.buttonArrayEnabled.m_252888_(yy);
            this.font.m_92883_(ms, "Array enabled", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            yy = y + 20;
            this.font.m_92883_(ms, "Offset", (float)(this.left + offset), (float)(yy + 5), 0xFFFFFF);
            this.font.m_92883_(ms, "X", (float)(this.left + 50 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textArrayOffsetX.y = yy;
            this.font.m_92883_(ms, "Y", (float)(this.left + 120 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textArrayOffsetY.y = yy;
            this.font.m_92883_(ms, "Z", (float)(this.left + 190 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textArrayOffsetZ.y = yy;
            yy = y + 50;
            this.font.m_92883_(ms, "Count", (float)(this.left + offset), (float)(yy + 5), 0xFFFFFF);
            this.textArrayCount.y = yy;
            int currentReach = Math.max(-1, this.getArrayReach());
            int maxReach = ReachHelper.getMaxReach((Player)this.mc.f_91074_);
            ChatFormatting reachColor = this.isCurrentReachValid(currentReach, maxReach) ? ChatFormatting.GRAY : ChatFormatting.RED;
            String reachText = "Reach: " + reachColor + currentReach + ChatFormatting.GRAY + "/" + ChatFormatting.GRAY + maxReach;
            this.font.m_92883_(ms, reachText, (float)(this.left + 176 + offset), (float)(yy + 5), 0xFFFFFF);
            this.arrayNumberFieldList.forEach(numberField -> numberField.drawNumberField(ms, mouseX, mouseY, partialTicks));
        } else {
            this.buttonArrayEnabled.m_252888_(yy);
            this.font.m_92883_(ms, "Array disabled", (float)(this.left + offset), (float)(yy + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(PoseStack ms, Screen guiScreen, int mouseX, int mouseY) {
        if (this.buttonArrayEnabled.isChecked()) {
            this.arrayNumberFieldList.forEach(numberField -> numberField.drawTooltip(ms, this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (GuiNumberField numberField : this.arrayNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideArrayEnabledLabel;
        this.arrayNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideArrayEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideArrayEnabledLabel) {
            this.buttonArrayEnabled.m_7435_(this.mc.m_91106_());
            this.buttonArrayEnabled.m_5716_(mouseX, mouseY);
        }
        return true;
    }

    public Array.ArraySettings getArraySettings() {
        boolean arrayEnabled = this.buttonArrayEnabled.isChecked();
        BlockPos arrayOffset = new BlockPos(0, 0, 0);
        try {
            arrayOffset = new BlockPos(this.textArrayOffsetX.getNumber(), this.textArrayOffsetY.getNumber(), this.textArrayOffsetZ.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((Player)this.mc.f_91074_, "Array offset not a valid number.");
        }
        int arrayCount = 5;
        try {
            arrayCount = (int)this.textArrayCount.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((Player)this.mc.f_91074_, "Array count not a valid number.");
        }
        return new Array.ArraySettings(arrayEnabled, arrayOffset, arrayCount);
    }

    @Override
    protected String getName() {
        return "Array";
    }

    @Override
    protected int getExpandedHeight() {
        return 80;
    }

    private int getArrayReach() {
        try {
            double x = Math.abs(this.textArrayOffsetX.getNumber());
            double y = Math.abs(this.textArrayOffsetY.getNumber());
            double z = Math.abs(this.textArrayOffsetZ.getNumber());
            double largestOffset = Math.max(Math.max(x, y), z);
            return (int)(largestOffset * this.textArrayCount.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            return -1;
        }
    }

    private boolean isCurrentReachValid(int currentReach, int maxReach) {
        return currentReach <= maxReach && currentReach > -1;
    }
}

