/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class SlotGui
extends AbstractContainerEventHandler
implements Renderable {
    protected final Minecraft minecraft;
    protected final int itemHeight;
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected int yDrag = -2;
    protected double yo;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public SlotGui(Minecraft mcIn, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        this.minecraft = mcIn;
        this.width = width;
        this.height = height;
        this.y0 = topIn;
        this.y1 = bottomIn;
        this.itemHeight = slotHeightIn;
        this.x0 = 0;
        this.x1 = width;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int p_selectItem_1_, int p_selectItem_2_, double p_selectItem_3_, double p_selectItem_5_) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected void updateItemPosition(int p_updateItemPosition_1_, int p_updateItemPosition_2_, int p_updateItemPosition_3_, float p_updateItemPosition_4_) {
    }

    protected abstract void renderItem(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    protected void renderHeader(int p_renderHeader_1_, int p_renderHeader_2_, Tesselator p_renderHeader_3_) {
    }

    protected void clickedHeader(int p_clickedHeader_1_, int p_clickedHeader_2_) {
    }

    public int getItemAtPosition(double p_getItemAtPosition_1_, double p_getItemAtPosition_3_) {
        int i = this.x0 + this.width / 2 - this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2 + this.getRowWidth() / 2;
        int k = Mth.m_14107_((double)(p_getItemAtPosition_3_ - (double)this.y0)) - this.headerHeight + (int)this.yo - 4;
        int l = k / this.itemHeight;
        return p_getItemAtPosition_1_ < (double)this.getScrollbarPosition() && p_getItemAtPosition_1_ >= (double)i && p_getItemAtPosition_1_ <= (double)j && l >= 0 && k >= 0 && l < this.getItemCount() ? l : -1;
    }

    protected void capYPosition() {
        this.yo = Mth.m_14008_((double)this.yo, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScroll() {
        return (int)this.yo;
    }

    public boolean isMouseInList(double p_isMouseInList_1_, double p_isMouseInList_3_) {
        return p_isMouseInList_3_ >= (double)this.y0 && p_isMouseInList_3_ <= (double)this.y1 && p_isMouseInList_1_ >= (double)this.x0 && p_isMouseInList_1_ <= (double)this.x1;
    }

    public abstract void m_86412_(PoseStack var1, int var2, int var3, float var4);

    protected void updateScrollingState(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
        this.scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.getScrollbarPosition() && p_updateScrollingState_1_ < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.updateScrollingState(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.isVisible() && this.isMouseInList(p_mouseClicked_1_, p_mouseClicked_3_)) {
            int i = this.getItemAtPosition(p_mouseClicked_1_, p_mouseClicked_3_);
            if (i == -1 && p_mouseClicked_5_ == 0) {
                this.clickedHeader((int)(p_mouseClicked_1_ - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(p_mouseClicked_3_ - (double)this.y0) + (int)this.yo - 4);
                return true;
            }
            if (i != -1 && this.selectItem(i, p_mouseClicked_5_, p_mouseClicked_1_, p_mouseClicked_3_)) {
                if (this.m_6702_().size() > i) {
                    this.m_7522_(this.m_6702_().get(i));
                }
                this.m_7897_(true);
                return true;
            }
            return this.scrolling;
        }
        return false;
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (this.m_7222_() != null) {
            this.m_7222_().m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
        return false;
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (this.isVisible() && p_mouseDragged_5_ == 0 && this.scrolling) {
            if (p_mouseDragged_3_ < (double)this.y0) {
                this.yo = 0.0;
            } else if (p_mouseDragged_3_ > (double)this.y1) {
                this.yo = this.getMaxScroll();
            } else {
                double d0 = this.getMaxScroll();
                if (d0 < 1.0) {
                    d0 = 1.0;
                }
                int i = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                double d1 = d0 / (double)(this.y1 - this.y0 - (i = Mth.m_14045_((int)i, (int)32, (int)(this.y1 - this.y0 - 8))));
                if (d1 < 1.0) {
                    d1 = 1.0;
                }
                this.yo += p_mouseDragged_8_ * d1;
                this.capYPosition();
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.isVisible()) {
            return false;
        }
        this.yo -= p_mouseScrolled_5_ * (double)this.itemHeight / 2.0;
        return true;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ == 264) {
            this.moveSelection(1);
            return true;
        }
        if (p_keyPressed_1_ == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int p_moveSelection_1_) {
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        return this.isVisible() && super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean m_5953_(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return this.isMouseInList(p_isMouseOver_1_, p_isMouseOver_3_);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(PoseStack ms, int p_renderList_1_, int p_renderList_2_, int p_renderList_3_, int p_renderList_4_, float p_renderList_5_) {
        int i = this.getItemCount();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        for (int j = 0; j < i; ++j) {
            int k = p_renderList_2_ + j * this.itemHeight + this.headerHeight;
            int l = this.itemHeight - 4;
            if (k > this.y1 || k + l < this.y0) {
                this.updateItemPosition(j, p_renderList_1_, k, p_renderList_5_);
            }
            if (this.renderSelection && this.isSelectedItem(j)) {
                int i1 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int j1 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                RenderSystem.m_69472_();
                float f = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.m_157429_((float)f, (float)f, (float)f, (float)1.0f);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                bufferbuilder.m_5483_((double)i1, (double)(k + l + 2), 0.0).m_5752_();
                bufferbuilder.m_5483_((double)j1, (double)(k + l + 2), 0.0).m_5752_();
                bufferbuilder.m_5483_((double)j1, (double)(k - 2), 0.0).m_5752_();
                bufferbuilder.m_5483_((double)i1, (double)(k - 2), 0.0).m_5752_();
                tessellator.m_85914_();
                RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                bufferbuilder.m_5483_((double)(i1 + 1), (double)(k + l + 1), 0.0).m_5752_();
                bufferbuilder.m_5483_((double)(j1 - 1), (double)(k + l + 1), 0.0).m_5752_();
                bufferbuilder.m_5483_((double)(j1 - 1), (double)(k - 1), 0.0).m_5752_();
                bufferbuilder.m_5483_((double)(i1 + 1), (double)(k - 1), 0.0).m_5752_();
                tessellator.m_85914_();
                RenderSystem.m_69493_();
            }
            this.renderItem(ms, j, p_renderList_1_, k, l, p_renderList_3_, p_renderList_4_, p_renderList_5_);
        }
    }

    protected boolean isFocused() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }
}

