/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReachUpgrade1Item
extends Item {
    public ReachUpgrade1Item() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (player.m_7500_()) {
            if (world.f_46443_) {
                EffortlessBuilding.log(player, "Reach upgrades are not necessary in creative.");
            }
            if (world.f_46443_) {
                EffortlessBuilding.log(player, "Still want increased reach? Use the config.");
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        int currentLevel = modifierSettings.getReachUpgrade();
        if (currentLevel == 0) {
            modifierSettings.setReachUpgrade(1);
            if (world.f_46443_) {
                EffortlessBuilding.log(player, "Upgraded reach to " + ReachHelper.getMaxReach(player));
            }
            player.m_21008_(hand, ItemStack.f_41583_);
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("entity.player.levelup"));
            player.m_5496_(soundEvent, 1.0f, 1.0f);
        } else if (currentLevel > 0) {
            if (world.f_46443_) {
                EffortlessBuilding.log(player, "Already used this upgrade! Current reach is " + ReachHelper.getMaxReach(player) + ".");
            }
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("item.armor.equip_leather"));
            player.m_5496_(soundEvent, 1.0f, 1.0f);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Consume to increase reach to " + ChatFormatting.BLUE + BuildConfig.reach.maxReachLevel1.get())));
    }
}

