/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.proxy;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.gui.DiamondRandomizerBagScreen;
import nl.requios.effortlessbuilding.gui.GoldenRandomizerBagScreen;
import nl.requios.effortlessbuilding.gui.RandomizerBagScreen;
import nl.requios.effortlessbuilding.gui.buildmode.PlayerSettingsGui;
import nl.requios.effortlessbuilding.gui.buildmode.RadialMenu;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifierSettingsGui;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.network.BlockBrokenMessage;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;
import nl.requios.effortlessbuilding.network.ModeActionMessage;
import nl.requios.effortlessbuilding.network.ModifierSettingsMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.IProxy;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ClientProxy
implements IProxy {
    public static KeyMapping[] keyBindings;
    public static HitResult previousLookAt;
    public static HitResult currentLookAt;
    public static int ticksInGame;
    private static int placeCooldown;
    private static int breakCooldown;

    @Override
    public void setup(FMLCommonSetupEvent event) {
    }

    @Override
    public void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)EffortlessBuilding.RANDOMIZER_BAG_CONTAINER.get()), RandomizerBagScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)EffortlessBuilding.GOLDEN_RANDOMIZER_BAG_CONTAINER.get()), GoldenRandomizerBagScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)EffortlessBuilding.DIAMOND_RANDOMIZER_BAG_CONTAINER.get()), DiamondRandomizerBagScreen::new);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Screen gui;
        if (event.phase == TickEvent.Phase.START) {
            ClientProxy.onMouseInput();
            HitResult objectMouseOver = Minecraft.m_91087_().f_91077_;
            if (objectMouseOver == null) {
                return;
            }
            if (currentLookAt == null) {
                currentLookAt = objectMouseOver;
                previousLookAt = objectMouseOver;
                return;
            }
            if (objectMouseOver.m_6662_() == HitResult.Type.BLOCK) {
                if (currentLookAt.m_6662_() != HitResult.Type.BLOCK) {
                    currentLookAt = objectMouseOver;
                    previousLookAt = objectMouseOver;
                } else if (((BlockHitResult)currentLookAt).m_82425_() != ((BlockHitResult)objectMouseOver).m_82425_()) {
                    previousLookAt = currentLookAt;
                    currentLookAt = objectMouseOver;
                }
            }
        } else if (!(event.phase != TickEvent.Phase.END || (gui = Minecraft.m_91087_().f_91080_) != null && gui.m_7043_())) {
            ++ticksInGame;
        }
    }

    private static void onMouseInput() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings((Player)player).getBuildMode();
        if (mc.f_91080_ != null || buildMode == BuildModes.BuildModeEnum.NORMAL || RadialMenu.instance.isVisible()) {
            return;
        }
        if (mc.f_91066_.f_92095_.m_90857_()) {
            if (placeCooldown <= 0) {
                placeCooldown = 4;
                ItemStack currentItemStack = player.m_21120_(InteractionHand.MAIN_HAND);
                if (currentItemStack.m_41720_() instanceof BlockItem || CompatHelper.isItemBlockProxy(currentItemStack) && !player.m_6144_()) {
                    ItemStack itemStack = CompatHelper.getItemBlockFromStack(currentItemStack);
                    HitResult lookingAt = ClientProxy.getLookingAt((Player)player);
                    if (lookingAt != null && lookingAt.m_6662_() == HitResult.Type.BLOCK) {
                        BlockHitResult blockLookingAt = (BlockHitResult)lookingAt;
                        BuildModes.onBlockPlacedMessage((Player)player, new BlockPlacedMessage(blockLookingAt, true));
                        PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage(blockLookingAt, true));
                        if (blockLookingAt.m_82450_().m_82546_(player.m_20299_(1.0f)).m_82556_() > 25.0 && itemStack.m_41720_() instanceof BlockItem) {
                            BlockState state = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
                            BlockPos blockPos = blockLookingAt.m_82425_();
                            SoundType soundType = state.m_60734_().getSoundType(state, (LevelReader)player.f_19853_, blockPos, (Entity)player);
                            player.f_19853_.m_5594_((Player)player, player.m_20183_(), soundType.m_56777_(), SoundSource.BLOCKS, 0.4f, soundType.m_56774_());
                            player.m_6674_(InteractionHand.MAIN_HAND);
                        }
                    } else {
                        BuildModes.onBlockPlacedMessage((Player)player, new BlockPlacedMessage());
                        PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage());
                    }
                }
            } else if (buildMode == BuildModes.BuildModeEnum.NORMAL_PLUS) {
                --placeCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    placeCooldown = 0;
                }
            }
        } else {
            placeCooldown = 0;
        }
        if (mc.f_91066_.f_92096_.m_90857_()) {
            if (breakCooldown <= 0) {
                breakCooldown = 4;
                HitResult lookingAt = ClientProxy.getLookingAt((Player)player);
                if (lookingAt != null && lookingAt.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult blockLookingAt = (BlockHitResult)lookingAt;
                    BuildModes.onBlockBrokenMessage((Player)player, new BlockBrokenMessage(blockLookingAt));
                    PacketHandler.INSTANCE.sendToServer((Object)new BlockBrokenMessage(blockLookingAt));
                    if (blockLookingAt.m_82450_().m_82546_(player.m_20299_(1.0f)).m_82556_() > 25.0) {
                        BlockPos blockPos = blockLookingAt.m_82425_();
                        BlockState state = player.f_19853_.m_8055_(blockPos);
                        SoundType soundtype = state.m_60734_().getSoundType(state, (LevelReader)player.f_19853_, blockPos, (Entity)player);
                        player.f_19853_.m_5594_((Player)player, player.m_20183_(), soundtype.m_56775_(), SoundSource.BLOCKS, 0.4f, soundtype.m_56774_());
                        player.m_6674_(InteractionHand.MAIN_HAND);
                    }
                } else {
                    BuildModes.onBlockBrokenMessage((Player)player, new BlockBrokenMessage());
                    PacketHandler.INSTANCE.sendToServer((Object)new BlockBrokenMessage());
                }
            } else if (buildMode == BuildModes.BuildModeEnum.NORMAL_PLUS) {
                --breakCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    breakCooldown = 0;
                }
            }
        } else {
            breakCooldown = 0;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onKeyPress(InputEvent.Key event) {
        ModeOptions.ActionEnum action;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (keyBindings[0].m_90859_()) {
            ClientProxy.openModifierSettings();
        }
        if (keyBindings[1].m_90859_()) {
            ModifierSettingsManager.ModifierSettings modifierSettings;
            modifierSettings.setQuickReplace(!(modifierSettings = ModifierSettingsManager.getModifierSettings((Player)player)).doQuickReplace());
            EffortlessBuilding.log((Player)player, "Set " + ChatFormatting.GOLD + "Quick Replace " + ChatFormatting.RESET + (modifierSettings.doQuickReplace() ? "on" : "off"));
            PacketHandler.INSTANCE.sendToServer((Object)new ModifierSettingsMessage(modifierSettings));
        }
        if (keyBindings[2].m_90857_()) {
            if (ReachHelper.getMaxReach((Player)player) > 0) {
                if (!RadialMenu.instance.isVisible()) {
                    Minecraft.m_91087_().m_91152_((Screen)RadialMenu.instance);
                }
            } else {
                EffortlessBuilding.log((Player)player, "Build modes are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
            }
        }
        if (keyBindings[3].m_90859_()) {
            action = ModeOptions.ActionEnum.UNDO;
            ModeOptions.performAction((Player)player, action);
            PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(action));
        }
        if (keyBindings[4].m_90859_()) {
            action = ModeOptions.ActionEnum.REDO;
            ModeOptions.performAction((Player)player, action);
            PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(action));
        }
        if (keyBindings[5].m_90859_()) {
            BuildModes.BuildModeEnum currentBuildMode = ModeSettingsManager.getModeSettings((Player)player).getBuildMode();
            if (currentBuildMode.options.length > 0) {
                ModeOptions.OptionEnum option = currentBuildMode.options[0];
                if (option.actions.length >= 2) {
                    if (ModeOptions.getOptionSetting(option) == option.actions[0]) {
                        ModeOptions.performAction((Player)player, option.actions[1]);
                        PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(option.actions[1]));
                    } else {
                        ModeOptions.performAction((Player)player, option.actions[0]);
                        PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(option.actions[0]));
                    }
                }
            }
        }
    }

    public static void openModifierSettings() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (ReachHelper.getMaxReach((Player)player) == 0) {
            EffortlessBuilding.log((Player)player, "Build modifiers are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
        } else {
            mc.m_91152_((Screen)new ModifierSettingsGui());
        }
    }

    public static void openPlayerSettings() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new PlayerSettingsGui());
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            BuildModes.initializeMode((Player)player);
        }
    }

    public static boolean isKeybindDown(int keybindIndex) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keyBindings[2].getKey().m_84873_());
    }

    public static HitResult getLookingAt(Player player) {
        Level world = player.f_19853_;
        float raytraceRange = ReachHelper.getPlacementReach(player);
        Vec3 look = player.m_20154_();
        Vec3 start = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        Vec3 end = new Vec3(player.m_20185_() + look.f_82479_ * (double)raytraceRange, player.m_20186_() + (double)player.m_20192_() + look.f_82480_ * (double)raytraceRange, player.m_20189_() + look.f_82481_ * (double)raytraceRange);
        return world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
    }

    @Override
    public Player getPlayerEntityFromContext(Supplier<NetworkEvent.Context> ctx) {
        return ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT ? Minecraft.m_91087_().f_91074_ : ctx.get().getSender();
    }

    @Override
    public void logTranslate(Player player, String prefix, String translationKey, String suffix, boolean actionBar) {
        EffortlessBuilding.log((Player)Minecraft.m_91087_().f_91074_, prefix + I18n.m_118938_((String)translationKey, (Object[])new Object[0]) + suffix, actionBar);
    }

    static {
        ticksInGame = 0;
        placeCooldown = 0;
        breakCooldown = 0;
    }
}

