/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.IBuildMode;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;
import nl.requios.effortlessbuilding.proxy.ClientProxy;
import nl.requios.effortlessbuilding.render.RenderHandler;

@OnlyIn(value=Dist.CLIENT)
public class BlockPreviewRenderer {
    private static final List<PlacedData> placedDataList = new ArrayList<PlacedData>();
    private static List<BlockPos> previousCoordinates;
    private static List<BlockState> previousBlockStates;
    private static List<ItemStack> previousItemStacks;
    private static BlockPos previousFirstPos;
    private static BlockPos previousSecondPos;
    private static int soundTime;

    public static void render(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, Player player, ModifierSettingsManager.ModifierSettings modifierSettings, ModeSettingsManager.ModeSettings modeSettings) {
        ItemStack mainhand;
        if (((Boolean)BuildConfig.visuals.useShaders.get()).booleanValue()) {
            for (int i = 0; i < placedDataList.size(); ++i) {
                PlacedData placed2 = placedDataList.get(i);
                if (placed2.coordinates == null || placed2.coordinates.isEmpty()) continue;
                double totalTime = Mth.m_14085_((double)30.0, (double)60.0, (double)(placed2.firstPos.m_123331_((Vec3i)placed2.secondPos) / 100.0)) * (Double)BuildConfig.visuals.dissolveTimeMultiplier.get();
                float dissolve = ((float)ClientProxy.ticksInGame - placed2.time) / (float)totalTime;
                BlockPreviewRenderer.renderBlockPreviews(matrixStack, renderTypeBuffer, placed2.coordinates, placed2.blockStates, placed2.itemStacks, dissolve, placed2.firstPos, placed2.secondPos, false, placed2.breaking);
            }
        }
        placedDataList.removeIf(placed -> {
            double totalTime = Mth.m_14085_((double)30.0, (double)60.0, (double)(placed.firstPos.m_123331_((Vec3i)placed.secondPos) / 100.0)) * (Double)BuildConfig.visuals.dissolveTimeMultiplier.get();
            return (double)placed.time + totalTime < (double)ClientProxy.ticksInGame;
        });
        HitResult lookingAt = ClientProxy.getLookingAt(player);
        if (modeSettings.getBuildMode() == BuildModes.BuildModeEnum.NORMAL) {
            lookingAt = Minecraft.m_91087_().f_91077_;
        }
        boolean noBlockInHand = (mainhand = player.m_21205_()).m_41619_() || !CompatHelper.isItemBlockProxy(mainhand);
        BlockPos startPos = null;
        Direction sideHit = null;
        Vec3 hitVec = null;
        if (lookingAt != null && lookingAt.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockLookingAt = (BlockHitResult)lookingAt;
            startPos = blockLookingAt.m_82425_();
            boolean replaceable = player.f_19853_.m_8055_(startPos).m_60767_().m_76336_();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos, blockLookingAt.m_82434_());
            if (!(modifierSettings.doQuickReplace() || noBlockInHand || replaceable || becomesDoubleSlab)) {
                startPos = startPos.m_121945_(blockLookingAt.m_82434_());
            }
            if (modifierSettings.doQuickReplace() && !noBlockInHand && replaceable) {
                startPos = startPos.m_7495_();
            }
            sideHit = blockLookingAt.m_82434_();
            hitVec = blockLookingAt.m_82450_();
        }
        if (BlockPreviewRenderer.doRenderBlockPreviews(modifierSettings, modeSettings, startPos)) {
            HitResult breakingRaytrace;
            if (BuildModes.isActive(player)) {
                IBuildMode buildModeInstance = modeSettings.getBuildMode().instance;
                if (buildModeInstance.getSideHit(player) != null) {
                    sideHit = buildModeInstance.getSideHit(player);
                }
                if (buildModeInstance.getHitVec(player) != null) {
                    hitVec = buildModeInstance.getHitVec(player);
                }
            }
            if (sideHit != null) {
                boolean breaking = BuildModes.currentlyBreakingClient.get(player) != null && BuildModes.currentlyBreakingClient.get(player) != false;
                List<BlockPos> startCoordinates = BuildModes.findCoordinates(player, startPos, breaking || modifierSettings.doQuickReplace());
                BlockPos firstPos = BlockPos.f_121853_;
                BlockPos secondPos = BlockPos.f_121853_;
                if (!startCoordinates.isEmpty()) {
                    firstPos = startCoordinates.get(0);
                    secondPos = startCoordinates.get(startCoordinates.size() - 1);
                }
                int limit = ReachHelper.getMaxBlocksPlacedAtOnce(player);
                if (startCoordinates.size() > limit) {
                    startCoordinates = startCoordinates.subList(0, limit);
                }
                List<BlockPos> newCoordinates = BuildModifiers.findCoordinates(player, startCoordinates);
                BlockPreviewRenderer.sortOnDistanceToPlayer(newCoordinates, player);
                hitVec = new Vec3(Math.abs(hitVec.f_82479_ - (double)((int)hitVec.f_82479_)), Math.abs(hitVec.f_82480_ - (double)((int)hitVec.f_82480_)), Math.abs(hitVec.f_82481_ - (double)((int)hitVec.f_82481_)));
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                List<Object> blockStates = new ArrayList();
                if (breaking) {
                    for (BlockPos coordinate : newCoordinates) {
                        blockStates.add(player.f_19853_.m_8055_(coordinate));
                    }
                } else {
                    blockStates = BuildModifiers.findBlockStates(player, startCoordinates, hitVec, sideHit, itemStacks);
                }
                if (!BuildModifiers.compareCoordinates(previousCoordinates, newCoordinates)) {
                    previousCoordinates = newCoordinates;
                    previousBlockStates = blockStates;
                    previousItemStacks = itemStacks;
                    previousFirstPos = firstPos;
                    previousSecondPos = secondPos;
                    AbstractRandomizerBagItem.renewRandomness();
                    if (newCoordinates.size() > 1 && blockStates.size() > 1 && soundTime < ClientProxy.ticksInGame - 0) {
                        soundTime = ClientProxy.ticksInGame;
                        if (blockStates.get(0) != null) {
                            SoundType soundType = ((BlockState)blockStates.get(0)).m_60734_().getSoundType((BlockState)blockStates.get(0), (LevelReader)player.f_19853_, newCoordinates.get(0), (Entity)player);
                            player.f_19853_.m_5594_(player, player.m_20183_(), breaking ? soundType.m_56775_() : soundType.m_56777_(), SoundSource.BLOCKS, 0.3f, 0.8f);
                        }
                    }
                }
                if (blockStates.size() != 0 && newCoordinates.size() == blockStates.size()) {
                    int blockCount;
                    if (((Boolean)BuildConfig.visuals.useShaders.get()).booleanValue() && newCoordinates.size() < (Integer)BuildConfig.visuals.shaderThreshold.get()) {
                        blockCount = BlockPreviewRenderer.renderBlockPreviews(matrixStack, renderTypeBuffer, newCoordinates, blockStates, itemStacks, 0.0f, firstPos, secondPos, !breaking, breaking);
                    } else {
                        VertexConsumer buffer = RenderHandler.beginLines(renderTypeBuffer);
                        Vec3 color = new Vec3(1.0, 1.0, 1.0);
                        if (breaking) {
                            color = new Vec3(1.0, 0.0, 0.0);
                        }
                        for (int i = newCoordinates.size() - 1; i >= 0; --i) {
                            VoxelShape collisionShape = ((BlockState)blockStates.get(i)).m_60812_((BlockGetter)player.f_19853_, newCoordinates.get(i));
                            RenderHandler.renderBlockOutline(matrixStack, buffer, newCoordinates.get(i), collisionShape, color);
                        }
                        RenderHandler.endLines(renderTypeBuffer);
                        blockCount = newCoordinates.size();
                    }
                    if (BuildModes.isActive(player)) {
                        int minX = Integer.MAX_VALUE;
                        int maxX = Integer.MIN_VALUE;
                        int minY = Integer.MAX_VALUE;
                        int maxY = Integer.MIN_VALUE;
                        int minZ = Integer.MAX_VALUE;
                        int maxZ = Integer.MIN_VALUE;
                        for (BlockPos pos : startCoordinates) {
                            if (pos.m_123341_() < minX) {
                                minX = pos.m_123341_();
                            }
                            if (pos.m_123341_() > maxX) {
                                maxX = pos.m_123341_();
                            }
                            if (pos.m_123342_() < minY) {
                                minY = pos.m_123342_();
                            }
                            if (pos.m_123342_() > maxY) {
                                maxY = pos.m_123342_();
                            }
                            if (pos.m_123343_() < minZ) {
                                minZ = pos.m_123343_();
                            }
                            if (pos.m_123343_() <= maxZ) continue;
                            maxZ = pos.m_123343_();
                        }
                        BlockPos dim = new BlockPos(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
                        Object dimensions = "(";
                        if (dim.m_123341_() > 1) {
                            dimensions = (String)dimensions + dim.m_123341_() + "x";
                        }
                        if (dim.m_123343_() > 1) {
                            dimensions = (String)dimensions + dim.m_123343_() + "x";
                        }
                        if (dim.m_123342_() > 1) {
                            dimensions = (String)dimensions + dim.m_123342_() + "x";
                        }
                        if (((String)(dimensions = ((String)dimensions).substring(0, ((String)dimensions).length() - 1))).length() > 1) {
                            dimensions = (String)dimensions + ")";
                        }
                        EffortlessBuilding.log(player, blockCount + " blocks " + (String)dimensions, true);
                    }
                }
            }
            VertexConsumer buffer = RenderHandler.beginLines(renderTypeBuffer);
            HitResult objectMouseOver = Minecraft.m_91087_().f_91077_;
            HitResult hitResult = breakingRaytrace = ReachHelper.canBreakFar(player) ? lookingAt : objectMouseOver;
            if (player.m_7500_() && noBlockInHand && breakingRaytrace != null && breakingRaytrace.m_6662_() == HitResult.Type.BLOCK) {
                int i;
                BlockHitResult blockBreakingRaytrace = (BlockHitResult)breakingRaytrace;
                List<BlockPos> breakCoordinates = BuildModifiers.findCoordinates(player, blockBreakingRaytrace.m_82425_());
                boolean excludeFirst = objectMouseOver != null && objectMouseOver.m_6662_() == HitResult.Type.BLOCK;
                int n = i = excludeFirst ? 1 : 0;
                while (i < breakCoordinates.size()) {
                    BlockPos coordinate = breakCoordinates.get(i);
                    BlockState blockState = player.f_19853_.m_8055_(coordinate);
                    if (!blockState.m_60795_() && (SurvivalHelper.canBreak(player.f_19853_, player, coordinate) || i == 0)) {
                        VoxelShape collisionShape = blockState.m_60812_((BlockGetter)player.f_19853_, coordinate);
                        RenderHandler.renderBlockOutline(matrixStack, buffer, coordinate, collisionShape, new Vec3(0.0, 0.0, 0.0));
                    }
                    ++i;
                }
            }
            RenderHandler.endLines(renderTypeBuffer);
        }
    }

    public static boolean doRenderBlockPreviews(ModifierSettingsManager.ModifierSettings modifierSettings, ModeSettingsManager.ModeSettings modeSettings, BlockPos startPos) {
        return modeSettings.getBuildMode() != BuildModes.BuildModeEnum.NORMAL || startPos != null && BuildModifiers.isEnabled(modifierSettings, startPos) || (Boolean)BuildConfig.visuals.alwaysShowBlockPreview.get() != false;
    }

    protected static int renderBlockPreviews(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, List<BlockPos> coordinates, List<BlockState> blockStates, List<ItemStack> itemStacks, float dissolve, BlockPos firstPos, BlockPos secondPos, boolean checkCanPlace, boolean red) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((Player)player);
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        int blocksValid = 0;
        if (coordinates.isEmpty()) {
            return blocksValid;
        }
        for (int i = coordinates.size() - 1; i >= 0; --i) {
            ItemStack itemstack;
            BlockPos blockPos = coordinates.get(i);
            BlockState blockState = blockStates.get(i);
            ItemStack itemStack = itemstack = itemStacks.isEmpty() ? ItemStack.f_41583_ : itemStacks.get(i);
            if (CompatHelper.isItemBlockProxy(itemstack)) {
                itemstack = CompatHelper.getItemBlockByState(itemstack, blockState);
            }
            if (checkCanPlace && !SurvivalHelper.canPlace(player.f_19853_, (Player)player, blockPos, blockState, itemstack, modifierSettings.doQuickReplace(), Direction.UP)) continue;
            RenderHandler.renderBlockPreview(matrixStack, renderTypeBuffer, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, red);
            ++blocksValid;
        }
        return blocksValid;
    }

    public static void onBlocksPlaced() {
        BlockPreviewRenderer.onBlocksPlaced(previousCoordinates, previousItemStacks, previousBlockStates, previousFirstPos, previousSecondPos);
    }

    public static void onBlocksPlaced(List<BlockPos> coordinates, List<ItemStack> itemStacks, List<BlockState> blockStates, BlockPos firstPos, BlockPos secondPos) {
        ModeSettingsManager.ModeSettings modeSettings;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((Player)player);
        if (BlockPreviewRenderer.doRenderBlockPreviews(modifierSettings, modeSettings = ModeSettingsManager.getModeSettings((Player)player), firstPos) && !coordinates.isEmpty() && blockStates.size() == coordinates.size() && coordinates.size() > 1 && coordinates.size() < (Integer)BuildConfig.visuals.shaderThreshold.get()) {
            placedDataList.add(new PlacedData(ClientProxy.ticksInGame, coordinates, blockStates, itemStacks, firstPos, secondPos, false));
        }
    }

    public static void onBlocksBroken() {
        BlockPreviewRenderer.onBlocksBroken(previousCoordinates, previousItemStacks, previousBlockStates, previousFirstPos, previousSecondPos);
    }

    public static void onBlocksBroken(List<BlockPos> coordinates, List<ItemStack> itemStacks, List<BlockState> blockStates, BlockPos firstPos, BlockPos secondPos) {
        ModeSettingsManager.ModeSettings modeSettings;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((Player)player);
        if (BlockPreviewRenderer.doRenderBlockPreviews(modifierSettings, modeSettings = ModeSettingsManager.getModeSettings((Player)player), firstPos) && !coordinates.isEmpty() && blockStates.size() == coordinates.size() && coordinates.size() > 1 && coordinates.size() < (Integer)BuildConfig.visuals.shaderThreshold.get()) {
            BlockPreviewRenderer.sortOnDistanceToPlayer(coordinates, (Player)player);
            placedDataList.add(new PlacedData(ClientProxy.ticksInGame, coordinates, blockStates, itemStacks, firstPos, secondPos, true));
        }
    }

    private static void sortOnDistanceToPlayer(List<BlockPos> coordinates, Player player) {
        Collections.sort(coordinates, (lhs, rhs) -> {
            double lhsDistanceToPlayer = Vec3.m_82528_((Vec3i)lhs).m_82546_(player.m_20299_(1.0f)).m_82556_();
            double rhsDistanceToPlayer = Vec3.m_82528_((Vec3i)rhs).m_82546_(player.m_20299_(1.0f)).m_82556_();
            return (int)Math.signum(lhsDistanceToPlayer - rhsDistanceToPlayer);
        });
    }

    static {
        soundTime = 0;
    }

    static class PlacedData {
        float time;
        List<BlockPos> coordinates;
        List<BlockState> blockStates;
        List<ItemStack> itemStacks;
        BlockPos firstPos;
        BlockPos secondPos;
        boolean breaking;

        public PlacedData(float time, List<BlockPos> coordinates, List<BlockState> blockStates, List<ItemStack> itemStacks, BlockPos firstPos, BlockPos secondPos, boolean breaking) {
            this.time = time;
            this.coordinates = coordinates;
            this.blockStates = blockStates;
            this.itemStacks = itemStacks;
            this.firstPos = firstPos;
            this.secondPos = secondPos;
            this.breaking = breaking;
        }
    }
}

