/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;
import nl.requios.effortlessbuilding.render.BuildRenderTypes;
import nl.requios.effortlessbuilding.render.ModifierRenderer;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getPhase() != EventPriority.NORMAL || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack matrixStack = event.getPoseStack();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings((Player)player);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((Player)player);
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        ModifierRenderer.render(matrixStack, renderTypeBuffer, modifierSettings);
        BlockPreviewRenderer.render(matrixStack, renderTypeBuffer, (Player)player, modifierSettings, modeSettings);
        matrixStack.m_85849_();
    }

    protected static VertexConsumer beginLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.m_6299_(BuildRenderTypes.LINES);
    }

    protected static void endLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.m_109911_();
    }

    protected static VertexConsumer beginPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.m_6299_(BuildRenderTypes.PLANES);
    }

    protected static void endPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.m_109911_();
    }

    protected static void renderBlockPreview(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, BlockRenderDispatcher dispatcher, BlockPos blockPos, BlockState blockState, float dissolve, BlockPos firstPos, BlockPos secondPos, boolean red) {
        if (blockState == null) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
        matrixStack.m_252880_(-0.01f, -0.01f, -0.01f);
        matrixStack.m_85841_(1.02f, 1.02f, 1.02f);
        RenderType blockPreviewRenderType = BuildRenderTypes.getBlockPreviewRenderType(dissolve, blockPos, firstPos, secondPos, red);
        VertexConsumer buffer = renderTypeBuffer.m_6299_(blockPreviewRenderType);
        try {
            BakedModel model = dispatcher.m_110910_(blockState);
            dispatcher.m_110937_().renderModel(matrixStack.m_85850_(), buffer, blockState, model, 1.0f, 1.0f, 1.0f, 0, OverlayTexture.f_118083_, ModelData.EMPTY, blockPreviewRenderType);
        }
        catch (NullPointerException e) {
            EffortlessBuilding.logger.warn("RenderHandler::renderBlockPreview cannot render " + blockState.m_60734_().toString());
            matrixStack.m_85849_();
            renderTypeBuffer.m_109911_();
            VertexConsumer lineBuffer = RenderHandler.beginLines(renderTypeBuffer);
            RenderHandler.renderBlockOutline(matrixStack, lineBuffer, blockPos, new Vec3(1.0, 1.0, 1.0));
            RenderHandler.endLines(renderTypeBuffer);
            buffer = renderTypeBuffer.m_6299_(Sheets.m_110792_());
            matrixStack.m_85836_();
        }
        renderTypeBuffer.m_109911_();
        matrixStack.m_85849_();
    }

    protected static void renderBlockOutline(PoseStack matrixStack, VertexConsumer buffer, BlockPos pos, Vec3 color) {
        RenderHandler.renderBlockOutline(matrixStack, buffer, pos, pos, color);
    }

    protected static void renderBlockOutline(PoseStack matrixStack, VertexConsumer buffer, BlockPos pos1, BlockPos pos2, Vec3 color) {
        AABB aabb = new AABB(pos1, pos2.m_7918_(1, 1, 1)).m_82400_((double)0.002f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffer, (AABB)aabb, (float)((float)color.f_82479_), (float)((float)color.f_82480_), (float)((float)color.f_82481_), (float)0.4f);
    }

    protected static void renderBlockOutline(PoseStack matrixStack, VertexConsumer buffer, BlockPos pos, VoxelShape collisionShape, Vec3 color) {
        LevelRenderer.m_109654_((PoseStack)matrixStack, (VertexConsumer)buffer, (VoxelShape)collisionShape, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)((float)color.f_82479_), (float)((float)color.f_82480_), (float)((float)color.f_82481_), (float)0.4f);
    }
}

