/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmode;

import dev.huskcasaca.effortless.building.BuildAction;
import dev.huskcasaca.effortless.building.BuildActionHandler;
import dev.huskcasaca.effortless.buildmode.Buildable;
import dev.huskcasaca.effortless.buildmode.oneclick.Disable;
import dev.huskcasaca.effortless.buildmode.oneclick.Single;
import dev.huskcasaca.effortless.buildmode.threeclick.Cube;
import dev.huskcasaca.effortless.buildmode.threeclick.Cylinder;
import dev.huskcasaca.effortless.buildmode.threeclick.DiagonalLine;
import dev.huskcasaca.effortless.buildmode.threeclick.DiagonalWall;
import dev.huskcasaca.effortless.buildmode.threeclick.SlopeFloor;
import dev.huskcasaca.effortless.buildmode.threeclick.Sphere;
import dev.huskcasaca.effortless.buildmode.twoclick.Circle;
import dev.huskcasaca.effortless.buildmode.twoclick.Floor;
import dev.huskcasaca.effortless.buildmode.twoclick.Line;
import dev.huskcasaca.effortless.buildmode.twoclick.Wall;
import net.minecraft.class_1162;

public enum BuildMode {
    DISABLE("disable", new Disable(), Category.BASIC, new Option[0]),
    SINGLE("single", new Single(), Category.BASIC, new Option[0]),
    LINE("line", new Line(), Category.SQUARE, new Option[0]),
    WALL("wall", new Wall(), Category.SQUARE, Option.PLANE_FILLING),
    FLOOR("floor", new Floor(), Category.SQUARE, Option.PLANE_FILLING),
    CUBE("cube", new Cube(), Category.SQUARE, Option.CUBE_FILLING),
    DIAGONAL_LINE("diagonal_line", new DiagonalLine(), Category.DIAGONAL, new Option[0]),
    DIAGONAL_WALL("diagonal_wall", new DiagonalWall(), Category.DIAGONAL, new Option[0]),
    SLOPE_FLOOR("slope_floor", new SlopeFloor(), Category.DIAGONAL, Option.RAISED_EDGE),
    CIRCLE("circle", new Circle(), Category.CIRCULAR, Option.CIRCLE_START, Option.PLANE_FILLING, Option.ORIENTATION),
    CYLINDER("cylinder", new Cylinder(), Category.CIRCULAR, Option.CIRCLE_START, Option.PLANE_FILLING, Option.ORIENTATION),
    SPHERE("sphere", new Sphere(), Category.CIRCULAR, Option.CIRCLE_START, Option.PLANE_FILLING, Option.ORIENTATION);

    private final BuildableProvider provider;
    private final Category category;
    private final Option[] options;
    private final String name;

    private BuildMode(String name, Buildable instance, Category category, Option ... options) {
        this.name = name;
        this.provider = actions -> instance;
        this.category = category;
        this.options = options;
    }

    private BuildMode(String name, BuildableProvider provider, Category category, Option ... options) {
        this.name = name;
        this.provider = provider;
        this.category = category;
        this.options = options;
    }

    public String getNameKey() {
        return "effortless.mode." + this.getName();
    }

    public String getCommandName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case DISABLE -> "disabled";
            case SINGLE -> "single";
            case LINE -> "line";
            case WALL -> "wall";
            case FLOOR -> "floor";
            case CUBE -> "cube";
            case DIAGONAL_LINE -> "diagonalLine";
            case DIAGONAL_WALL -> "diagonalWall";
            case SLOPE_FLOOR -> "slopeFloor";
            case CIRCLE -> "circle";
            case CYLINDER -> "cylinder";
            case SPHERE -> "sphere";
        };
    }

    public String getDescriptionKey() {
        return "effortless.description." + this.getName();
    }

    public Buildable getInstance() {
        return this.provider.getBuildable(BuildActionHandler.getOptions());
    }

    public Category getCategory() {
        return this.category;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public String getName() {
        return this.name;
    }

    public static interface BuildableProvider {
        public Buildable getBuildable(BuildAction[] var1);
    }

    public static enum Category {
        BASIC(new class_1162(0.0f, 0.5f, 1.0f, 0.5f)),
        SQUARE(new class_1162(1.0f, 0.54f, 0.24f, 0.5f)),
        DIAGONAL(new class_1162(0.56f, 0.28f, 0.87f, 0.5f)),
        CIRCULAR(new class_1162(0.29f, 0.76f, 0.3f, 0.5f)),
        ROOF(new class_1162(0.83f, 0.87f, 0.23f, 0.5f));

        private final class_1162 color;

        private Category(class_1162 color) {
            this.color = color;
        }

        public class_1162 getColor() {
            return this.color;
        }
    }

    public static enum Option {
        BUILD_SPEED("build_speed", BuildAction.SPEED_NORMAL, BuildAction.SPEED_FAST),
        LINE_THICKNESS("line_thickness", BuildAction.THICKNESS_1, BuildAction.THICKNESS_3, BuildAction.THICKNESS_5),
        PLANE_FILLING("plane_filling", BuildAction.PLANE_FULL, BuildAction.PLANE_HOLLOW),
        CUBE_FILLING("cube_filling", BuildAction.CUBE_FULL, BuildAction.CUBE_HOLLOW, BuildAction.CUBE_SKELETON),
        RAISED_EDGE("raised_edge", BuildAction.RAISE_SHORT_EDGE, BuildAction.RAISE_LONG_EDGE),
        CIRCLE_START("circle_start", BuildAction.CIRCLE_START_CORNER, BuildAction.CIRCLE_START_CENTER),
        ORIENTATION("orientation", BuildAction.FACE_HORIZONTAL, BuildAction.FACE_VERTICAL);

        private final String name;
        private final BuildAction[] actions;

        private Option(String name, BuildAction ... actions) {
            this.name = name;
            this.actions = actions;
        }

        public String getNameKey() {
            return String.join((CharSequence)".", "effortless", "option", this.name);
        }

        public BuildAction[] getActions() {
            return this.actions;
        }
    }
}

