/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.huskcasaca.effortless.buildmode.BuildMode;
import dev.huskcasaca.effortless.buildmode.OneClickBuildable;
import dev.huskcasaca.effortless.buildmode.ThreeClickBuildable;
import dev.huskcasaca.effortless.buildmode.TwoClickBuildable;
import dev.huskcasaca.effortless.utils.SurvivalHelper;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class BuildCommand {
    private static final DynamicCommandExceptionType ERROR_NO_SUCH_BUILD_MODE = new DynamicCommandExceptionType(object -> new class_2588("commands.attribute.failed.build_mode", new Object[]{object}));

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        LiteralArgumentBuilder effortlessCommand = class_2170.method_9247((String)"effortless");
        LiteralArgumentBuilder placeCommand = class_2170.method_9247((String)"place");
        LiteralArgumentBuilder breakCommand = class_2170.method_9247((String)"break");
        for (BuildMode buildMode : BuildMode.values()) {
            if (buildMode == BuildMode.DISABLE) continue;
            if (buildMode.getInstance() instanceof OneClickBuildable) {
                BuildCommand.registerOneClickBuildModePlace(placeCommand, buildMode);
                BuildCommand.registerOneClickBuildModeBreak(breakCommand, buildMode);
                continue;
            }
            if (buildMode.getInstance() instanceof TwoClickBuildable) {
                BuildCommand.registerTwoClickBuildModePlace(placeCommand, buildMode);
                BuildCommand.registerTwoClickBuildModeBreak(breakCommand, buildMode);
                continue;
            }
            if (!(buildMode.getInstance() instanceof ThreeClickBuildable)) continue;
            BuildCommand.registerThreeClickBuildModePlace(placeCommand, buildMode);
            BuildCommand.registerThreeClickBuildModeBreak(breakCommand, buildMode);
        }
        effortlessCommand.then((ArgumentBuilder)placeCommand);
        effortlessCommand.then((ArgumentBuilder)breakCommand);
        commandDispatcher.register(effortlessCommand);
    }

    private static void registerOneClickBuildModePlace(ArgumentBuilder<class_2168, ?> builder, BuildMode buildMode) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)buildMode.getCommandName()).then(class_2170.method_9244((String)"firstPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player == null) {
                return 1;
            }
            class_2338 firstPos = class_2262.method_9696((CommandContext)context, (String)"firstPos");
            class_2680 blockState = class_2257.method_9655((CommandContext)context, (String)"block").method_9494();
            List<class_2338> coordinates = ((OneClickBuildable)buildMode.getInstance()).getFinalBlocks((class_1657)player, firstPos.method_10263(), firstPos.method_10264(), firstPos.method_10260());
            for (class_2338 blockPos : coordinates) {
                SurvivalHelper.useBlock((class_1937)player.method_14220(), (class_1657)player, blockPos, blockState);
            }
            return 1;
        })));
        builder.then((ArgumentBuilder)command);
    }

    private static void registerTwoClickBuildModePlace(ArgumentBuilder<class_2168, ?> builder, BuildMode buildMode) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)buildMode.getCommandName()).then(class_2170.method_9244((String)"firstPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"secondPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player == null) {
                return 1;
            }
            class_2338 firstPos = class_2262.method_9696((CommandContext)context, (String)"firstPos");
            class_2338 secondPos = class_2262.method_9696((CommandContext)context, (String)"secondPos");
            class_2680 blockState = class_2257.method_9655((CommandContext)context, (String)"block").method_9494();
            List<class_2338> coordinates = ((TwoClickBuildable)buildMode.getInstance()).getFinalBlocks((class_1657)player, firstPos.method_10263(), firstPos.method_10264(), firstPos.method_10260(), secondPos.method_10263(), secondPos.method_10264(), secondPos.method_10260());
            for (class_2338 blockPos : coordinates) {
                SurvivalHelper.useBlock((class_1937)player.method_14220(), (class_1657)player, blockPos, blockState);
            }
            return 1;
        }))));
        builder.then((ArgumentBuilder)command);
    }

    private static void registerThreeClickBuildModePlace(ArgumentBuilder<class_2168, ?> builder, BuildMode buildMode) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)buildMode.getCommandName()).then(class_2170.method_9244((String)"firstPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"secondPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"thirdPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player == null) {
                return 1;
            }
            class_2338 firstPos = class_2262.method_9696((CommandContext)context, (String)"firstPos");
            class_2338 secondPos = class_2262.method_9696((CommandContext)context, (String)"secondPos");
            class_2338 thirdPos = class_2262.method_9696((CommandContext)context, (String)"thirdPos");
            class_2680 blockState = class_2257.method_9655((CommandContext)context, (String)"block").method_9494();
            List<class_2338> coordinates = ((ThreeClickBuildable)buildMode.getInstance()).getFinalBlocks((class_1657)player, firstPos.method_10263(), firstPos.method_10264(), firstPos.method_10260(), secondPos.method_10263(), secondPos.method_10264(), secondPos.method_10260(), thirdPos.method_10263(), thirdPos.method_10264(), thirdPos.method_10260());
            for (class_2338 blockPos : coordinates) {
                SurvivalHelper.useBlock((class_1937)player.method_14220(), (class_1657)player, blockPos, blockState);
            }
            return 1;
        })))));
        builder.then((ArgumentBuilder)command);
    }

    private static void registerOneClickBuildModeBreak(ArgumentBuilder<class_2168, ?> builder, BuildMode buildMode) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)buildMode.getCommandName()).then(class_2170.method_9244((String)"firstPos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player == null) {
                return 1;
            }
            class_2338 firstPos = class_2262.method_9696((CommandContext)context, (String)"firstPos");
            List<class_2338> coordinates = ((OneClickBuildable)buildMode.getInstance()).getFinalBlocks((class_1657)player, firstPos.method_10263(), firstPos.method_10264(), firstPos.method_10260());
            for (class_2338 blockPos : coordinates) {
                SurvivalHelper.breakBlock((class_1937)player.method_14220(), (class_1657)player, blockPos, false);
            }
            return 1;
        }));
        builder.then((ArgumentBuilder)command);
    }

    private static void registerTwoClickBuildModeBreak(ArgumentBuilder<class_2168, ?> builder, BuildMode buildMode) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)buildMode.getCommandName()).then(class_2170.method_9244((String)"firstPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"secondPos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player == null) {
                return 1;
            }
            class_2338 firstPos = class_2262.method_9696((CommandContext)context, (String)"firstPos");
            class_2338 secondPos = class_2262.method_9696((CommandContext)context, (String)"secondPos");
            List<class_2338> coordinates = ((TwoClickBuildable)buildMode.getInstance()).getFinalBlocks((class_1657)player, firstPos.method_10263(), firstPos.method_10264(), firstPos.method_10260(), secondPos.method_10263(), secondPos.method_10264(), secondPos.method_10260());
            for (class_2338 blockPos : coordinates) {
                SurvivalHelper.breakBlock((class_1937)player.method_14220(), (class_1657)player, blockPos, false);
            }
            return 1;
        })));
        builder.then((ArgumentBuilder)command);
    }

    private static void registerThreeClickBuildModeBreak(ArgumentBuilder<class_2168, ?> builder, BuildMode buildMode) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)buildMode.getCommandName()).then(class_2170.method_9244((String)"firstPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"secondPos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"thirdPos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player == null) {
                return 1;
            }
            class_2338 firstPos = class_2262.method_9696((CommandContext)context, (String)"firstPos");
            class_2338 secondPos = class_2262.method_9696((CommandContext)context, (String)"secondPos");
            class_2338 thirdPos = class_2262.method_9696((CommandContext)context, (String)"thirdPos");
            List<class_2338> coordinates = ((ThreeClickBuildable)buildMode.getInstance()).getFinalBlocks((class_1657)player, firstPos.method_10263(), firstPos.method_10264(), firstPos.method_10260(), secondPos.method_10263(), secondPos.method_10264(), secondPos.method_10260(), thirdPos.method_10263(), thirdPos.method_10264(), thirdPos.method_10260());
            for (class_2338 blockPos : coordinates) {
                SurvivalHelper.breakBlock((class_1937)player.method_14220(), (class_1657)player, blockPos, false);
            }
            return 1;
        }))));
        builder.then((ArgumentBuilder)command);
    }
}

