/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.render;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.EffortlessClient;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmode.BuildMode;
import dev.huskcasaca.effortless.buildmode.BuildModeHandler;
import dev.huskcasaca.effortless.buildmode.BuildModeHelper;
import dev.huskcasaca.effortless.buildmode.Buildable;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHandler;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.config.ConfigManager;
import dev.huskcasaca.effortless.config.PreviewConfig;
import dev.huskcasaca.effortless.render.RenderUtils;
import dev.huskcasaca.effortless.utils.CompatHelper;
import dev.huskcasaca.effortless.utils.InventoryHelper;
import dev.huskcasaca.effortless.utils.SurvivalHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_776;

@Environment(value=EnvType.CLIENT)
public class BlockPreviewRenderer {
    private static final BlockPreviewRenderer INSTANCE = new BlockPreviewRenderer();
    private final class_310 minecraft;
    private final List<Preview> lastPlaced = new ArrayList<Preview>();
    private final List<Preview> currentPlacing = new ArrayList<Preview>();
    private List<class_2338> previousCoordinates;
    private List<class_2680> previousBlockStates;
    private List<class_1799> previousItemStacks;
    private class_2338 previousFirstPos;
    private class_2338 previousSecondPos;
    private int soundTime = 0;

    public BlockPreviewRenderer() {
        this.minecraft = class_310.method_1551();
    }

    public static BlockPreviewRenderer getInstance() {
        return INSTANCE;
    }

    public static boolean doRenderBlockPreviews(class_1657 player, class_2338 startPos) {
        return ConfigManager.getGlobalPreviewConfig().isAlwaysShowBlockPreview() || BuildModeHelper.getBuildMode(player) != BuildMode.DISABLE;
    }

    public static List<BlockPosState> getBlockPosStates(List<class_2338> coordinates, List<class_2680> blockStates) {
        if (coordinates.size() != blockStates.size()) {
            throw new IllegalArgumentException("Coordinates and blockstates must be the same size");
        }
        if (coordinates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BlockPosState> result = new ArrayList<BlockPosState>();
        for (int i = 0; i < coordinates.size(); ++i) {
            class_2338 coordinate = coordinates.get(i);
            class_2680 blockState = blockStates.get(i);
            if (coordinate == null || blockState == null) {
                throw new IllegalArgumentException("Coordinate or blockstate is null");
            }
            result.add(new BlockPosState(coordinate, blockState, null, null));
        }
        return result;
    }

    public static List<BlockPosState> getBlockPosStates(class_1657 player, List<class_2338> coordinates, List<class_2680> blockStates) {
        if (coordinates.size() != blockStates.size()) {
            throw new IllegalArgumentException("Coordinates and blockstates must be the same size");
        }
        if (coordinates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BlockPosState> result = new ArrayList<BlockPosState>();
        for (int i = 0; i < coordinates.size(); ++i) {
            class_2338 coordinate = coordinates.get(i);
            class_2680 blockState = blockStates.get(i);
            if (coordinate == null || blockState == null) {
                throw new IllegalArgumentException("Coordinate or blockstate is null");
            }
            result.add(new BlockPosState(coordinate, blockState, SurvivalHelper.canPlace(player.field_6002, player, coordinate, blockState), SurvivalHelper.canBreak(player.field_6002, player, coordinate)));
        }
        return result;
    }

    public static Map<class_2248, Integer> getPlayerBlockCount(class_1657 player, List<class_2680> blockStates) {
        HashMap<class_2248, Integer> result = new HashMap<class_2248, Integer>();
        blockStates.forEach(blockState -> result.putIfAbsent(blockState.method_26204(), InventoryHelper.findTotalBlocksInInventory(player, blockState.method_26204())));
        return result;
    }

    private static void renderBlockDissolveShader(class_4587 poseStack, class_4597.class_4598 multiBufferSource, List<BlockPosState> placeData, Map<class_2248, Integer> blocksLeft, class_2338 firstPos, class_2338 secondPos, float dissolve, boolean breaking) {
        class_746 player = class_310.method_1551().field_1724;
        class_776 dispatcher = class_310.method_1551().method_1541();
        if (placeData.isEmpty()) {
            return;
        }
        HashMap<class_2248, Integer> blockLeft = new HashMap<class_2248, Integer>(blocksLeft);
        for (BlockPosState blockPosState : placeData) {
            class_2338 blockPos = blockPosState.coordinate;
            class_2680 blockState = blockPosState.blockState;
            Boolean canBreak = blockPosState.canBreak;
            Boolean canPlace = blockPosState.canPlace;
            if (breaking) {
                if ((canBreak == null || !canBreak.booleanValue()) && !SurvivalHelper.canBreak(player.field_6002, (class_1657)player, blockPos)) continue;
                RenderUtils.renderBlockDissolveShader(poseStack, multiBufferSource, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, true);
                continue;
            }
            if ((canPlace == null || !canPlace.booleanValue()) && !SurvivalHelper.canPlace(player.field_6002, (class_1657)player, blockPosState.coordinate, blockState)) continue;
            if (player.method_7337()) {
                RenderUtils.renderBlockDissolveShader(poseStack, multiBufferSource, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, false);
                continue;
            }
            Integer count = blockLeft.getOrDefault(blockState.method_26204(), 0);
            if (count > 0) {
                RenderUtils.renderBlockDissolveShader(poseStack, multiBufferSource, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, false);
                blockLeft.put(blockState.method_26204(), count - 1);
                continue;
            }
            RenderUtils.renderBlockDissolveShader(poseStack, multiBufferSource, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, true);
        }
    }

    private static void renderBlockOutlines(class_4587 poseStack, class_4597.class_4598 multiBufferSource, List<BlockPosState> placeData, Map<class_2248, Integer> blocksLeft, class_2338 firstPos, class_2338 secondPos, float dissolve, boolean breaking) {
        class_746 player = class_310.method_1551().field_1724;
        class_776 dispatcher = class_310.method_1551().method_1541();
        if (placeData.isEmpty()) {
            return;
        }
        HashMap<class_2248, Integer> blockLeft = new HashMap<class_2248, Integer>(blocksLeft);
        for (BlockPosState blockPosState : placeData) {
            class_2338 blockPos = blockPosState.coordinate;
            class_2680 blockState = blockPosState.blockState;
            Boolean canBreak = blockPosState.canBreak;
            Boolean canPlace = blockPosState.canPlace;
            if (breaking) {
                if ((canBreak == null || !canBreak.booleanValue()) && !SurvivalHelper.canBreak(player.field_6002, (class_1657)player, blockPos)) continue;
                RenderUtils.renderBlockOutlines(poseStack, multiBufferSource, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, true);
                continue;
            }
            if ((canPlace == null || !canPlace.booleanValue()) && !SurvivalHelper.canPlace(player.field_6002, (class_1657)player, blockPosState.coordinate, blockState)) continue;
            if (player.method_7337()) {
                RenderUtils.renderBlockOutlines(poseStack, multiBufferSource, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, false);
                continue;
            }
            Integer count = blockLeft.getOrDefault(blockState.method_26204(), 0);
            if (count > 0) {
                RenderUtils.renderBlockOutlines(poseStack, multiBufferSource, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, false);
                blockLeft.put(blockState.method_26204(), count - 1);
                continue;
            }
            RenderUtils.renderBlockOutlines(poseStack, multiBufferSource, dispatcher, blockPos, blockState, dissolve, firstPos, secondPos, true);
        }
    }

    private static UseResult getBlockUseResult(List<BlockPosState> placeData, Map<class_2248, Integer> blocksLeft, boolean breaking) {
        if (placeData.isEmpty()) {
            return UseResult.EMPTY;
        }
        class_746 player = class_310.method_1551().field_1724;
        HashMap<class_2248, Integer> valid = new HashMap<class_2248, Integer>();
        HashMap<class_2248, Integer> total = new HashMap<class_2248, Integer>();
        HashMap<class_2248, Integer> left = new HashMap<class_2248, Integer>(blocksLeft);
        for (BlockPosState placeDatum : placeData) {
            class_2338 blockPos = placeDatum.coordinate;
            class_2680 blockState = placeDatum.blockState;
            if (breaking) {
                boolean canBreak = SurvivalHelper.canBreak(player.field_6002, (class_1657)player, blockPos);
                if (!canBreak) continue;
                valid.put(blockState.method_26204(), valid.getOrDefault(blockState.method_26204(), 0) + 1);
                total.put(blockState.method_26204(), total.getOrDefault(blockState.method_26204(), 0) + 1);
                continue;
            }
            boolean canPlace = SurvivalHelper.canPlace(player.field_6002, (class_1657)player, placeDatum.coordinate, blockState);
            if (!canPlace) continue;
            if (player.method_7337()) {
                valid.put(blockState.method_26204(), valid.getOrDefault(blockState.method_26204(), 0) + 1);
            } else {
                Integer count = left.getOrDefault(blockState.method_26204(), 0);
                if (count > 0) {
                    left.put(blockState.method_26204(), count - 1);
                    valid.put(blockState.method_26204(), valid.getOrDefault(blockState.method_26204(), 0) + 1);
                }
            }
            total.put(blockState.method_26204(), total.getOrDefault(blockState.method_26204(), 0) + 1);
        }
        return new UseResult(valid, total);
    }

    private static void sortOnDistanceToPlayer(List<class_2338> coordinates, class_1657 player) {
        coordinates.sort((lhs, rhs) -> {
            double lhsDistanceToPlayer = class_243.method_24954((class_2382)lhs).method_1020(player.method_5836(1.0f)).method_1027();
            double rhsDistanceToPlayer = class_243.method_24954((class_2382)rhs).method_1020(player.method_5836(1.0f)).method_1027();
            return (int)Math.signum(lhsDistanceToPlayer - rhsDistanceToPlayer);
        });
    }

    public void render(class_1657 player, class_4587 poseStack, class_4597.class_4598 multiBufferSource, class_4184 camera) {
        class_1799 mainhand;
        if (PreviewConfig.useShader()) {
            for (Preview placed2 : this.lastPlaced) {
                if (placed2.blockPosStates() == null || placed2.blockPosStates().isEmpty()) continue;
                double totalTime = class_3532.method_15390((double)30.0, (double)60.0, (double)(placed2.firstPos.method_10262((class_2382)placed2.secondPos) / 100.0)) * PreviewConfig.shaderDissolveTimeMultiplier();
                float dissolve = ((float)EffortlessClient.getTicksInGame() - placed2.time) / (float)totalTime;
                BlockPreviewRenderer.renderBlockDissolveShader(poseStack, multiBufferSource, placed2.blockPosStates(), placed2.useResult().valid(), placed2.firstPos, placed2.secondPos, dissolve, placed2.breaking);
            }
        }
        if (this.currentPlacing.isEmpty()) {
            Effortless.log(player, "", true);
        }
        this.currentPlacing.clear();
        this.lastPlaced.removeIf(placed -> {
            double totalTime = class_3532.method_15390((double)30.0, (double)60.0, (double)(placed.firstPos.method_10262((class_2382)placed.secondPos) / 100.0)) * PreviewConfig.shaderDissolveTimeMultiplier();
            return (double)placed.time + totalTime < (double)EffortlessClient.getTicksInGame();
        });
        class_239 lookingAt = EffortlessClient.getLookingAt(player);
        if (BuildModeHelper.getBuildMode(player) == BuildMode.DISABLE) {
            lookingAt = class_310.method_1551().field_1765;
        }
        boolean toolInHand = (mainhand = player.method_6047()).method_7960() || !CompatHelper.isItemBlockProxy(mainhand);
        class_2338 startPos = null;
        class_2350 hitSide = null;
        class_243 hitVec = null;
        if (lookingAt != null && lookingAt.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockLookingAt = (class_3965)lookingAt;
            startPos = blockLookingAt.method_17777();
            boolean replaceable = player.field_6002.method_8320(startPos).method_26207().method_15800();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos, blockLookingAt.method_17780());
            if (!(BuildModifierHelper.isQuickReplace(player) || toolInHand || replaceable || becomesDoubleSlab)) {
                startPos = startPos.method_10093(blockLookingAt.method_17780());
            }
            if (BuildModifierHelper.isQuickReplace(player) && !toolInHand && replaceable) {
                startPos = startPos.method_10074();
            }
            hitSide = blockLookingAt.method_17780();
            hitVec = blockLookingAt.method_17784();
        }
        if (!BlockPreviewRenderer.doRenderBlockPreviews(player, startPos)) {
            return;
        }
        if (BuildModeHandler.isActive(player)) {
            Buildable buildModeInstance = BuildModeHelper.getBuildMode(player).getInstance();
            if (buildModeInstance.getHitSide(player) != null) {
                hitSide = buildModeInstance.getHitSide(player);
            }
            if (buildModeInstance.getHitVec(player) != null) {
                hitVec = buildModeInstance.getHitVec(player);
            }
        }
        if (hitSide == null) {
            return;
        }
        boolean breaking = BuildModeHandler.isCurrentlyBreaking(player);
        boolean skipRaytrace = breaking || BuildModifierHelper.isQuickReplace(player);
        List<class_2338> startCoordinates = BuildModeHandler.findCoordinates(player, startPos, skipRaytrace);
        class_2338 firstPos = class_2338.field_10980;
        class_2338 secondPos = class_2338.field_10980;
        if (!startCoordinates.isEmpty()) {
            firstPos = startCoordinates.get(0);
            secondPos = startCoordinates.get(startCoordinates.size() - 1);
        }
        int limit = ReachHelper.getMaxBlockPlaceAtOnce(player);
        if (startCoordinates.size() > limit) {
            startCoordinates = startCoordinates.subList(0, limit);
        }
        List<class_2338> newCoordinates = BuildModifierHandler.findCoordinates(player, startCoordinates);
        hitVec = new class_243(Math.abs(hitVec.field_1352 - (double)((int)hitVec.field_1352)), Math.abs(hitVec.field_1351 - (double)((int)hitVec.field_1351)), Math.abs(hitVec.field_1350 - (double)((int)hitVec.field_1350)));
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        ArrayList<class_2680> blockStates = new ArrayList<class_2680>();
        if (breaking) {
            for (class_2338 coordinate : newCoordinates) {
                blockStates.add(player.field_6002.method_8320(coordinate));
            }
        } else {
            blockStates.addAll(BuildModifierHandler.findBlockStates(player, startCoordinates, hitVec, hitSide, itemStacks).values());
        }
        if (!BuildModifierHandler.compareCoordinates(this.previousCoordinates, newCoordinates)) {
            this.previousCoordinates = newCoordinates;
            this.previousBlockStates = blockStates;
            this.previousItemStacks = itemStacks;
            this.previousFirstPos = firstPos;
            this.previousSecondPos = secondPos;
            if (newCoordinates.size() > 1 && blockStates.size() > 1 && this.soundTime < EffortlessClient.getTicksInGame()) {
                this.soundTime = EffortlessClient.getTicksInGame();
                if (blockStates.get(0) != null) {
                    class_2498 soundType = blockStates.get(0).method_26204().method_9573(blockStates.get(0));
                    player.field_6002.method_8396(player, player.method_24515(), breaking ? soundType.method_10595() : soundType.method_10598(), class_3419.field_15245, 0.3f, 0.8f);
                }
            }
        }
        if (blockStates.isEmpty() || newCoordinates.size() != blockStates.size()) {
            return;
        }
        switch (ConfigManager.getGlobalPreviewConfig().getBlockPreviewMode()) {
            case OUTLINES: {
                BlockPreviewRenderer.renderBlockOutlines(poseStack, multiBufferSource, BlockPreviewRenderer.getBlockPosStates(newCoordinates, blockStates), BlockPreviewRenderer.getPlayerBlockCount(player, blockStates), firstPos, secondPos, 0.0f, breaking);
                break;
            }
            case DISSOLVE_SHADER: {
                BlockPreviewRenderer.renderBlockDissolveShader(poseStack, multiBufferSource, BlockPreviewRenderer.getBlockPosStates(newCoordinates, blockStates), BlockPreviewRenderer.getPlayerBlockCount(player, blockStates), firstPos, secondPos, 0.0f, breaking);
            }
        }
        UseResult placeResult = BlockPreviewRenderer.getBlockUseResult(BlockPreviewRenderer.getBlockPosStates(newCoordinates, blockStates), BlockPreviewRenderer.getPlayerBlockCount(player, blockStates), breaking);
        this.currentPlacing.add(new Preview(BlockPreviewRenderer.getBlockPosStates(player, newCoordinates, blockStates), placeResult, firstPos, secondPos, EffortlessClient.getTicksInGame(), false));
        if (BuildModeHandler.isActive(player)) {
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (class_2338 pos : startCoordinates) {
                if (pos.method_10263() < minX) {
                    minX = pos.method_10263();
                }
                if (pos.method_10263() > maxX) {
                    maxX = pos.method_10263();
                }
                if (pos.method_10264() < minY) {
                    minY = pos.method_10264();
                }
                if (pos.method_10264() > maxY) {
                    maxY = pos.method_10264();
                }
                if (pos.method_10260() < minZ) {
                    minZ = pos.method_10260();
                }
                if (pos.method_10260() <= maxZ) continue;
                maxZ = pos.method_10260();
            }
            class_2338 dim = new class_2338(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            Object dimensions = "(";
            if (dim.method_10263() > 1) {
                dimensions = (String)dimensions + dim.method_10263() + "x";
            }
            if (dim.method_10260() > 1) {
                dimensions = (String)dimensions + dim.method_10260() + "x";
            }
            if (dim.method_10264() > 1) {
                dimensions = (String)dimensions + dim.method_10264() + "x";
            }
            if (((String)(dimensions = ((String)dimensions).substring(0, ((String)dimensions).length() - 1))).length() > 1) {
                dimensions = (String)dimensions + ")";
            }
            String blockCounter = class_124.field_1068 + placeResult.validBlocks() + class_124.field_1070 + (String)(placeResult.isFilled() ? " " : " + " + class_124.field_1061 + placeResult.wantedBlocks() + class_124.field_1070 + " ") + (placeResult.totalBlocks() == 1 ? "block" : "blocks");
            Effortless.log(player, "%s%s%s of %s %s".formatted(class_124.field_1065, BuildModeHelper.getTranslatedModeOptionName(player), class_124.field_1070, blockCounter, dimensions), true);
        } else {
            Effortless.log(player, "", true);
        }
    }

    public void onBlocksPlaced() {
        this.onBlocksPlaced(this.previousCoordinates, this.previousItemStacks, this.previousBlockStates, this.previousFirstPos, this.previousSecondPos);
    }

    public void onBlocksPlaced(List<class_2338> coordinates, List<class_1799> itemStacks, List<class_2680> blockStates, class_2338 firstPos, class_2338 secondPos) {
        class_746 player = class_310.method_1551().field_1724;
        if (!BlockPreviewRenderer.doRenderBlockPreviews((class_1657)player, firstPos)) {
            return;
        }
        if (coordinates != null && blockStates != null && !coordinates.isEmpty() && blockStates.size() == coordinates.size() && coordinates.size() > 1) {
            this.lastPlaced.add(new Preview(BlockPreviewRenderer.getBlockPosStates((class_1657)player, coordinates, blockStates), BlockPreviewRenderer.getBlockUseResult(BlockPreviewRenderer.getBlockPosStates(coordinates, blockStates), BlockPreviewRenderer.getPlayerBlockCount((class_1657)player, blockStates), false), firstPos, secondPos, EffortlessClient.getTicksInGame(), false));
        }
    }

    public void onBlocksBroken() {
        this.onBlocksBroken(this.previousCoordinates, this.previousItemStacks, this.previousBlockStates, this.previousFirstPos, this.previousSecondPos);
    }

    public void onBlocksBroken(List<class_2338> coordinates, List<class_1799> itemStacks, List<class_2680> blockStates, class_2338 firstPos, class_2338 secondPos) {
        class_746 player = class_310.method_1551().field_1724;
        if (BlockPreviewRenderer.doRenderBlockPreviews((class_1657)player, firstPos)) {
            return;
        }
        if (coordinates != null && blockStates != null && !coordinates.isEmpty() && blockStates.size() == coordinates.size() && coordinates.size() > 1) {
            this.lastPlaced.add(new Preview(BlockPreviewRenderer.getBlockPosStates(coordinates, blockStates), BlockPreviewRenderer.getBlockUseResult(BlockPreviewRenderer.getBlockPosStates(coordinates, blockStates), BlockPreviewRenderer.getPlayerBlockCount((class_1657)player, blockStates), true), firstPos, secondPos, EffortlessClient.getTicksInGame(), true));
        }
    }

    public List<Preview> getLastPlaced() {
        return this.lastPlaced;
    }

    public List<Preview> getCurrentPlacing() {
        return this.currentPlacing;
    }

    record BlockPosState(class_2338 coordinate, class_2680 blockState, Boolean canPlace, Boolean canBreak) {
    }

    record UseResult(Map<class_2248, Integer> valid, Map<class_2248, Integer> total) {
        public static UseResult EMPTY = new UseResult(Collections.emptyMap(), Collections.emptyMap());

        public int validBlocks() {
            return this.valid.values().stream().mapToInt(Integer::intValue).sum();
        }

        public int totalBlocks() {
            return this.total.values().stream().mapToInt(Integer::intValue).sum();
        }

        public boolean isFilled() {
            return this.validBlocks() == this.totalBlocks();
        }

        public int wantedBlocks() {
            return this.totalBlocks() - this.validBlocks();
        }
    }

    public record Preview(List<BlockPosState> blockPosStates, UseResult useResult, class_2338 firstPos, class_2338 secondPos, float time, boolean breaking) {
        public List<class_1799> getValidItemStacks() {
            ArrayList<class_1799> result = new ArrayList<class_1799>();
            this.useResult.valid.forEach((block, count) -> {
                if (block.equals(class_2246.field_10124)) {
                    return;
                }
                while (count > 0) {
                    class_1799 itemStack = new class_1799((class_1935)block.method_8389());
                    if (itemStack.method_7914() <= 0) continue;
                    int used = count > itemStack.method_7914() ? itemStack.method_7914() : count.intValue();
                    itemStack.method_7939(used);
                    count = count - used;
                    result.add(itemStack);
                }
            });
            return result;
        }

        public List<class_1799> getInvalidItemStacks() {
            ArrayList<class_1799> result = new ArrayList<class_1799>();
            this.useResult.total.forEach((block, count) -> {
                if (block.equals(class_2246.field_10124)) {
                    return;
                }
                count = count - this.useResult.valid.getOrDefault(block, 0);
                while (count > 0) {
                    class_1799 itemStack = new class_1799((class_1935)block.method_8389());
                    if (itemStack.method_7914() <= 0) continue;
                    int used = count > itemStack.method_7914() ? itemStack.method_7914() : count.intValue();
                    itemStack.method_7939(used);
                    count = count - used;
                    result.add(itemStack);
                }
            });
            return result;
        }
    }
}

