/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.render;

import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.buildmodifier.mirror.Mirror;
import dev.huskcasaca.effortless.buildmodifier.mirror.RadialMirror;
import dev.huskcasaca.effortless.render.RenderUtils;
import java.awt.Color;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
public class ModifierRenderer {
    private static final Color COLOR_PLANE = new Color(0, 0, 0, 72);
    private static final Color COLOR_LINE = new Color(0, 0, 0, 200);
    private static final class_243 EPSILON = new class_243(0.001, 0.001, 0.001);
    private static final ModifierRenderer INSTANCE = new ModifierRenderer();
    private final class_310 minecraft = class_310.method_1551();

    private ModifierRenderer() {
    }

    public static ModifierRenderer getInstance() {
        return INSTANCE;
    }

    public void render(class_1657 player, class_4587 poseStack, class_4597.class_4598 multiBufferSource, class_4184 camera) {
        RadialMirror.RadialMirrorSettings radialMirrorSettings;
        Mirror.MirrorSettings mirrorSettings = BuildModifierHelper.getModifierSettings(player).mirrorSettings();
        if (mirrorSettings != null && mirrorSettings.enabled() && (mirrorSettings.mirrorX() || mirrorSettings.mirrorY() || mirrorSettings.mirrorZ())) {
            class_243 pos = mirrorSettings.position().method_1020(camera.method_19326());
            this.renderMirror(multiBufferSource, pos, mirrorSettings.radius(), mirrorSettings.getMirrorAxis(), mirrorSettings.drawPlanes(), mirrorSettings.drawLines());
        }
        if ((radialMirrorSettings = BuildModifierHelper.getModifierSettings(player).radialMirrorSettings()) != null && radialMirrorSettings.enabled()) {
            class_243 pos = radialMirrorSettings.position().method_1020(camera.method_19326());
            this.renderRadial(multiBufferSource, pos.method_1019(EPSILON), radialMirrorSettings.radius(), radialMirrorSettings.slices(), radialMirrorSettings.drawPlanes(), radialMirrorSettings.drawLines());
        }
    }

    private void drawAxisPlane(class_4588 buffer, class_243 pos, Integer range, class_2350.class_2351 axis, Color color) {
        class_243 min = pos.method_1023((double)range.intValue(), (double)range.intValue(), (double)range.intValue());
        class_243 max = pos.method_1031((double)range.intValue(), (double)range.intValue(), (double)range.intValue());
        switch (axis) {
            case field_11052: {
                buffer.method_22912((double)((float)max.method_10216()), (double)((float)pos.method_10214()), (double)((float)max.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)min.method_10216()), (double)((float)pos.method_10214()), (double)((float)max.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)min.method_10216()), (double)((float)pos.method_10214()), (double)((float)min.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)max.method_10216()), (double)((float)pos.method_10214()), (double)((float)min.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                break;
            }
            case field_11051: {
                buffer.method_22912((double)((float)max.method_10216()), (double)((float)min.method_10214()), (double)((float)pos.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)min.method_10216()), (double)((float)min.method_10214()), (double)((float)pos.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)min.method_10216()), (double)((float)max.method_10214()), (double)((float)pos.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)max.method_10216()), (double)((float)max.method_10214()), (double)((float)pos.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                break;
            }
            case field_11048: {
                buffer.method_22912((double)((float)pos.method_10216()), (double)((float)min.method_10214()), (double)((float)min.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)pos.method_10216()), (double)((float)min.method_10214()), (double)((float)max.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)pos.method_10216()), (double)((float)max.method_10214()), (double)((float)max.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
                buffer.method_22912((double)((float)pos.method_10216()), (double)((float)max.method_10214()), (double)((float)min.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
            }
        }
    }

    private void drawAxisLine(class_4588 buffer, class_243 pos, Integer range, class_2350.class_2351 axis, Color color) {
        class_243 min = pos.method_1023((double)range.intValue(), (double)range.intValue(), (double)range.intValue());
        class_243 max = pos.method_1031((double)range.intValue(), (double)range.intValue(), (double)range.intValue());
        switch (axis) {
            case field_11052: {
                buffer.method_22912((double)((float)pos.field_1352), (double)((float)min.field_1351), (double)((float)pos.field_1350)).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_22914(1.0f, 1.0f, 1.0f).method_1344();
                buffer.method_22912((double)((float)pos.field_1352), (double)((float)max.field_1351), (double)((float)pos.field_1350)).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_22914(1.0f, 1.0f, 1.0f).method_1344();
                break;
            }
            case field_11051: {
                buffer.method_22912((double)((float)pos.field_1352), (double)((float)pos.field_1351), (double)((float)min.field_1350)).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_22914(1.0f, 1.0f, 1.0f).method_1344();
                buffer.method_22912((double)((float)pos.field_1352), (double)((float)pos.field_1351), (double)((float)max.field_1350)).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_22914(1.0f, 1.0f, 1.0f).method_1344();
                break;
            }
            case field_11048: {
                buffer.method_22912((double)((float)min.field_1352), (double)((float)pos.field_1351), (double)((float)pos.field_1350)).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_22914(1.0f, 1.0f, 1.0f).method_1344();
                buffer.method_22912((double)((float)max.field_1352), (double)((float)pos.field_1351), (double)((float)pos.field_1350)).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_22914(1.0f, 1.0f, 1.0f).method_1344();
            }
        }
    }

    private void drawVerticalPlane(class_4588 buffer, class_243 posA, class_243 posB, Color color) {
        class_243 min = posA;
        class_243 max = posB;
        buffer.method_22912((double)((float)min.method_10216()), (double)((float)min.method_10214()), (double)((float)min.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        buffer.method_22912((double)((float)max.method_10216()), (double)((float)min.method_10214()), (double)((float)max.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        buffer.method_22912((double)((float)max.method_10216()), (double)((float)max.method_10214()), (double)((float)max.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        buffer.method_22912((double)((float)min.method_10216()), (double)((float)max.method_10214()), (double)((float)min.method_10215())).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
    }

    private void drawLine(class_4588 buffer, class_243 posA, class_243 posB, Color color) {
        buffer.method_22912((double)((float)posA.field_1352), (double)((float)posA.field_1351), (double)((float)posA.field_1350)).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_22914(1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22912((double)((float)posB.field_1352), (double)((float)posB.field_1351), (double)((float)posB.field_1350)).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_22914(1.0f, 1.0f, 1.0f).method_1344();
    }

    private void renderMirror(class_4597.class_4598 multiBufferSource, class_243 pos, Integer radius, List<class_2350.class_2351> axis, boolean drawPlanes, boolean drawLines) {
        class_4588 buffer;
        if (drawPlanes) {
            for (class_2350.class_2351 a : axis) {
                buffer = RenderUtils.beginPlanes((class_4597)multiBufferSource);
                this.drawAxisPlane(buffer, pos, radius, a, COLOR_PLANE);
                multiBufferSource.method_22993();
            }
        }
        if (drawLines) {
            for (class_2350.class_2351 a : axis) {
                buffer = RenderUtils.beginLines(multiBufferSource);
                for (class_2350.class_2351 a1 : class_2350.class_2351.values()) {
                    if (a1 == a) continue;
                    this.drawAxisLine(buffer, pos, radius, a1, COLOR_LINE);
                }
                multiBufferSource.method_22993();
            }
        }
    }

    private void renderRadial(class_4597.class_4598 multiBufferSource, class_243 pos, Integer radius, Integer slices, boolean drawPlanes, boolean drawLines) {
        class_4588 buffer;
        class_243 posB;
        class_243 posA;
        class_243 newVec;
        class_243 relNewVec;
        int i;
        float angle = (float)Math.PI * 2 / (float)slices.intValue();
        class_243 relStartVec = new class_243((double)radius.intValue(), 0.0, 0.0);
        if (slices % 4 == 2) {
            relStartVec = relStartVec.method_1024(angle / 2.0f);
        }
        if (drawPlanes) {
            for (i = 0; i < slices; ++i) {
                relNewVec = relStartVec.method_1024(angle * (float)i);
                newVec = pos.method_1019(relNewVec);
                posA = new class_243(pos.field_1352, pos.field_1351 - (double)radius.intValue(), pos.field_1350);
                posB = new class_243(newVec.field_1352, pos.field_1351 + (double)radius.intValue(), newVec.field_1350);
                buffer = RenderUtils.beginPlanes((class_4597)multiBufferSource);
                this.drawVerticalPlane(buffer, posA, posB, COLOR_PLANE);
                multiBufferSource.method_22993();
            }
        }
        if (drawLines) {
            for (i = 0; i < slices; ++i) {
                relNewVec = relStartVec.method_1024(angle * (float)i);
                newVec = pos.method_1019(relNewVec);
                posA = new class_243(pos.field_1352, pos.field_1351 - (double)radius.intValue(), pos.field_1350);
                posB = new class_243(newVec.field_1352, pos.field_1351 + (double)radius.intValue(), newVec.field_1350);
                buffer = RenderUtils.beginLines(multiBufferSource);
                this.drawLine(buffer, new class_243(posA.method_10216(), pos.method_10214(), posA.method_10215()), new class_243(posB.method_10216(), pos.method_10214(), posB.method_10215()), COLOR_LINE);
                multiBufferSource.method_22993();
            }
            class_4588 buffer2 = RenderUtils.beginLines(multiBufferSource);
            this.drawLine(buffer2, new class_243(pos.method_10216(), pos.method_10214() - (double)radius.intValue(), pos.method_10215()), new class_243(pos.method_10216(), pos.method_10214() + (double)radius.intValue(), pos.method_10215()), COLOR_LINE);
            multiBufferSource.method_22993();
        }
    }
}

