/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.screen.buildmode;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.BuildAction;
import dev.huskcasaca.effortless.building.BuildActionHandler;
import dev.huskcasaca.effortless.buildmode.BuildMode;
import dev.huskcasaca.effortless.buildmode.BuildModeHandler;
import dev.huskcasaca.effortless.buildmode.BuildModeHelper;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.control.Keys;
import dev.huskcasaca.effortless.entity.player.ModeSettings;
import dev.huskcasaca.effortless.entity.player.ModifierSettings;
import dev.huskcasaca.effortless.network.Packets;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerBuildActionPacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerSetBuildModePacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1162;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6328;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.apache.commons.lang3.text.WordUtils;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class RadialMenuScreen
extends class_437 {
    private static final RadialMenuScreen INSTANCE = new RadialMenuScreen();
    private static final class_1162 RADIAL_BUTTON_COLOR = new class_1162(0.0f, 0.0f, 0.0f, 0.5f);
    private static final class_1162 SIDE_BUTTON_COLOR = new class_1162(0.5f, 0.5f, 0.5f, 0.5f);
    private static final class_1162 HIGHLIGHT_COLOR = new class_1162(0.6f, 0.8f, 1.0f, 0.6f);
    private static final class_1162 SELECTED_COLOR = new class_1162(0.0f, 0.5f, 1.0f, 0.5f);
    private static final class_1162 HIGHLIGHT_SELECTED_COLOR = new class_1162(0.2f, 0.7f, 1.0f, 0.7f);
    private static final int WHITE_TEXT_COLOR = -1;
    private static final int WATERMARK_TEXT_COLOR = -2004318072;
    private static final int DESCRIPTION_TEXT_COLOR = -578254712;
    private static final int OPTION_TEXT_COLOR = -286331137;
    private static final double RING_INNER_EDGE = 38.0;
    private static final double RING_OUTER_EDGE = 80.0;
    private static final double CATEGORY_LINE_OUTER_EDGE = 42.0;
    private static final double TEXT_DISTANCE = 90.0;
    private static final double BUTTON_DISTANCE = 120.0;
    private static final float FADE_SPEED = 0.5f;
    private static final int DESCRIPTION_HEIGHT = 100;
    public static final int MODE_OPTION_ROW_HEIGHT = 39;
    public BuildMode switchTo = null;
    public BuildAction doAction = null;
    public boolean performedActionUsingMouse;
    private float visibility;
    private BuildAction lastAction = null;

    public RadialMenuScreen() {
        super((class_2561)new class_2588(String.join((CharSequence)".", "effortless", "screen", "radial_menu")));
    }

    public static RadialMenuScreen getInstance() {
        return INSTANCE;
    }

    public static void playRadialMenuSound() {
        class_1144 soundManager = class_310.method_1551().method_1483();
        soundManager.method_38566();
        soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }

    public boolean isVisible() {
        return class_310.method_1551().field_1755 instanceof RadialMenuScreen;
    }

    protected void method_25426() {
        super.method_25426();
        this.performedActionUsingMouse = false;
        this.visibility = 0.0f;
    }

    public void method_25393() {
        super.method_25393();
        if (!Keys.SHOW_RADIAL_MENU.isKeyDown()) {
            this.method_25419();
        }
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.visibility += 0.5f * partialTicks;
        if (this.visibility > 1.0f) {
            this.visibility = 1.0f;
        }
        if (this.field_22787.field_1687 != null) {
            this.method_25296(poseStack, 0, 0, this.field_22789, this.field_22790, (int)(this.visibility * 192.0f) << 24 | 0x101010, (int)(this.visibility * 208.0f) << 24 | 0x101010);
        } else {
            this.method_25434(0);
        }
        BuildMode currentBuildMode = BuildModeHelper.getModeSettings((class_1657)this.field_22787.field_1724).buildMode();
        poseStack.method_22903();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        double middleX = (double)this.field_22789 / 2.0;
        double middleY = (double)this.field_22790 / 2.0;
        int mouseXX = (int)(this.field_22787.field_1729.method_1603() * (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480());
        int mouseYY = (int)(this.field_22787.field_1729.method_1604() * (double)this.field_22787.method_22683().method_4502() / (double)this.field_22787.method_22683().method_4507());
        double mouseXCenter = (double)mouseXX - middleX;
        double mouseYCenter = (double)mouseYY - middleY;
        double mouseRadians = Math.atan2(mouseYCenter, mouseXCenter);
        double quarterCircle = 1.5707963267948966;
        if (mouseRadians < -1.5707963267948966) {
            mouseRadians += Math.PI * 2;
        }
        ArrayList<ModeRegion> modes = new ArrayList<ModeRegion>();
        ArrayList<MenuButton> buttons = new ArrayList<MenuButton>();
        for (BuildMode mode : BuildMode.values()) {
            modes.add(new ModeRegion(mode));
        }
        int baseY = -13;
        int buttonOffset = 26;
        buttons.add(new MenuButton(BuildAction.UNDO, -120.0 - (double)buttonOffset, baseY + 0, class_2350.field_11039));
        buttons.add(new MenuButton(BuildAction.REDO, -120.0, baseY + 0, class_2350.field_11034));
        buttons.add(new MenuButton(BuildAction.MODIFIER, -120.0 - (double)buttonOffset, baseY + buttonOffset, class_2350.field_11039));
        buttons.add(new MenuButton(BuildAction.REPLACE, -120.0, baseY + buttonOffset, class_2350.field_11034));
        BuildMode.Option[] options = currentBuildMode.getOptions();
        BuildMode.Option[] optionsTexting = (BuildMode.Option[])options.clone();
        ArrayList<MenuButton> optionButtons = new ArrayList<MenuButton>();
        for (int row = 0; row < options.length; ++row) {
            ArrayList<MenuButton> buttonsInRow = new ArrayList<MenuButton>();
            for (int col = 0; col < options[row].getActions().length; ++col) {
                BuildAction action = options[row].getActions()[col];
                MenuButton button = new MenuButton(action, 120.0 + (double)(col * buttonOffset), (float)options.length / -2.0f * 39.0f + 26.0f + (float)(row * 39), class_2350.field_11033);
                buttons.add(button);
                optionButtons.add(button);
                buttonsInRow.add(button);
            }
            if (!this.isButtonHighlighted(buttonsInRow, mouseXCenter, mouseYCenter) || row + 1 >= options.length) continue;
            optionsTexting[row + 1] = null;
        }
        this.switchTo = null;
        this.doAction = null;
        this.drawRadialButtonBackgrounds(currentBuildMode, buffer, middleX, middleY, mouseXCenter, mouseYCenter, mouseRadians, 38.0, 80.0, 1.5707963267948966, modes);
        this.drawSideButtonBackgrounds(buffer, middleX, middleY, mouseXCenter, mouseYCenter, buttons);
        tesselator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        this.drawIcons(poseStack, tesselator, buffer, middleX, middleY, 38.0, 80.0, modes, buttons);
        this.drawTexts(poseStack, currentBuildMode, middleX, middleY, 90.0, 120.0, modes, buttons, optionsTexting);
        poseStack.method_22909();
    }

    private boolean isButtonHighlighted(MenuButton btn, double mouseXCenter, double mouseYCenter) {
        return btn.x1 <= mouseXCenter && btn.x2 >= mouseXCenter && btn.y1 <= mouseYCenter && btn.y2 >= mouseYCenter;
    }

    private boolean isButtonHighlighted(ArrayList<MenuButton> btns, double mouseXCenter, double mouseYCenter) {
        for (MenuButton btn : btns) {
            if (!this.isButtonHighlighted(btn, mouseXCenter, mouseYCenter)) continue;
            return true;
        }
        return false;
    }

    private boolean isMouseInButtonGroup(ArrayList<MenuButton> btns, double mouseXCenter, double mouseYCenter) {
        if (btns.isEmpty()) {
            return false;
        }
        return btns.stream().map(btn -> btn.x1).min(Double::compare).get() <= mouseXCenter && btns.stream().map(btn -> btn.x2).max(Double::compare).get() >= mouseXCenter && btns.stream().map(btn -> btn.y1).min(Double::compare).get() <= mouseYCenter && btns.stream().map(btn -> btn.y2).max(Double::compare).get() >= mouseYCenter;
    }

    private void drawRadialButtonBackgrounds(BuildMode currentBuildMode, class_287 buffer, double middleX, double middleY, double mouseXCenter, double mouseYCenter, double mouseRadians, double ringInnerEdge, double ringOuterEdge, double quarterCircle, ArrayList<ModeRegion> modes) {
        if (modes.isEmpty()) {
            return;
        }
        int totalModes = Math.max(3, modes.size());
        double fragment = 0.015707963267948967;
        double fragment2 = 0.007853981633974483;
        double radiansPerObject = Math.PI * 2 / (double)totalModes;
        for (int i = 0; i < modes.size(); ++i) {
            ModeRegion modeRegion = modes.get(i);
            double beginRadians = ((double)i - 0.5) * radiansPerObject - quarterCircle;
            double endRadians = ((double)i + 0.5) * radiansPerObject - quarterCircle;
            modeRegion.x1 = Math.cos(beginRadians);
            modeRegion.x2 = Math.cos(endRadians);
            modeRegion.y1 = Math.sin(beginRadians);
            modeRegion.y2 = Math.sin(endRadians);
            double x1m1 = Math.cos(beginRadians + 0.015707963267948967) * ringInnerEdge;
            double x2m1 = Math.cos(endRadians - 0.015707963267948967) * ringInnerEdge;
            double y1m1 = Math.sin(beginRadians + 0.015707963267948967) * ringInnerEdge;
            double y2m1 = Math.sin(endRadians - 0.015707963267948967) * ringInnerEdge;
            double x1m2 = Math.cos(beginRadians + 0.007853981633974483) * ringOuterEdge;
            double x2m2 = Math.cos(endRadians - 0.007853981633974483) * ringOuterEdge;
            double y1m2 = Math.sin(beginRadians + 0.007853981633974483) * ringOuterEdge;
            double y2m2 = Math.sin(endRadians - 0.007853981633974483) * ringOuterEdge;
            boolean isSelected = currentBuildMode.ordinal() == i;
            boolean isMouseInQuad = this.inTriangle(x1m1, y1m1, x2m2, y2m2, x2m1, y2m1, mouseXCenter, mouseYCenter) || this.inTriangle(x1m1, y1m1, x1m2, y1m2, x2m2, y2m2, mouseXCenter, mouseYCenter);
            boolean isHighlighted = (beginRadians <= mouseRadians && mouseRadians <= endRadians || beginRadians <= mouseRadians - Math.PI * 2 && mouseRadians - Math.PI * 2 <= endRadians) && isMouseInQuad;
            class_1162 color = RADIAL_BUTTON_COLOR;
            if (isSelected) {
                color = SELECTED_COLOR;
            }
            if (isHighlighted) {
                color = HIGHLIGHT_COLOR;
            }
            if (isSelected && isHighlighted) {
                color = HIGHLIGHT_SELECTED_COLOR;
            }
            if (isHighlighted) {
                modeRegion.highlighted = true;
                this.switchTo = modeRegion.mode;
            }
            buffer.method_22912(middleX + x1m1, middleY + y1m1, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + x2m1, middleY + y2m1, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + x2m2, middleY + y2m2, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + x1m2, middleY + y1m2, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            color = modeRegion.mode.getCategory().getColor();
            double x1m3 = Math.cos(beginRadians + 0.015707963267948967) * 42.0;
            double x2m3 = Math.cos(endRadians - 0.015707963267948967) * 42.0;
            double y1m3 = Math.sin(beginRadians + 0.015707963267948967) * 42.0;
            double y2m3 = Math.sin(endRadians - 0.015707963267948967) * 42.0;
            buffer.method_22912(middleX + x1m1, middleY + y1m1, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + x2m1, middleY + y2m1, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + x2m3, middleY + y2m3, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + x1m3, middleY + y1m3, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
        }
    }

    private void drawSideButtonBackgrounds(class_287 buffer, double middleX, double middleY, double mouseXCenter, double mouseYCenter, ArrayList<MenuButton> buttons) {
        for (MenuButton btn : buttons) {
            boolean isSelected = Arrays.stream(BuildActionHandler.getOptions()).toList().contains((Object)btn.action);
            boolean isHighlighted = btn.x1 <= mouseXCenter && btn.x2 >= mouseXCenter && btn.y1 <= mouseYCenter && btn.y2 >= mouseYCenter;
            class_1162 color = SIDE_BUTTON_COLOR;
            if (isSelected) {
                color = SELECTED_COLOR;
            }
            if (isHighlighted) {
                color = HIGHLIGHT_COLOR;
            }
            if (isSelected && isHighlighted) {
                color = HIGHLIGHT_SELECTED_COLOR;
            }
            if (isHighlighted) {
                btn.highlighted = true;
                this.doAction = btn.action;
            }
            buffer.method_22912(middleX + btn.x1, middleY + btn.y1, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + btn.x1, middleY + btn.y2, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + btn.x2, middleY + btn.y2, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
            buffer.method_22912(middleX + btn.x2, middleY + btn.y1, (double)this.method_25305()).method_22915(color.method_4953(), color.method_4956(), color.method_4957(), color.method_23853()).method_1344();
        }
    }

    private void drawIcons(class_4587 poseStack, class_289 tesselator, class_287 buffer, double middleX, double middleY, double ringInnerEdge, double ringOuterEdge, ArrayList<ModeRegion> modes, ArrayList<MenuButton> buttons) {
        double y;
        double x;
        poseStack.method_22903();
        RenderSystem.enableTexture();
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ModeRegion modeRegion : modes) {
            x = (modeRegion.x1 + modeRegion.x2) * 0.5 * (ringOuterEdge * 0.55 + 0.45 * ringInnerEdge);
            y = (modeRegion.y1 + modeRegion.y2) * 0.5 * (ringOuterEdge * 0.55 + 0.45 * ringInnerEdge);
            RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("effortless", "textures/mode/" + modeRegion.mode.name().toLowerCase() + ".png"));
            RadialMenuScreen.method_25293((class_4587)poseStack, (int)((int)(middleX + x - 8.0)), (int)((int)(middleY + y - 8.0)), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        }
        for (MenuButton button : buttons) {
            x = (button.x1 + button.x2) / 2.0 + 0.01;
            y = (button.y1 + button.y2) / 2.0 + 0.01;
            RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("effortless", "textures/action/" + button.action.name().toLowerCase() + ".png"));
            RadialMenuScreen.method_25293((class_4587)poseStack, (int)((int)(middleX + x - 8.0)), (int)((int)(middleY + y - 8.0)), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        }
        poseStack.method_22909();
    }

    private void drawTexts(class_4587 poseStack, BuildMode currentBuildMode, double middleX, double middleY, double textDistance, double buttonDistance, ArrayList<ModeRegion> modes, ArrayList<MenuButton> buttons, BuildMode.Option[] options) {
        for (int row = 0; row < options.length; ++row) {
            BuildMode.Option option = options[row];
            if (option == null) continue;
            this.field_22793.method_1720(poseStack, class_1074.method_4662((String)option.getNameKey(), (Object[])new Object[0]), (float)((int)(middleX + buttonDistance - 9.0)), (float)((int)middleY) + (float)options.length / -2.0f * 39.0f + 3.0f + (float)(row * 39), -286331137);
        }
        String credits = class_1074.method_4662((String)"effortless.credits", (Object[])new Object[0]);
        this.field_22793.method_1720(poseStack, credits, (float)(this.field_22789 - this.field_22793.method_1727(credits) - 10), (float)(this.field_22790 - 15), -2004318072);
        for (ModeRegion modeRegion : modes) {
            if (!modeRegion.highlighted) continue;
            double x = (modeRegion.x1 + modeRegion.x2) * 0.5;
            double y = (modeRegion.y1 + modeRegion.y2) * 0.5;
            int fixed_x = (int)(x * textDistance);
            int n = (int)(y * textDistance);
            Objects.requireNonNull(this.field_22793);
            int fixed_y = n - 9 / 2;
            String text = class_1074.method_4662((String)modeRegion.mode.getNameKey(), (Object[])new Object[0]);
            if (x <= -0.2) {
                fixed_x -= this.field_22793.method_1727(text);
            } else if (-0.2 <= x && x <= 0.2) {
                fixed_x -= this.field_22793.method_1727(text) / 2;
            }
            this.field_22793.method_1720(poseStack, text, (float)((int)middleX + fixed_x), (float)((int)middleY + fixed_y), -1);
            text = class_1074.method_4662((String)modeRegion.mode.getDescriptionKey(), (Object[])new Object[0]);
            this.field_22793.method_1720(poseStack, text, (float)((int)middleX) - (float)this.field_22793.method_1727(text) / 2.0f, (float)((int)middleY + 100), -578254712);
        }
        for (MenuButton button : buttons) {
            if (!button.highlighted) continue;
            String text = class_124.field_1075 + button.name;
            String keybind = this.findKeybind(button, currentBuildMode);
            Object keybindFormatted = "";
            if (!keybind.isEmpty()) {
                keybindFormatted = class_124.field_1080 + "(" + WordUtils.capitalizeFully((String)keybind) + ")";
            }
            switch (button.textSide) {
                case field_11039: {
                    this.field_22793.method_1729(poseStack, text, (float)((int)(middleX + button.x1 - 8.0) - this.field_22793.method_1727(text)), (float)((int)(middleY + button.y1 + 6.0)), -1);
                    break;
                }
                case field_11034: {
                    this.field_22793.method_1729(poseStack, text, (float)((int)(middleX + button.x2 + 8.0)), (float)((int)(middleY + button.y1 + 6.0)), -1);
                    break;
                }
                case field_11036: 
                case field_11043: {
                    this.field_22793.method_1729(poseStack, (String)keybindFormatted, (float)((int)(middleX + (button.x1 + button.x2) * 0.5 - (double)this.field_22793.method_1727((String)keybindFormatted) * 0.5)), (float)((int)(middleY + button.y1 - 26.0)), -1);
                    this.field_22793.method_1729(poseStack, text, (float)((int)(middleX + (button.x1 + button.x2) * 0.5 - (double)this.field_22793.method_1727(text) * 0.5)), (float)((int)(middleY + button.y1 - 14.0)), -1);
                    break;
                }
                case field_11033: 
                case field_11035: {
                    this.field_22793.method_1729(poseStack, text, (float)((int)(middleX + (button.x1 + button.x2) * 0.5 - (double)this.field_22793.method_1727(text) * 0.5)), (float)((int)(middleY + button.y1 + 26.0)), -1);
                    this.field_22793.method_1729(poseStack, (String)keybindFormatted, (float)((int)(middleX + (button.x1 + button.x2) * 0.5 - (double)this.field_22793.method_1727((String)keybindFormatted) * 0.5)), (float)((int)(middleY + button.y1 + 38.0)), -1);
                }
            }
        }
    }

    private String findKeybind(MenuButton button, BuildMode currentBuildMode) {
        Keys keybindingIndex = null;
        if (button.action == BuildAction.REPLACE) {
            keybindingIndex = Keys.TOGGLE_REPLACE;
        }
        if (button.action == BuildAction.MODIFIER) {
            keybindingIndex = Keys.MODIFIER_MENU;
        }
        if (keybindingIndex == null) {
            return "";
        }
        return keybindingIndex.getKeyMapping().field_1655.method_1441();
    }

    private boolean inTriangle(double x1, double y1, double x2, double y2, double x3, double y3, double x, double y) {
        double ab = (x1 - x) * (y2 - y) - (x2 - x) * (y1 - y);
        double bc = (x2 - x) * (y3 - y) - (x3 - x) * (y2 - y);
        double ca = (x3 - x) * (y1 - y) - (x1 - x) * (y3 - y);
        return this.sign(ab) == this.sign(bc) && this.sign(bc) == this.sign(ca);
    }

    private int sign(double n) {
        return n > 0.0 ? 1 : -1;
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.performAction(true);
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        class_746 player;
        if (!this.performedActionUsingMouse) {
            this.performAction(false);
        }
        if ((player = class_310.method_1551().field_1724) != null) {
            if (this.lastAction == null) {
                BuildMode mode = BuildModeHelper.getModeSettings((class_1657)player).buildMode();
                if (mode == BuildMode.DISABLE) {
                    Effortless.log((class_1657)player, BuildModeHelper.getTranslatedModeOptionName((class_1657)player), true);
                } else {
                    Effortless.log((class_1657)player, class_124.field_1065 + BuildModeHelper.getTranslatedModeOptionName((class_1657)player) + class_124.field_1070, true);
                }
            } else {
                ModeSettings modeSettings = BuildModeHelper.getModeSettings((class_1657)player);
                ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings((class_1657)player);
                switch (this.lastAction) {
                    case UNDO: {
                        Effortless.log((class_1657)player, "Undo", true);
                        break;
                    }
                    case REDO: {
                        Effortless.log((class_1657)player, "Redo", true);
                        break;
                    }
                    case REPLACE: {
                        Effortless.log((class_1657)player, class_124.field_1065 + "Replace " + class_124.field_1070 + (modifierSettings.enableReplace() ? (modifierSettings.enableQuickReplace() ? class_124.field_1060 + "QUICK" : class_124.field_1060 + "ON") : class_124.field_1061 + "OFF") + class_124.field_1070, true);
                        break;
                    }
                    case MAGNET: {
                        Effortless.log((class_1657)player, class_124.field_1065 + "Item Magnet " + class_124.field_1070 + (modeSettings.enableMagnet() ? class_124.field_1060 + "ON" : class_124.field_1061 + "OFF") + class_124.field_1070, true);
                    }
                }
            }
        }
        super.method_25419();
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
    }

    private void performAction(boolean fromMouseClick) {
        BuildAction action;
        class_746 player = class_310.method_1551().field_1724;
        ModeSettings modeSettings = BuildModeHelper.getModeSettings((class_1657)player);
        if (this.switchTo != null) {
            RadialMenuScreen.playRadialMenuSound();
            this.lastAction = null;
            modeSettings = new ModeSettings(this.switchTo, modeSettings.enableMagnet());
            BuildModeHelper.setModeSettings((class_1657)player, modeSettings);
            if (player != null) {
                BuildModeHandler.initializeMode((class_1657)player);
            }
            Packets.sendToServer(new ServerboundPlayerSetBuildModePacket(modeSettings));
            if (fromMouseClick) {
                this.performedActionUsingMouse = true;
            }
        }
        if ((action = this.doAction) != null) {
            RadialMenuScreen.playRadialMenuSound();
            this.lastAction = action;
            BuildActionHandler.performAction((class_1657)player, action);
            Packets.sendToServer(new ServerboundPlayerBuildActionPacket(action));
            if (fromMouseClick) {
                this.performedActionUsingMouse = true;
            }
        }
    }

    static class ModeRegion {
        private final BuildMode mode;
        private double x1;
        private double x2;
        private double y1;
        private double y2;
        private boolean highlighted;

        public ModeRegion(BuildMode mode) {
            this.mode = mode;
        }
    }

    static class MenuButton {
        private final BuildAction action;
        private final String name;
        private final class_2350 textSide;
        private double x1;
        private double x2;
        private double y1;
        private double y2;
        private boolean highlighted;

        public MenuButton(BuildAction action, double x, double y, class_2350 textSide) {
            this.name = class_1074.method_4662((String)action.getNameKey(), (Object[])new Object[0]);
            this.action = action;
            this.x1 = x - 10.0;
            this.x2 = x + 10.0;
            this.y1 = y - 10.0;
            this.y2 = y + 10.0;
            this.textSide = textSide;
        }
    }
}

