/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.screen.widget;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class NumberField
extends class_332 {
    public int x;
    public int y;
    public int width;
    public int height;
    public int buttonWidth = 10;
    protected class_342 textField;
    protected class_4185 minusButton;
    protected class_4185 plusButton;
    List<class_2561> tooltip = new ArrayList<class_2561>();

    public NumberField(class_327 font, List<class_4068> renderables, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textField = new class_342(font, x + this.buttonWidth + 1, y + 1, width - 2 * this.buttonWidth - 2, height - 2, class_2585.field_24366);
        this.minusButton = new class_4185(x, y - 1, this.buttonWidth, height + 2, (class_2561)new class_2585("-"), button -> {
            float valueChanged = 1.0f;
            if (class_437.method_25441()) {
                valueChanged = 5.0f;
            }
            if (class_437.method_25442()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() - (double)valueChanged);
        });
        this.plusButton = new class_4185(x + width - this.buttonWidth, y - 1, this.buttonWidth, height + 2, (class_2561)new class_2585("+"), button -> {
            float valueChanged = 1.0f;
            if (class_437.method_25441()) {
                valueChanged = 5.0f;
            }
            if (class_437.method_25442()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() + (double)valueChanged);
        });
        renderables.add((class_4068)this.minusButton);
        renderables.add((class_4068)this.plusButton);
    }

    public double getNumber() {
        if (this.textField.method_1882().isEmpty()) {
            return 0.0;
        }
        try {
            return DecimalFormat.getInstance().parse(this.textField.method_1882()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public void setNumber(double number) {
        this.textField.method_1852(DecimalFormat.getInstance().format(number));
    }

    public void setTooltip(class_2561 tooltip) {
        this.setTooltip(Collections.singletonList(tooltip));
    }

    public void setTooltip(List<class_2561> tooltip) {
        this.tooltip = tooltip;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag;
        boolean result = this.textField.method_25402(mouseX, mouseY, button);
        boolean bl = flag = mouseX >= (double)(this.x + this.buttonWidth) && mouseX < (double)(this.x + this.width - this.buttonWidth) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        if (flag && button == 1) {
            this.textField.method_1852("");
            this.textField.method_1876(true);
            result = true;
        }
        return result;
    }

    public void drawNumberField(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.textField.field_22761 = this.y + 1;
        this.minusButton.field_22761 = this.y - 1;
        this.plusButton.field_22761 = this.y - 1;
        this.textField.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.minusButton.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.plusButton.method_25394(poseStack, mouseX, mouseY, partialTicks);
    }

    public void drawTooltip(class_4587 poseStack, class_437 screen, int mouseX, int mouseY) {
        boolean insideTextField = mouseX >= this.x + this.buttonWidth && mouseX < this.x + this.width - this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insideMinusButton = mouseX >= this.x && mouseX < this.x + this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insidePlusButton = mouseX >= this.x + this.width - this.buttonWidth && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        ArrayList<Object> textLines = new ArrayList<Object>();
        if (insideTextField) {
            textLines.addAll(this.tooltip);
        }
        if (insideMinusButton) {
            textLines.add(new class_2585("Hold ").method_10852((class_2561)new class_2585("shift ").method_27692(class_124.field_1075)).method_27693("for ").method_10852((class_2561)new class_2585("10").method_27692(class_124.field_1061)));
            textLines.add(new class_2585("Hold ").method_10852((class_2561)new class_2585("ctrl ").method_27692(class_124.field_1075)).method_27693("for ").method_10852((class_2561)new class_2585("5").method_27692(class_124.field_1061)));
        }
        if (insidePlusButton) {
            textLines.add(new class_2585("Hold ").method_10852((class_2561)new class_2585("shift ").method_27692(class_124.field_1077)).method_27693("for ").method_10852((class_2561)new class_2585("10").method_27692(class_124.field_1061)));
            textLines.add(new class_2585("Hold ").method_10852((class_2561)new class_2585("ctrl ").method_27692(class_124.field_1077)).method_27693("for ").method_10852((class_2561)new class_2585("5").method_27692(class_124.field_1061)));
        }
        screen.method_30901(poseStack, textLines, mouseX - 10, mouseY + 25);
    }

    public void update() {
        this.textField.method_1865();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.textField.method_25370()) {
            return false;
        }
        return this.textField.method_25400(typedChar, keyCode);
    }
}

