/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmode.BuildModeHandler;
import dev.huskcasaca.effortless.buildmode.BuildModeHelper;
import dev.huskcasaca.effortless.control.Keys;
import dev.huskcasaca.effortless.entity.player.ModeSettings;
import dev.huskcasaca.effortless.event.ClientReloadShadersEvent;
import dev.huskcasaca.effortless.event.ClientScreenEvent;
import dev.huskcasaca.effortless.event.ClientScreenInputEvent;
import dev.huskcasaca.effortless.network.Packets;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerSetBuildModePacket;
import dev.huskcasaca.effortless.render.BlockPreviewRenderer;
import dev.huskcasaca.effortless.render.BuildRenderType;
import dev.huskcasaca.effortless.render.ModifierRenderer;
import dev.huskcasaca.effortless.screen.buildmode.PlayerSettingsScreen;
import dev.huskcasaca.effortless.screen.buildmode.RadialMenuScreen;
import dev.huskcasaca.effortless.screen.buildmodifier.ModifierSettingsScreen;
import dev.huskcasaca.effortless.screen.config.EffortlessConfigScreen;
import java.io.IOException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class EffortlessClient
implements ClientModInitializer {
    public static class_304[] keyBindings;
    public static class_239 previousLookAt;
    public static class_239 currentLookAt;
    private static int ticksInGame;

    public static void onStartClientTick(class_310 client) {
        class_239 objectMouseOver = class_310.method_1551().field_1765;
        if (objectMouseOver == null) {
            return;
        }
        if (currentLookAt == null) {
            currentLookAt = objectMouseOver;
            previousLookAt = objectMouseOver;
            return;
        }
        if (objectMouseOver.method_17783() == class_239.class_240.field_1332) {
            if (currentLookAt.method_17783() != class_239.class_240.field_1332) {
                currentLookAt = objectMouseOver;
                previousLookAt = objectMouseOver;
            } else if (((class_3965)currentLookAt).method_17777() != ((class_3965)objectMouseOver).method_17777()) {
                previousLookAt = currentLookAt;
                currentLookAt = objectMouseOver;
            }
        }
    }

    public static void onEndClientTick(class_310 client) {
        class_437 gui = class_310.method_1551().field_1755;
        if (gui == null || !gui.method_25421()) {
            ++ticksInGame;
        }
    }

    public static void onKeyPress(int key, int scanCode, int action, int modifiers) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (Keys.MODIFIER_MENU.getKeyMapping().method_1436()) {
            EffortlessClient.openModifierSettings();
        }
        if (Keys.SHOW_RADIAL_MENU.isDown() && !RadialMenuScreen.getInstance().isVisible()) {
            class_310.method_1551().method_1507((class_437)RadialMenuScreen.getInstance());
        }
    }

    public static void openModifierSettings() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        if (ReachHelper.getMaxReachDistance((class_1657)player) == 0) {
            Effortless.log((class_1657)player, "Build modifiers are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
        } else {
            mc.method_1507(null);
            mc.method_1507((class_437)new ModifierSettingsScreen());
        }
    }

    public static void openPlayerSettings() {
        class_310 mc = class_310.method_1551();
        mc.method_1507((class_437)new PlayerSettingsScreen());
    }

    public static void openSettings() {
        class_310 mc = class_310.method_1551();
        mc.method_1507(EffortlessConfigScreen.createConfigScreen(mc.field_1755));
    }

    public static void onScreenEvent(class_437 screen) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            ModeSettings modeSettings = BuildModeHelper.getModeSettings((class_1657)player);
            BuildModeHelper.setModeSettings((class_1657)player, modeSettings);
            BuildModeHandler.initializeMode((class_1657)player);
            Packets.sendToServer(new ServerboundPlayerSetBuildModePacket(modeSettings));
        }
    }

    protected static class_3965 getPlayerPOVHitResult(class_1937 level, class_1657 player, class_3959.class_242 fluid) {
        float f = player.method_36455();
        float g = player.method_36454();
        class_243 vec3 = player.method_33571();
        float h = class_3532.method_15362((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = class_3532.method_15374((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float m = k;
        float n = h * j;
        double d = 5.0;
        class_243 vec32 = vec3.method_1031((double)l * 5.0, (double)m * 5.0, (double)n * 5.0);
        return level.method_17742(new class_3959(vec3, vec32, class_3959.class_3960.field_17559, fluid, (class_1297)player));
    }

    public static class_239 getLookingAt(class_1657 player) {
        class_1937 level = player.field_6002;
        float raytraceRange = ReachHelper.getPlacementReach(player) * 4;
        class_243 look = player.method_5720();
        class_243 start = new class_243(player.method_23317(), player.method_23318() + (double)player.method_5751(), player.method_23321());
        class_243 end = new class_243(player.method_23317() + look.field_1352 * (double)raytraceRange, player.method_23318() + (double)player.method_5751() + look.field_1351 * (double)raytraceRange, player.method_23321() + look.field_1350 * (double)raytraceRange);
        return level.method_17742(new class_3959(start, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
    }

    public static void registerShaders(class_3300 resourceManager, ClientReloadShadersEvent.ShaderRegister.ShadersSink sink) throws IOException {
        sink.registerShader(new class_5944((class_5912)resourceManager, "dissolve", class_290.field_1590), shaderInstance -> BuildRenderType.setDissolveShaderInstance(shaderInstance));
    }

    public static int getTicksInGame() {
        return ticksInGame;
    }

    public void onInitializeClient() {
        Keys.register();
        ClientScreenEvent.SCREEN_OPENING_EVENT.register(EffortlessClient::onScreenEvent);
        ClientScreenInputEvent.KEY_PRESS_EVENT.register(EffortlessClient::onKeyPress);
        ClientTickEvents.START_CLIENT_TICK.register(EffortlessClient::onStartClientTick);
        ClientTickEvents.END_CLIENT_TICK.register(EffortlessClient::onEndClientTick);
        ClientReloadShadersEvent.REGISTER_SHADER.register(EffortlessClient::registerShaders);
        WorldRenderEvents.AFTER_ENTITIES.register(context -> EffortlessClient.renderBlockPreview(context.matrixStack(), context.camera()));
        WorldRenderEvents.LAST.register(context -> EffortlessClient.renderModifierSettings(context.matrixStack(), context.camera()));
    }

    public static void renderBlockPreview(class_4587 poseStack, class_4184 camera) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)bufferBuilder);
        class_746 player = class_310.method_1551().field_1724;
        BlockPreviewRenderer.getInstance().render((class_1657)player, poseStack, bufferSource, camera);
    }

    public static void renderModifierSettings(class_4587 poseStack, class_4184 camera) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)bufferBuilder);
        class_746 player = class_310.method_1551().field_1724;
        ModifierRenderer.getInstance().render((class_1657)player, poseStack, bufferSource, camera);
    }

    static {
        ticksInGame = 0;
    }
}

