/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmode;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmode.BuildMode;
import dev.huskcasaca.effortless.buildmode.BuildModeHelper;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHandler;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.entity.player.EffortlessDataProvider;
import dev.huskcasaca.effortless.entity.player.ModeSettings;
import dev.huskcasaca.effortless.entity.player.ModifierSettings;
import dev.huskcasaca.effortless.network.Packets;
import dev.huskcasaca.effortless.network.protocol.player.ClientboundPlayerBuildModePacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerBreakBlockPacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerPlaceBlockPacket;
import dev.huskcasaca.effortless.utils.SurvivalHelper;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class BuildModeHandler {
    private static final Dictionary<class_1657, Boolean> currentlyBreakingClient = new Hashtable<class_1657, Boolean>();
    private static final Dictionary<class_1657, Boolean> currentlyBreakingServer = new Hashtable<class_1657, Boolean>();

    public static void onBlockPlacedPacketReceived(class_1657 player, ServerboundPlayerPlaceBlockPacket packet) {
        class_243 hitVec;
        class_2350 hitSide;
        Dictionary<class_1657, Boolean> currentlyBreaking;
        Dictionary<class_1657, Boolean> dictionary = currentlyBreaking = player.field_6002.field_9236 ? currentlyBreakingClient : currentlyBreakingServer;
        if (currentlyBreaking.get(player) != null && currentlyBreaking.get(player).booleanValue()) {
            BuildModeHandler.initializeMode(player);
            return;
        }
        ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings(player);
        ModeSettings modeSettings = BuildModeHelper.getModeSettings(player);
        BuildMode buildMode = modeSettings.buildMode();
        class_2338 startPos = null;
        if (packet.blockHit() && packet.blockPos() != null) {
            startPos = packet.blockPos();
            boolean replaceable = player.field_6002.method_8320(startPos).method_26207().method_15800();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos, packet.hitSide());
            if (!(modifierSettings.enableQuickReplace() || replaceable || becomesDoubleSlab)) {
                startPos = startPos.method_10093(packet.hitSide());
            }
            if (modifierSettings.enableQuickReplace() && replaceable) {
                startPos = startPos.method_10074();
            }
            int maxReach = ReachHelper.getMaxReachDistance(player);
            if (buildMode != BuildMode.DISABLE && player.method_24515().method_10262((class_2382)startPos) > (double)(maxReach * maxReach)) {
                Effortless.log(player, "Placement exceeds your reach.");
                return;
            }
        }
        boolean skipRaytrace = modifierSettings.enableQuickReplace();
        List<class_2338> coordinates = buildMode.getInstance().onUse(player, startPos, packet.hitSide(), packet.hitVec(), skipRaytrace);
        if (coordinates.isEmpty()) {
            currentlyBreaking.put(player, false);
            return;
        }
        int limit = ReachHelper.getMaxBlockPlaceAtOnce(player);
        if (coordinates.size() > limit) {
            coordinates = coordinates.subList(0, limit);
        }
        if ((hitSide = buildMode.getInstance().getHitSide(player)) == null) {
            hitSide = packet.hitSide();
        }
        if ((hitVec = buildMode.getInstance().getHitVec(player)) == null) {
            hitVec = packet.hitVec();
        }
        BuildModifierHandler.onBlockPlaced(player, coordinates, hitSide, hitVec, packet.placeStartPos());
        currentlyBreaking.remove(player);
    }

    public static void onBlockBrokenPacketReceived(class_1657 player, ServerboundPlayerBreakBlockPacket packet) {
        class_2338 startPos = packet.blockHit() ? packet.blockPos() : null;
        BuildModeHandler.onBlockBroken(player, startPos, true);
    }

    public static void onBlockBroken(class_1657 player, class_2338 startPos, boolean breakStartPos) {
        Dictionary<class_1657, Boolean> currentlyBreaking;
        Dictionary<class_1657, Boolean> dictionary = currentlyBreaking = player.field_6002.field_9236 ? currentlyBreakingClient : currentlyBreakingServer;
        if (currentlyBreaking.get(player) != null && !currentlyBreaking.get(player).booleanValue()) {
            BuildModeHandler.initializeMode(player);
            return;
        }
        if (!ReachHelper.isCanBreakFar(player)) {
            return;
        }
        if (currentlyBreaking.get(player) == null && startPos == null) {
            return;
        }
        ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings(player);
        ModeSettings modeSettings = BuildModeHelper.getModeSettings(player);
        BuildMode buildMode = modeSettings.buildMode();
        List<class_2338> coordinates = buildMode.getInstance().onUse(player, startPos, class_2350.field_11036, class_243.field_1353, true);
        if (coordinates.isEmpty()) {
            currentlyBreaking.put(player, true);
            return;
        }
        BuildModifierHandler.onBlockBroken(player, coordinates, breakStartPos);
        currentlyBreaking.remove(player);
    }

    public static List<class_2338> findCoordinates(class_1657 player, class_2338 startPos, boolean skipRaytrace) {
        ArrayList<class_2338> coordinates = new ArrayList<class_2338>();
        ModeSettings modeSettings = BuildModeHelper.getModeSettings(player);
        coordinates.addAll(modeSettings.buildMode().getInstance().findCoordinates(player, startPos, skipRaytrace));
        return coordinates;
    }

    public static void initializeMode(class_1657 player) {
        if (player == null) {
            return;
        }
        Dictionary<class_1657, Boolean> currentlyBreaking = player.field_6002.field_9236 ? currentlyBreakingClient : currentlyBreakingServer;
        currentlyBreaking.remove(player);
        BuildModeHelper.getModeSettings(player).buildMode().getInstance().initialize(player);
    }

    public static boolean isCurrentlyPlacing(class_1657 player) {
        Dictionary<class_1657, Boolean> currentlyBreaking = player.field_6002.field_9236 ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null && currentlyBreaking.get(player) == false;
    }

    public static boolean isCurrentlyBreaking(class_1657 player) {
        Dictionary<class_1657, Boolean> currentlyBreaking = player.field_6002.field_9236 ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null && currentlyBreaking.get(player) != false;
    }

    public static boolean isActive(class_1657 player) {
        Dictionary<class_1657, Boolean> currentlyBreaking = player.field_6002.field_9236 ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null;
    }

    public static class_243 findXBound(double x, class_243 start, class_243 look) {
        double y = (x - start.field_1352) / look.field_1352 * look.field_1351 + start.field_1351;
        double z = (x - start.field_1352) / look.field_1352 * look.field_1350 + start.field_1350;
        return new class_243(x, y, z);
    }

    public static class_243 findYBound(double y, class_243 start, class_243 look) {
        double x = (y - start.field_1351) / look.field_1351 * look.field_1352 + start.field_1352;
        double z = (y - start.field_1351) / look.field_1351 * look.field_1350 + start.field_1350;
        return new class_243(x, y, z);
    }

    public static class_243 findZBound(double z, class_243 start, class_243 look) {
        double x = (z - start.field_1350) / look.field_1350 * look.field_1352 + start.field_1352;
        double y = (z - start.field_1350) / look.field_1350 * look.field_1351 + start.field_1351;
        return new class_243(x, y, z);
    }

    public static class_243 getPlayerLookVec(class_1657 player) {
        class_243 lookVec = player.method_5720();
        double x = lookVec.field_1352;
        double y = lookVec.field_1351;
        double z = lookVec.field_1350;
        if (Math.abs(x) < 1.0E-4) {
            x = 1.0E-4;
        }
        if (Math.abs(x - 1.0) < 1.0E-4) {
            x = 0.9999;
        }
        if (Math.abs(x + 1.0) < 1.0E-4) {
            x = -0.9999;
        }
        if (Math.abs(y) < 1.0E-4) {
            y = 1.0E-4;
        }
        if (Math.abs(y - 1.0) < 1.0E-4) {
            y = 0.9999;
        }
        if (Math.abs(y + 1.0) < 1.0E-4) {
            y = -0.9999;
        }
        if (Math.abs(z) < 1.0E-4) {
            z = 1.0E-4;
        }
        if (Math.abs(z - 1.0) < 1.0E-4) {
            z = 0.9999;
        }
        if (Math.abs(z + 1.0) < 1.0E-4) {
            z = -0.9999;
        }
        return new class_243(x, y, z);
    }

    public static boolean isCriteriaValid(class_243 start, class_243 look, int reach, class_1657 player, boolean skipRaytrace, class_243 lineBound, class_243 planeBound, double distToPlayerSq) {
        boolean intersects = false;
        if (!skipRaytrace) {
            class_3959 rayTraceContext = new class_3959(start, lineBound, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player);
            class_3965 rayTraceResult = player.field_6002.method_17742(rayTraceContext);
            intersects = rayTraceResult != null && rayTraceResult.method_17783() == class_239.class_240.field_1332 && planeBound.method_1020(rayTraceResult.method_17784()).method_1027() > 4.0;
        }
        return planeBound.method_1020(start).method_1026(look) > 0.0 && distToPlayerSq > 2.0 && distToPlayerSq < (double)(reach * reach) && !intersects;
    }

    public static void handleNewPlayer(class_3222 player) {
        Packets.sendToClient(new ClientboundPlayerBuildModePacket(((EffortlessDataProvider)player).getModeSettings()), player);
    }
}

