/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmodifier;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmodifier.ReplaceMode;
import dev.huskcasaca.effortless.buildmodifier.array.Array;
import dev.huskcasaca.effortless.buildmodifier.mirror.Mirror;
import dev.huskcasaca.effortless.buildmodifier.mirror.RadialMirror;
import dev.huskcasaca.effortless.entity.player.EffortlessDataProvider;
import dev.huskcasaca.effortless.entity.player.ModifierSettings;
import dev.huskcasaca.effortless.network.Packets;
import dev.huskcasaca.effortless.network.protocol.player.ClientboundPlayerBuildModifierPacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerSetBuildModifierPacket;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BuildModifierHelper {
    public static ModifierSettings getModifierSettings(class_1657 player) {
        return ((EffortlessDataProvider)player).getModifierSettings();
    }

    public static void setModifierSettings(class_1657 player, ModifierSettings modifierSettings) {
        if (player == null) {
            Effortless.log("Cannot set build modifier settings, player is null");
            return;
        }
        ((EffortlessDataProvider)player).setModifierSettings(modifierSettings);
    }

    public static boolean isReplace(class_1657 player) {
        return BuildModifierHelper.getModifierSettings(player).enableReplace();
    }

    public static boolean isQuickReplace(class_1657 player) {
        return BuildModifierHelper.getModifierSettings(player).enableQuickReplace();
    }

    public static ReplaceMode getReplaceMode(class_1657 player) {
        return BuildModifierHelper.getModifierSettings(player).replaceMode();
    }

    public static void setReplaceMode(class_1657 player, ReplaceMode mode) {
        ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings(player);
        modifierSettings = new ModifierSettings(modifierSettings.arraySettings(), modifierSettings.mirrorSettings(), modifierSettings.radialMirrorSettings(), mode);
        BuildModifierHelper.setModifierSettings(player, modifierSettings);
        BuildModifierHelper.setModifierSettings(player, modifierSettings);
    }

    public static void cycleReplaceMode(class_1657 player) {
        ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings(player);
        modifierSettings = new ModifierSettings(modifierSettings.arraySettings(), modifierSettings.mirrorSettings(), modifierSettings.radialMirrorSettings(), ReplaceMode.values()[(modifierSettings.replaceMode().ordinal() + 1) % ReplaceMode.values().length]);
        BuildModifierHelper.setModifierSettings(player, modifierSettings);
        BuildModifierHelper.setModifierSettings(player, modifierSettings);
    }

    public static void sync(class_1657 player) {
        if (player instanceof class_3222) {
            Packets.sendToClient(new ClientboundPlayerBuildModifierPacket(BuildModifierHelper.getModifierSettings(player)), (class_3222)player);
        } else {
            Packets.sendToServer(new ServerboundPlayerSetBuildModifierPacket(BuildModifierHelper.getModifierSettings(player)));
        }
    }

    public static class_2561 getReplaceModeName(class_1657 player) {
        ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings(player);
        return class_2561.method_43470((String)(class_124.field_1065 + "Replace " + class_124.field_1070 + (modifierSettings.enableReplace() ? (modifierSettings.enableQuickReplace() ? class_124.field_1060 + "QUICK" : class_124.field_1060 + "ON") : class_124.field_1061 + "OFF") + class_124.field_1070));
    }

    public static String getSanitizeMessage(ModifierSettings modifierSettings, class_1657 player) {
        RadialMirror.RadialMirrorSettings radialMirrorSettings;
        Mirror.MirrorSettings mirrorSettings;
        int maxReach = ReachHelper.getMaxReachDistance(player);
        Object error = "";
        Array.ArraySettings arraySettings = modifierSettings.arraySettings();
        if (arraySettings.count() < 1) {
            error = (String)error + "Array count has to be at least 1. It has been reset to 1. \n";
        }
        if (arraySettings.reach() > maxReach) {
            error = (String)error + "Array exceeds your maximum reach of " + maxReach + ". Array count has been reset to 0. \n";
        }
        if ((mirrorSettings = modifierSettings.mirrorSettings()).radius() < 1) {
            error = (String)error + "Mirror size has to be at least 1. This has been corrected. \n";
        }
        if (mirrorSettings.reach() > maxReach) {
            error = (String)error + "Mirror exceeds your maximum reach of " + maxReach / 2 + ". Radius has been set to " + maxReach / 2 + ". \n";
        }
        if ((radialMirrorSettings = modifierSettings.radialMirrorSettings()).slices() < 2) {
            error = (String)error + "Radial mirror needs to have at least 2 slices. Slices has been set to 2. \n";
        }
        if (radialMirrorSettings.radius() < 1) {
            error = (String)error + "Radial mirror radius has to be at least 1. This has been corrected. \n";
        }
        if (radialMirrorSettings.reach() > maxReach) {
            error = (String)error + "Radial mirror exceeds your maximum reach of " + maxReach / 2 + ". Radius has been set to " + maxReach / 2 + ". \n";
        }
        return error;
    }

    public static ModifierSettings sanitize(ModifierSettings modifierSettings, class_1657 player) {
        int radius1;
        int maxReach = ReachHelper.getMaxReachDistance(player);
        Array.ArraySettings arraySettings = modifierSettings.arraySettings();
        int count = arraySettings.count();
        if (count < 1) {
            count = 1;
        }
        if (arraySettings.reach() > maxReach) {
            count = 1;
        }
        arraySettings = new Array.ArraySettings(arraySettings.enabled(), arraySettings.offset(), count);
        Mirror.MirrorSettings mirrorSettings = modifierSettings.mirrorSettings();
        int radius = mirrorSettings.radius();
        if (radius < 1) {
            radius = 1;
        }
        if (mirrorSettings.reach() > maxReach) {
            radius = maxReach / 2;
        }
        mirrorSettings = new Mirror.MirrorSettings(mirrorSettings.enabled(), mirrorSettings.position(), mirrorSettings.mirrorX(), mirrorSettings.mirrorY(), mirrorSettings.mirrorZ(), radius, mirrorSettings.drawLines(), mirrorSettings.drawPlanes());
        RadialMirror.RadialMirrorSettings radialMirrorSettings = modifierSettings.radialMirrorSettings();
        int slices = radialMirrorSettings.slices();
        if (slices < 2) {
            slices = 2;
        }
        if ((radius1 = radialMirrorSettings.radius()) < 1) {
            radius1 = 1;
        }
        if (radialMirrorSettings.reach() > maxReach) {
            radius1 = maxReach / 2;
        }
        radialMirrorSettings = new RadialMirror.RadialMirrorSettings(radialMirrorSettings.enabled(), radialMirrorSettings.position(), slices, radialMirrorSettings.alternate(), radius1, radialMirrorSettings.drawLines(), radialMirrorSettings.drawPlanes());
        ReplaceMode replaceMode = modifierSettings.replaceMode();
        return new ModifierSettings(arraySettings, mirrorSettings, radialMirrorSettings, replaceMode);
    }
}

