/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmodifier;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmodifier.BlockSet;
import dev.huskcasaca.effortless.render.BlockPreviewRenderer;
import dev.huskcasaca.effortless.utils.FixedStack;
import dev.huskcasaca.effortless.utils.InventoryHelper;
import dev.huskcasaca.effortless.utils.SurvivalHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class UndoRedo {
    private static final Map<UUID, FixedStack<BlockSet>> undoStacksClient = new HashMap<UUID, FixedStack<BlockSet>>();
    private static final Map<UUID, FixedStack<BlockSet>> undoStacksServer = new HashMap<UUID, FixedStack<BlockSet>>();
    private static final Map<UUID, FixedStack<BlockSet>> redoStacksClient = new HashMap<UUID, FixedStack<BlockSet>>();
    private static final Map<UUID, FixedStack<BlockSet>> redoStacksServer = new HashMap<UUID, FixedStack<BlockSet>>();

    public static boolean isUndoEnabled(class_1657 player) {
        return ReachHelper.getReachSettings(player).enableUndoRedo();
    }

    public static void addUndo(class_1657 player, BlockSet blockSet) {
        Map<UUID, FixedStack<BlockSet>> undoStacks;
        if (!UndoRedo.isUndoEnabled(player)) {
            return;
        }
        Map<UUID, FixedStack<BlockSet>> map = undoStacks = player.field_6002.field_9236 ? undoStacksClient : undoStacksServer;
        if (blockSet.coordinates().size() != blockSet.previousBlockStates().size() || blockSet.coordinates().size() != blockSet.newBlockStates().size()) {
            Effortless.logger.error("Coordinates and blockstate lists are not equal length. Coordinates: {}. Previous blockstates: {}. New blockstates: {}.", (Object)blockSet.coordinates().size(), (Object)blockSet.previousBlockStates().size(), (Object)blockSet.newBlockStates().size());
        }
        if (!undoStacks.containsKey(player.method_5667())) {
            undoStacks.put(player.method_5667(), new FixedStack<BlockSet>(new BlockSet[UndoRedo.getUndoStackSize(player)]));
        }
        undoStacks.get(player.method_5667()).push(blockSet);
    }

    private static int getUndoStackSize(class_1657 player) {
        if (!UndoRedo.isUndoEnabled(player)) {
            return 0;
        }
        return ReachHelper.getReachSettings(player).undoStackSize();
    }

    private static void addRedo(class_1657 player, BlockSet blockSet) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        if (!UndoRedo.isUndoEnabled(player)) {
            return;
        }
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_6002.field_9236 ? redoStacksClient : redoStacksServer;
        if (!redoStacks.containsKey(player.method_5667())) {
            redoStacks.put(player.method_5667(), new FixedStack<BlockSet>(new BlockSet[UndoRedo.getUndoStackSize(player)]));
        }
        redoStacks.get(player.method_5667()).push(blockSet);
    }

    public static boolean undo(class_1657 player) {
        Map<UUID, FixedStack<BlockSet>> undoStacks;
        if (!UndoRedo.isUndoEnabled(player)) {
            Effortless.log(player, "Sorry, undo is disabled.");
            return false;
        }
        Map<UUID, FixedStack<BlockSet>> map = undoStacks = player.field_6002.field_9236 ? undoStacksClient : undoStacksServer;
        if (!undoStacks.containsKey(player.method_5667())) {
            return false;
        }
        FixedStack<BlockSet> undoStack = undoStacks.get(player.method_5667());
        if (undoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = undoStack.pop();
        List<class_2338> coordinates = blockSet.coordinates();
        List<class_2680> previousBlockStates = blockSet.previousBlockStates();
        List<class_2680> newBlockStates = blockSet.newBlockStates();
        class_243 hitVec = blockSet.hitVec();
        List<class_1799> itemStacks = UndoRedo.findItemStacksInInventory(player, previousBlockStates);
        if (player.field_6002.field_9236) {
            BlockPreviewRenderer.getInstance().onBlocksBroken(coordinates, itemStacks, newBlockStates, blockSet.secondPos(), blockSet.firstPos());
        } else {
            for (int i = 0; i < coordinates.size(); ++i) {
                class_2338 coordinate = coordinates.get(i);
                class_1799 itemStack = itemStacks.get(i);
                if (previousBlockStates.get(i).equals(newBlockStates.get(i))) continue;
                class_2680 previousBlockState = class_2246.field_10124.method_9564();
                if (itemStack.method_7909() instanceof class_1747) {
                    previousBlockState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
                }
                if (!player.field_6002.method_8477(coordinate)) continue;
                if (itemStack.method_7960()) {
                    itemStack = UndoRedo.findItemStackInInventory(player, previousBlockStates.get(i));
                    if (!itemStack.method_7960() && itemStack.method_7909() instanceof class_1747) {
                        previousBlockState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
                    } else {
                        if (previousBlockStates.get(i).method_26204() != class_2246.field_10124) {
                            Effortless.logTranslate(player, "", previousBlockStates.get(i).method_26204().method_9539(), " not found in inventory", true);
                        }
                        previousBlockState = class_2246.field_10124.method_9564();
                    }
                }
                if (itemStack.method_7960()) {
                    SurvivalHelper.breakBlock(player.field_6002, player, coordinate, true);
                }
                SurvivalHelper.placeBlock(player.field_6002, player, coordinate, previousBlockState, itemStack, class_2350.field_11036, hitVec, true, false, false);
            }
        }
        UndoRedo.addRedo(player, blockSet);
        return true;
    }

    public static boolean redo(class_1657 player) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        if (!UndoRedo.isUndoEnabled(player)) {
            Effortless.log(player, "Sorry, redo is disabled.");
            return false;
        }
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_6002.field_9236 ? redoStacksClient : redoStacksServer;
        if (!redoStacks.containsKey(player.method_5667())) {
            return false;
        }
        FixedStack<BlockSet> redoStack = redoStacks.get(player.method_5667());
        if (redoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = redoStack.pop();
        List<class_2338> coordinates = blockSet.coordinates();
        List<class_2680> previousBlockStates = blockSet.previousBlockStates();
        List<class_2680> newBlockStates = blockSet.newBlockStates();
        class_243 hitVec = blockSet.hitVec();
        List<class_1799> itemStacks = UndoRedo.findItemStacksInInventory(player, newBlockStates);
        if (player.field_6002.field_9236) {
            BlockPreviewRenderer.getInstance().onBlocksPlaced(coordinates, itemStacks, newBlockStates, blockSet.firstPos(), blockSet.secondPos());
        } else {
            for (int i = 0; i < coordinates.size(); ++i) {
                class_2338 coordinate = coordinates.get(i);
                class_1799 itemStack = itemStacks.get(i);
                if (previousBlockStates.get(i).equals(newBlockStates.get(i))) continue;
                class_2680 newBlockState = class_2246.field_10124.method_9564();
                if (itemStack.method_7909() instanceof class_1747) {
                    newBlockState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
                }
                if (!player.field_6002.method_8477(coordinate)) continue;
                if (itemStack.method_7960()) {
                    itemStack = UndoRedo.findItemStackInInventory(player, newBlockStates.get(i));
                    if (!itemStack.method_7960() && itemStack.method_7909() instanceof class_1747) {
                        newBlockState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
                    } else {
                        if (newBlockStates.get(i).method_26204() != class_2246.field_10124) {
                            Effortless.logTranslate(player, "", newBlockStates.get(i).method_26204().method_9539(), " not found in inventory", true);
                        }
                        newBlockState = class_2246.field_10124.method_9564();
                    }
                }
                if (itemStack.method_7960()) {
                    SurvivalHelper.breakBlock(player.field_6002, player, coordinate, true);
                }
                SurvivalHelper.placeBlock(player.field_6002, player, coordinate, newBlockState, itemStack, class_2350.field_11036, hitVec, true, false, false);
            }
        }
        UndoRedo.addUndo(player, blockSet);
        return true;
    }

    public static void clear(class_1657 player) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> undoStacks = player.field_6002.field_9236 ? undoStacksClient : undoStacksServer;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_6002.field_9236 ? redoStacksClient : redoStacksServer;
        if (undoStacks.containsKey(player.method_5667())) {
            undoStacks.get(player.method_5667()).clear();
        }
        if (redoStacks.containsKey(player.method_5667())) {
            redoStacks.get(player.method_5667()).clear();
        }
    }

    private static List<class_1799> findItemStacksInInventory(class_1657 player, List<class_2680> blockStates) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>(blockStates.size());
        for (class_2680 blockState : blockStates) {
            itemStacks.add(UndoRedo.findItemStackInInventory(player, blockState));
        }
        return itemStacks;
    }

    private static class_1799 findItemStackInInventory(class_1657 player, class_2680 blockState) {
        class_1799 itemStack = class_1799.field_8037;
        if (blockState == null) {
            return itemStack;
        }
        if (player.method_7337()) {
            return new class_1799((class_1935)blockState.method_26204().method_8389());
        }
        itemStack = InventoryHelper.findItemStackInInventory(player, blockState.method_26204());
        if (itemStack.method_7960() && !player.field_6002.field_9236) {
            List itemsDropped = class_2248.method_9562((class_2680)blockState, (class_3218)((class_3218)player.field_6002), (class_2338)class_2338.field_10980, null);
            for (class_1799 itemStackDropped : itemsDropped) {
                if (!(itemStackDropped.method_7909() instanceof class_1747)) continue;
                class_2248 block = ((class_1747)itemStackDropped.method_7909()).method_7711();
                itemStack = InventoryHelper.findItemStackInInventory(player, block);
            }
        }
        return itemStack;
    }
}

