/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.screen.buildmodifier;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.buildmodifier.mirror.Mirror;
import dev.huskcasaca.effortless.entity.player.ModifierSettings;
import dev.huskcasaca.effortless.screen.widget.Checkbox;
import dev.huskcasaca.effortless.screen.widget.ExpandableScrollEntry;
import dev.huskcasaca.effortless.screen.widget.IconButton;
import dev.huskcasaca.effortless.screen.widget.NumberField;
import dev.huskcasaca.effortless.screen.widget.ScrollPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class MirrorSettingsPane
extends ExpandableScrollEntry {
    protected static final class_2960 BUILDING_ICONS = new class_2960("effortless", "textures/gui/building_icons.png");
    protected List<class_4185> mirrorButtonList = new ArrayList<class_4185>();
    protected List<IconButton> mirrorIconButtonList = new ArrayList<IconButton>();
    protected List<NumberField> mirrorNumberFieldList = new ArrayList<NumberField>();
    private NumberField textMirrorPosX;
    private NumberField textMirrorPosY;
    private NumberField textMirrorPosZ;
    private NumberField textMirrorRadius;
    private Checkbox buttonMirrorEnabled;
    private Checkbox buttonMirrorX;
    private Checkbox buttonMirrorY;
    private Checkbox buttonMirrorZ;
    private IconButton buttonCurrentPosition;
    private IconButton buttonToggleOdd;
    private IconButton buttonDrawPlanes;
    private IconButton buttonDrawLines;
    private boolean drawPlanes;
    private boolean drawLines;
    private boolean toggleOdd;

    public MirrorSettingsPane(ScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public void init(List<class_4068> renderables) {
        super.init(renderables);
        int y = this.top - 2;
        this.buttonMirrorEnabled = new Checkbox(this.left - 15 + 8, y, "", false){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                MirrorSettingsPane.this.setCollapsed(!MirrorSettingsPane.this.buttonMirrorEnabled.isChecked());
            }
        };
        renderables.add((class_4068)this.buttonMirrorEnabled);
        y = this.top + 20;
        this.textMirrorPosX = new NumberField(this.font, renderables, this.left + 60, y, 90, 18);
        this.textMirrorPosX.setNumber(0.0);
        this.textMirrorPosX.setTooltip(Arrays.asList(class_2561.method_43470((String)"The position of the mirror."), class_2561.method_43470((String)"For odd numbered builds add 0.5.").method_27692(class_124.field_1080)));
        this.mirrorNumberFieldList.add(this.textMirrorPosX);
        this.textMirrorPosY = new NumberField(this.font, renderables, this.left + 60, y + 24, 90, 18);
        this.textMirrorPosY.setNumber(64.0);
        this.textMirrorPosY.setTooltip(Arrays.asList(class_2561.method_43470((String)"The position of the mirror."), class_2561.method_43470((String)"For odd numbered builds add 0.5.").method_27692(class_124.field_1080)));
        this.mirrorNumberFieldList.add(this.textMirrorPosY);
        this.textMirrorPosZ = new NumberField(this.font, renderables, this.left + 60, y + 48, 90, 18);
        this.textMirrorPosZ.setNumber(0.0);
        this.textMirrorPosZ.setTooltip(Arrays.asList(class_2561.method_43470((String)"The position of the mirror."), class_2561.method_43470((String)"For odd numbered builds add 0.5.").method_27692(class_124.field_1080)));
        this.mirrorNumberFieldList.add(this.textMirrorPosZ);
        y = this.top + 50;
        this.buttonMirrorX = new Checkbox(this.left + 200 - 10, y, " X", true);
        this.mirrorButtonList.add(this.buttonMirrorX);
        this.buttonMirrorY = new Checkbox(this.left + 200 - 10 + 32, y, " Y", false);
        this.mirrorButtonList.add(this.buttonMirrorY);
        this.buttonMirrorZ = new Checkbox(this.left + 200 - 10 + 64, y, " Z", false);
        this.mirrorButtonList.add(this.buttonMirrorZ);
        y = this.top + 47;
        this.textMirrorRadius = new NumberField(this.font, renderables, this.left + 200, y, 80, 18);
        this.textMirrorRadius.setNumber(50.0);
        this.textMirrorRadius.setTooltip(Arrays.asList(class_2561.method_43470((String)"How far the mirror reaches in any direction."), class_2561.method_43470((String)"Max: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(ReachHelper.getMaxReachDistance((class_1657)this.mc.field_1724) / 2)).method_27692(class_124.field_1065)), class_2561.method_43470((String)"Upgradeable in survival with reach upgrades.").method_27692(class_124.field_1080)));
        this.mirrorNumberFieldList.add(this.textMirrorRadius);
        y = this.top + 72;
        this.buttonCurrentPosition = new IconButton(this.left + 160, y, 0, 0, BUILDING_ICONS, button -> {
            class_243 pos = new class_243(Math.floor(this.mc.field_1724.method_23317()) + 0.5, Math.floor(this.mc.field_1724.method_23318()) + 0.5, Math.floor(this.mc.field_1724.method_23321()) + 0.5);
            this.textMirrorPosX.setNumber(pos.field_1352);
            this.textMirrorPosY.setNumber(pos.field_1351);
            this.textMirrorPosZ.setNumber(pos.field_1350);
        });
        this.buttonCurrentPosition.setTooltip((class_2561)class_2561.method_43470((String)"Set mirror position to current player position"));
        this.mirrorIconButtonList.add(this.buttonCurrentPosition);
        this.buttonToggleOdd = new IconButton(this.left + 160 + 24, y, 0, 20, BUILDING_ICONS, button -> {
            this.toggleOdd = !this.toggleOdd;
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
            if (this.toggleOdd) {
                this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set mirror position to corner of block"), class_2561.method_43470((String)"for even numbered builds")));
                this.textMirrorPosX.setNumber(this.textMirrorPosX.getNumber() + 0.5);
                this.textMirrorPosY.setNumber(this.textMirrorPosY.getNumber() + 0.5);
                this.textMirrorPosZ.setNumber(this.textMirrorPosZ.getNumber() + 0.5);
            } else {
                this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set mirror position to middle of block"), class_2561.method_43470((String)"for odd numbered builds")));
                this.textMirrorPosX.setNumber(Math.floor(this.textMirrorPosX.getNumber()));
                this.textMirrorPosY.setNumber(Math.floor(this.textMirrorPosY.getNumber()));
                this.textMirrorPosZ.setNumber(Math.floor(this.textMirrorPosZ.getNumber()));
            }
        });
        this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set mirror position to middle of block"), class_2561.method_43470((String)"for odd numbered builds")));
        this.mirrorIconButtonList.add(this.buttonToggleOdd);
        this.buttonDrawLines = new IconButton(this.left + 160 + 48, y, 0, 40, BUILDING_ICONS, button -> {
            this.drawLines = !this.drawLines;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawLines.setTooltip((class_2561)class_2561.method_43470((String)(this.drawLines ? "Hide lines" : "Show lines")));
        });
        this.buttonDrawLines.setTooltip((class_2561)class_2561.method_43470((String)"Show lines"));
        this.mirrorIconButtonList.add(this.buttonDrawLines);
        this.buttonDrawPlanes = new IconButton(this.left + 160 + 72, y, 0, 60, BUILDING_ICONS, button -> {
            this.drawPlanes = !this.drawPlanes;
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawPlanes.setTooltip((class_2561)class_2561.method_43470((String)(this.drawPlanes ? "Hide area" : "Show area")));
        });
        this.buttonDrawPlanes.setTooltip((class_2561)class_2561.method_43470((String)"Show area"));
        this.mirrorIconButtonList.add(this.buttonDrawPlanes);
        ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings((class_1657)this.mc.field_1724);
        if (modifierSettings != null) {
            Mirror.MirrorSettings mirrorSettings = modifierSettings.mirrorSettings();
            this.buttonMirrorEnabled.setIsChecked(mirrorSettings.enabled());
            this.textMirrorPosX.setNumber(mirrorSettings.position().field_1352);
            this.textMirrorPosY.setNumber(mirrorSettings.position().field_1351);
            this.textMirrorPosZ.setNumber(mirrorSettings.position().field_1350);
            this.buttonMirrorX.setIsChecked(mirrorSettings.mirrorX());
            this.buttonMirrorY.setIsChecked(mirrorSettings.mirrorY());
            this.buttonMirrorZ.setIsChecked(mirrorSettings.mirrorZ());
            this.textMirrorRadius.setNumber(mirrorSettings.radius());
            this.drawLines = mirrorSettings.drawLines();
            this.drawPlanes = mirrorSettings.drawPlanes();
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawLines.setTooltip((class_2561)class_2561.method_43470((String)(this.drawLines ? "Hide lines" : "Show lines")));
            this.buttonDrawPlanes.setTooltip((class_2561)class_2561.method_43470((String)(this.drawPlanes ? "Hide area" : "Show area")));
            if (this.textMirrorPosX.getNumber() == Math.floor(this.textMirrorPosX.getNumber())) {
                this.toggleOdd = false;
                this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set mirror position to middle of block"), class_2561.method_43470((String)"for odd numbered builds")));
            } else {
                this.toggleOdd = true;
                this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set mirror position to corner of block"), class_2561.method_43470((String)"for even numbered builds")));
            }
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
        }
        renderables.addAll(this.mirrorButtonList);
        renderables.addAll(this.mirrorIconButtonList);
        this.setCollapsed(!this.buttonMirrorEnabled.isChecked());
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.mirrorNumberFieldList.forEach(NumberField::update);
    }

    @Override
    public void drawEntry(class_4587 poseStack, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int offset = 8;
        this.buttonMirrorEnabled.method_25394(poseStack, mouseX, mouseY, partialTicks);
        if (this.buttonMirrorEnabled.isChecked()) {
            this.buttonMirrorEnabled.field_22761 = y;
            this.font.method_1729(poseStack, "Mirror enabled", (float)(this.left + offset), (float)(y + 2), 0xFFFFFF);
            int positionOffsetX0 = this.left + 8;
            int positionOffsetX1 = this.left + 160;
            int positionOffsetY0 = y + 24;
            int positionOffsetY1 = y + 48;
            int positionOffsetY2 = y + 72;
            int textOffsetX = 40;
            int componentOffsetY = -5;
            this.font.method_1729(poseStack, "Position", (float)positionOffsetX0, (float)positionOffsetY0, 0xFFFFFF);
            this.font.method_1729(poseStack, "X", (float)(positionOffsetX0 + textOffsetX), (float)positionOffsetY0, 0xFFFFFF);
            this.font.method_1729(poseStack, "Y", (float)(positionOffsetX0 + textOffsetX), (float)positionOffsetY1, 0xFFFFFF);
            this.font.method_1729(poseStack, "Z", (float)(positionOffsetX0 + textOffsetX), (float)positionOffsetY2, 0xFFFFFF);
            this.textMirrorPosX.y = positionOffsetY0 + componentOffsetY;
            this.textMirrorPosY.y = positionOffsetY1 + componentOffsetY;
            this.textMirrorPosZ.y = positionOffsetY2 + componentOffsetY;
            this.font.method_1729(poseStack, "Radius", (float)positionOffsetX1, (float)positionOffsetY0, 0xFFFFFF);
            this.textMirrorRadius.y = positionOffsetY0 + componentOffsetY;
            this.font.method_1729(poseStack, "Axis", (float)positionOffsetX1, (float)positionOffsetY1, 0xFFFFFF);
            this.buttonMirrorX.field_22761 = positionOffsetY1 - 2;
            this.buttonMirrorY.field_22761 = positionOffsetY1 - 2;
            this.buttonMirrorZ.field_22761 = positionOffsetY1 - 2;
            this.buttonCurrentPosition.field_22761 = positionOffsetY2 - 6;
            this.buttonToggleOdd.field_22761 = positionOffsetY2 - 6;
            this.buttonDrawLines.field_22761 = positionOffsetY2 - 6;
            this.buttonDrawPlanes.field_22761 = positionOffsetY2 - 6;
            this.mirrorButtonList.forEach(button -> button.method_25394(poseStack, mouseX, mouseY, partialTicks));
            this.mirrorIconButtonList.forEach(button -> button.method_25394(poseStack, mouseX, mouseY, partialTicks));
            this.mirrorNumberFieldList.forEach(numberField -> numberField.drawNumberField(poseStack, mouseX, mouseY, partialTicks));
        } else {
            this.buttonMirrorEnabled.field_22761 = y;
            this.font.method_1729(poseStack, "Mirror disabled", (float)(this.left + offset), (float)(y + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(class_4587 poseStack, class_437 guiScreen, int mouseX, int mouseY) {
        if (this.buttonMirrorEnabled.isChecked()) {
            this.mirrorIconButtonList.forEach(iconButton -> iconButton.drawTooltip(poseStack, this.scrollPane.parent, mouseX, mouseY));
            this.mirrorNumberFieldList.forEach(numberField -> numberField.drawTooltip(poseStack, this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (NumberField numberField : this.mirrorNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideMirrorEnabledLabel;
        this.mirrorNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideMirrorEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideMirrorEnabledLabel) {
            this.buttonMirrorEnabled.method_25354(this.mc.method_1483());
            this.buttonMirrorEnabled.method_25348(mouseX, mouseY);
        }
        return true;
    }

    public Mirror.MirrorSettings getMirrorSettings() {
        boolean mirrorEnabled = this.buttonMirrorEnabled.isChecked();
        class_243 mirrorPos = new class_243(0.0, 64.0, 0.0);
        try {
            mirrorPos = new class_243(this.textMirrorPosX.getNumber(), this.textMirrorPosY.getNumber(), this.textMirrorPosZ.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            Effortless.log((class_1657)this.mc.field_1724, "Mirror position not a valid number.");
        }
        boolean mirrorX = this.buttonMirrorX.isChecked();
        boolean mirrorY = this.buttonMirrorY.isChecked();
        boolean mirrorZ = this.buttonMirrorZ.isChecked();
        int mirrorRadius = 50;
        try {
            mirrorRadius = (int)this.textMirrorRadius.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            Effortless.log((class_1657)this.mc.field_1724, "Mirror radius not a valid number.");
        }
        return new Mirror.MirrorSettings(mirrorEnabled, mirrorPos, mirrorX, mirrorY, mirrorZ, mirrorRadius, this.drawLines, this.drawPlanes);
    }

    @Override
    protected String getName() {
        return "Mirror";
    }

    @Override
    protected int getExpandedHeight() {
        return 96;
    }
}

