/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.screen.buildmodifier;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.buildmodifier.mirror.RadialMirror;
import dev.huskcasaca.effortless.entity.player.ModifierSettings;
import dev.huskcasaca.effortless.screen.widget.Checkbox;
import dev.huskcasaca.effortless.screen.widget.ExpandableScrollEntry;
import dev.huskcasaca.effortless.screen.widget.IconButton;
import dev.huskcasaca.effortless.screen.widget.NumberField;
import dev.huskcasaca.effortless.screen.widget.ScrollPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class RadialMirrorSettingsPane
extends ExpandableScrollEntry {
    protected static final class_2960 BUILDING_ICONS = new class_2960("effortless", "textures/gui/building_icons.png");
    protected List<class_4185> radialMirrorButtonList = new ArrayList<class_4185>();
    protected List<IconButton> radialMirrorIconButtonList = new ArrayList<IconButton>();
    protected List<NumberField> radialMirrorNumberFieldList = new ArrayList<NumberField>();
    private NumberField textRadialMirrorPosX;
    private NumberField textRadialMirrorPosY;
    private NumberField textRadialMirrorPosZ;
    private NumberField textRadialMirrorSlices;
    private NumberField textRadialMirrorRadius;
    private Checkbox buttonRadialMirrorEnabled;
    private Checkbox buttonRadialMirrorAlternate;
    private IconButton buttonCurrentPosition;
    private IconButton buttonToggleOdd;
    private IconButton buttonDrawPlanes;
    private IconButton buttonDrawLines;
    private boolean drawPlanes;
    private boolean drawLines;
    private boolean toggleOdd;

    public RadialMirrorSettingsPane(ScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public void init(List<class_4068> renderables) {
        super.init(renderables);
        int y = this.top - 2;
        this.buttonRadialMirrorEnabled = new Checkbox(this.left - 15 + 8, y, "", false){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                RadialMirrorSettingsPane.this.setCollapsed(!RadialMirrorSettingsPane.this.buttonRadialMirrorEnabled.isChecked());
            }
        };
        renderables.add((class_4068)this.buttonRadialMirrorEnabled);
        y = this.top + 18;
        this.textRadialMirrorPosX = new NumberField(this.font, renderables, this.left + 60, y, 90, 18);
        this.textRadialMirrorPosX.setNumber(0.0);
        this.textRadialMirrorPosX.setTooltip(Arrays.asList(class_2561.method_43470((String)"The position of the radial mirror."), class_2561.method_43470((String)"For odd numbered builds add 0.5.").method_27692(class_124.field_1080)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosX);
        this.textRadialMirrorPosY = new NumberField(this.font, renderables, this.left + 60, y + 24, 90, 18);
        this.textRadialMirrorPosY.setNumber(64.0);
        this.textRadialMirrorPosY.setTooltip(Arrays.asList(class_2561.method_43470((String)"The position of the radial mirror."), class_2561.method_43470((String)"For odd numbered builds add 0.5.").method_27692(class_124.field_1080)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosY);
        this.textRadialMirrorPosZ = new NumberField(this.font, renderables, this.left + 60, y + 48, 90, 18);
        this.textRadialMirrorPosZ.setNumber(0.0);
        this.textRadialMirrorPosZ.setTooltip(Arrays.asList(class_2561.method_43470((String)"The position of the radial mirror."), class_2561.method_43470((String)"For odd numbered builds add 0.5.").method_27692(class_124.field_1080)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosZ);
        y = this.top + 47;
        this.textRadialMirrorSlices = new NumberField(this.font, renderables, this.left + 200, y + 24, 80, 18);
        this.textRadialMirrorSlices.setNumber(4.0);
        this.textRadialMirrorSlices.setTooltip(Arrays.asList(class_2561.method_43470((String)"The number of repeating slices."), class_2561.method_43470((String)"Minimally 2.").method_27692(class_124.field_1080)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorSlices);
        this.textRadialMirrorRadius = new NumberField(this.font, renderables, this.left + 200, y + 0, 80, 18);
        this.textRadialMirrorRadius.setNumber(50.0);
        this.textRadialMirrorRadius.setTooltip(Arrays.asList(class_2561.method_43470((String)"How far the radial mirror reaches from its center position."), class_2561.method_43470((String)"Max: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(ReachHelper.getMaxReachDistance((class_1657)this.mc.field_1724) / 2)).method_27692(class_124.field_1065)), class_2561.method_43470((String)"Upgradeable in survival with reach upgrades.").method_27692(class_124.field_1080)));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorRadius);
        y = this.top + 72;
        this.buttonCurrentPosition = new IconButton(this.left + 160, y, 0, 0, BUILDING_ICONS, button -> {
            class_243 pos = new class_243(Math.floor(this.mc.field_1724.method_23317()) + 0.5, Math.floor(this.mc.field_1724.method_23318()) + 0.5, Math.floor(this.mc.field_1724.method_23321()) + 0.5);
            this.textRadialMirrorPosX.setNumber(pos.field_1352);
            this.textRadialMirrorPosY.setNumber(pos.field_1351);
            this.textRadialMirrorPosZ.setNumber(pos.field_1350);
        });
        this.buttonCurrentPosition.setTooltip((class_2561)class_2561.method_43470((String)"Set radial mirror position to current player position"));
        this.radialMirrorIconButtonList.add(this.buttonCurrentPosition);
        this.buttonToggleOdd = new IconButton(this.left + 160 + 24, y, 0, 20, BUILDING_ICONS, button -> {
            this.toggleOdd = !this.toggleOdd;
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
            if (this.toggleOdd) {
                this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set mirror position to corner of block"), class_2561.method_43470((String)"for even numbered builds")));
                this.textRadialMirrorPosX.setNumber(this.textRadialMirrorPosX.getNumber() + 0.5);
                this.textRadialMirrorPosY.setNumber(this.textRadialMirrorPosY.getNumber() + 0.5);
                this.textRadialMirrorPosZ.setNumber(this.textRadialMirrorPosZ.getNumber() + 0.5);
            } else {
                this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set mirror position to middle of block"), class_2561.method_43470((String)"for odd numbered builds")));
                this.textRadialMirrorPosX.setNumber(Math.floor(this.textRadialMirrorPosX.getNumber()));
                this.textRadialMirrorPosY.setNumber(Math.floor(this.textRadialMirrorPosY.getNumber()));
                this.textRadialMirrorPosZ.setNumber(Math.floor(this.textRadialMirrorPosZ.getNumber()));
            }
        });
        this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set radial mirror position to middle of block"), class_2561.method_43470((String)"for odd numbered builds")));
        this.radialMirrorIconButtonList.add(this.buttonToggleOdd);
        this.buttonDrawLines = new IconButton(this.left + 160 + 48, y, 0, 40, BUILDING_ICONS, button -> {
            this.drawLines = !this.drawLines;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawLines.setTooltip((class_2561)class_2561.method_43470((String)(this.drawLines ? "Hide lines" : "Show lines")));
        });
        this.buttonDrawLines.setTooltip((class_2561)class_2561.method_43470((String)"Show lines"));
        this.radialMirrorIconButtonList.add(this.buttonDrawLines);
        this.buttonDrawPlanes = new IconButton(this.left + 160 + 72, y, 0, 60, BUILDING_ICONS, button -> {
            this.drawPlanes = !this.drawPlanes;
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawPlanes.setTooltip((class_2561)class_2561.method_43470((String)(this.drawPlanes ? "Hide area" : "Show area")));
        });
        this.buttonDrawPlanes.setTooltip((class_2561)class_2561.method_43470((String)"Show area"));
        this.radialMirrorIconButtonList.add(this.buttonDrawPlanes);
        y = this.top + 76;
        this.buttonRadialMirrorAlternate = new Checkbox(this.left + 8, y, " Alternate", false);
        this.radialMirrorButtonList.add(this.buttonRadialMirrorAlternate);
        ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings((class_1657)this.mc.field_1724);
        if (modifierSettings != null) {
            RadialMirror.RadialMirrorSettings radialMirrorSettings = modifierSettings.radialMirrorSettings();
            this.buttonRadialMirrorEnabled.setIsChecked(radialMirrorSettings.enabled());
            this.textRadialMirrorPosX.setNumber(radialMirrorSettings.position().field_1352);
            this.textRadialMirrorPosY.setNumber(radialMirrorSettings.position().field_1351);
            this.textRadialMirrorPosZ.setNumber(radialMirrorSettings.position().field_1350);
            this.textRadialMirrorSlices.setNumber(radialMirrorSettings.slices());
            this.buttonRadialMirrorAlternate.setIsChecked(radialMirrorSettings.alternate());
            this.textRadialMirrorRadius.setNumber(radialMirrorSettings.radius());
            this.drawLines = radialMirrorSettings.drawLines();
            this.drawPlanes = radialMirrorSettings.drawPlanes();
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawLines.setTooltip((class_2561)class_2561.method_43470((String)(this.drawLines ? "Hide lines" : "Show lines")));
            this.buttonDrawPlanes.setTooltip((class_2561)class_2561.method_43470((String)(this.drawPlanes ? "Hide area" : "Show area")));
            if (this.textRadialMirrorPosX.getNumber() == Math.floor(this.textRadialMirrorPosX.getNumber())) {
                this.toggleOdd = false;
                this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set radial mirror position to middle of block"), class_2561.method_43470((String)"for odd numbered builds")));
            } else {
                this.toggleOdd = true;
                this.buttonToggleOdd.setTooltip(Arrays.asList(class_2561.method_43470((String)"Set radial mirror position to corner of block"), class_2561.method_43470((String)"for even numbered builds")));
            }
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
        }
        renderables.addAll(this.radialMirrorButtonList);
        renderables.addAll(this.radialMirrorIconButtonList);
        this.setCollapsed(!this.buttonRadialMirrorEnabled.isChecked());
    }

    @Override
    public void updateScreen() {
        this.radialMirrorNumberFieldList.forEach(NumberField::update);
    }

    @Override
    public void drawEntry(class_4587 poseStack, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int offset = 8;
        this.buttonRadialMirrorEnabled.method_25394(poseStack, mouseX, mouseY, partialTicks);
        if (this.buttonRadialMirrorEnabled.isChecked()) {
            this.buttonRadialMirrorEnabled.field_22761 = y;
            this.font.method_1729(poseStack, "Radial mirror enabled", (float)(this.left + offset), (float)(y + 2), 0xFFFFFF);
            int positionOffsetX0 = this.left + 8;
            int positionOffsetX1 = this.left + 160;
            int positionOffsetY0 = y + 24;
            int positionOffsetY1 = y + 48;
            int positionOffsetY2 = y + 72;
            int positionOffsetY3 = y + 96;
            int textOffsetX = 40;
            int componentOffsetY = -5;
            this.font.method_1729(poseStack, "Position", (float)(this.left + offset), (float)positionOffsetY0, 0xFFFFFF);
            this.font.method_1729(poseStack, "X", (float)(positionOffsetX0 + textOffsetX), (float)positionOffsetY0, 0xFFFFFF);
            this.font.method_1729(poseStack, "Y", (float)(positionOffsetX0 + textOffsetX), (float)positionOffsetY1, 0xFFFFFF);
            this.font.method_1729(poseStack, "Z", (float)(positionOffsetX0 + textOffsetX), (float)positionOffsetY2, 0xFFFFFF);
            this.textRadialMirrorPosX.y = positionOffsetY0 + componentOffsetY;
            this.textRadialMirrorPosY.y = positionOffsetY1 + componentOffsetY;
            this.textRadialMirrorPosZ.y = positionOffsetY2 + componentOffsetY;
            this.font.method_1729(poseStack, "Radius", (float)positionOffsetX1, (float)positionOffsetY0, 0xFFFFFF);
            this.textRadialMirrorRadius.y = positionOffsetY0 + componentOffsetY;
            this.font.method_1729(poseStack, "Slices", (float)positionOffsetX1, (float)positionOffsetY1, 0xFFFFFF);
            this.textRadialMirrorSlices.y = positionOffsetY1 + componentOffsetY;
            this.buttonCurrentPosition.field_22761 = positionOffsetY2 - 6;
            this.buttonToggleOdd.field_22761 = positionOffsetY2 - 6;
            this.buttonDrawLines.field_22761 = positionOffsetY2 - 6;
            this.buttonDrawPlanes.field_22761 = positionOffsetY2 - 6;
            this.buttonRadialMirrorAlternate.field_22761 = positionOffsetY3;
            this.radialMirrorButtonList.forEach(button -> button.method_25394(poseStack, mouseX, mouseY, partialTicks));
            this.radialMirrorIconButtonList.forEach(button -> button.method_25394(poseStack, mouseX, mouseY, partialTicks));
            this.radialMirrorNumberFieldList.forEach(numberField -> numberField.drawNumberField(poseStack, mouseX, mouseY, partialTicks));
        } else {
            this.buttonRadialMirrorEnabled.field_22761 = y;
            this.font.method_1729(poseStack, "Radial mirror disabled", (float)(this.left + offset), (float)(y + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(class_4587 poseStack, class_437 guiScreen, int mouseX, int mouseY) {
        if (this.buttonRadialMirrorEnabled.isChecked()) {
            this.radialMirrorIconButtonList.forEach(iconButton -> iconButton.drawTooltip(poseStack, this.scrollPane.parent, mouseX, mouseY));
            this.radialMirrorNumberFieldList.forEach(numberField -> numberField.drawTooltip(poseStack, this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (NumberField numberField : this.radialMirrorNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideRadialMirrorEnabledLabel;
        this.radialMirrorNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideRadialMirrorEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideRadialMirrorEnabledLabel) {
            this.buttonRadialMirrorEnabled.method_25354(this.mc.method_1483());
            this.buttonRadialMirrorEnabled.method_25348(mouseX, mouseY);
        }
        return true;
    }

    public RadialMirror.RadialMirrorSettings getRadialMirrorSettings() {
        boolean radialMirrorEnabled = this.buttonRadialMirrorEnabled.isChecked();
        class_243 radialMirrorPos = new class_243(0.0, 64.0, 0.0);
        try {
            radialMirrorPos = new class_243(this.textRadialMirrorPosX.getNumber(), this.textRadialMirrorPosY.getNumber(), this.textRadialMirrorPosZ.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            Effortless.log((class_1657)this.mc.field_1724, "Radial mirror position not a valid number.");
        }
        int radialMirrorSlices = 4;
        try {
            radialMirrorSlices = (int)this.textRadialMirrorSlices.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            Effortless.log((class_1657)this.mc.field_1724, "Radial mirror slices not a valid number.");
        }
        boolean radialMirrorAlternate = this.buttonRadialMirrorAlternate.isChecked();
        int radialMirrorRadius = 50;
        try {
            radialMirrorRadius = (int)this.textRadialMirrorRadius.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            Effortless.log((class_1657)this.mc.field_1724, "Mirror radius not a valid number.");
        }
        return new RadialMirror.RadialMirrorSettings(radialMirrorEnabled, radialMirrorPos, radialMirrorSlices, radialMirrorAlternate, radialMirrorRadius, this.drawLines, this.drawPlanes);
    }

    @Override
    protected String getName() {
        return "Radial mirror";
    }

    @Override
    protected int getExpandedHeight() {
        return 128;
    }
}

