/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.screen.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.huskcasaca.effortless.screen.widget.Slot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
@Environment(value=EnvType.CLIENT)
public class ScrollPane
extends Slot {
    private final List<IScrollEntry> listEntries;
    public class_437 parent;
    public class_327 font;
    private float scrollMultiplier = 1.0f;
    private int mouseX;
    private int mouseY;

    public ScrollPane(class_437 parent, class_327 font, int top, int bottom) {
        super(class_310.method_1551(), parent.field_22789, parent.field_22790, top, bottom, 100);
        this.parent = parent;
        this.font = font;
        this.renderSelection = false;
        this.listEntries = new ArrayList<IScrollEntry>();
    }

    public IScrollEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    public void addListEntry(IScrollEntry listEntry) {
        this.listEntries.add(listEntry);
    }

    @Override
    protected int getItemCount() {
        return this.listEntries.size();
    }

    @Override
    protected boolean isSelectedItem(int slotIndex) {
        return false;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width - 15;
    }

    @Override
    public int getRowWidth() {
        return 280;
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.renderBackground();
            int scrollbarLeft = this.getScrollbarPosition();
            int scrollbarRight = scrollbarLeft + 6;
            this.capYPosition();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_1349();
            int insideLeft = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
            int insideTop = this.y0 + 4 - (int)this.yo;
            if (this.renderHeader) {
                this.renderHeader(insideLeft, insideTop, tesselator);
            }
            this.renderList(poseStack, insideLeft, insideTop, mouseX, mouseY, partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.disableTexture();
            int maxScroll = this.getMaxScroll();
            if (maxScroll > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                int l1 = (int)this.yo * (this.y1 - this.y0 - (k1 = class_3532.method_15340((int)k1, (int)32, (int)(this.y1 - this.y0 - 8)))) / maxScroll + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                bufferbuilder.method_22912((double)scrollbarLeft, (double)this.y1, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferbuilder.method_22912((double)scrollbarRight, (double)this.y1, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferbuilder.method_22912((double)scrollbarRight, (double)this.y0, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferbuilder.method_22912((double)scrollbarLeft, (double)this.y0, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
                tesselator.method_1350();
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                bufferbuilder.method_22912((double)scrollbarLeft, (double)(l1 + k1), 0.0).method_22913(0.0f, 1.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferbuilder.method_22912((double)scrollbarRight, (double)(l1 + k1), 0.0).method_22913(1.0f, 1.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferbuilder.method_22912((double)scrollbarRight, (double)l1, 0.0).method_22913(1.0f, 0.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferbuilder.method_22912((double)scrollbarLeft, (double)l1, 0.0).method_22913(0.0f, 0.0f).method_1336(128, 128, 128, 255).method_1344();
                tesselator.method_1350();
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
                bufferbuilder.method_22912((double)scrollbarLeft, (double)(l1 + k1 - 1), 0.0).method_22913(0.0f, 1.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferbuilder.method_22912((double)(scrollbarRight - 1), (double)(l1 + k1 - 1), 0.0).method_22913(1.0f, 1.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferbuilder.method_22912((double)(scrollbarRight - 1), (double)l1, 0.0).method_22913(1.0f, 0.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferbuilder.method_22912((double)scrollbarLeft, (double)l1, 0.0).method_22913(0.0f, 0.0f).method_1336(192, 192, 192, 255).method_1344();
                tesselator.method_1350();
            }
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    @Override
    protected int getMaxPosition() {
        int height = this.headerHeight;
        for (IScrollEntry entry : this.listEntries) {
            height += entry.getHeight();
        }
        return height;
    }

    @Override
    protected void renderBackground() {
    }

    @Override
    protected void renderItem(class_4587 poseStack, int slotIndex, int posX, int posY, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        this.getListEntry(slotIndex).drawEntry(poseStack, slotIndex, posX, posY, this.getRowWidth(), heightIn, mouseXIn, mouseYIn, this.getSlotIndexFromScreenCoords(mouseXIn, mouseYIn) == slotIndex, partialTicks);
    }

    public int getMaxPosition(int count) {
        int height = this.headerHeight;
        for (int i = 0; i < count; ++i) {
            IScrollEntry entry = this.listEntries.get(i);
            height += entry.getHeight();
        }
        return height;
    }

    public int getSlotIndexFromScreenCoords(double posX, double posY) {
        int left = this.x0 + (this.width - this.getRowWidth()) / 2;
        int right = this.x0 + (this.width + this.getRowWidth()) / 2;
        double relativeMouseY = this.getRelativeMouseY(this.mouseY, 0);
        for (int i = 0; i < this.listEntries.size(); ++i) {
            IScrollEntry entry = this.listEntries.get(i);
            if (relativeMouseY <= (double)entry.getHeight()) {
                return posX < (double)this.getScrollbarPosition() && posX >= (double)left && posX <= (double)right && i >= 0 && relativeMouseY >= 0.0 && i < this.getItemCount() ? i : -1;
            }
            relativeMouseY -= (double)entry.getHeight();
        }
        return -1;
    }

    @Override
    public List<? extends class_364> method_25396() {
        return null;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        int selectedSlot = this.getSlotIndexFromScreenCoords(mouseX, mouseY);
        double relativeX = this.getRelativeMouseX(mouseX);
        for (int i = 0; i < this.listEntries.size(); ++i) {
            double relativeY = this.getRelativeMouseY(mouseY, i);
            this.getListEntry(i).mousePressed(selectedSlot, (int)mouseX, (int)mouseY, button, (int)relativeX, (int)relativeY);
        }
        return false;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            double relativeX = this.getRelativeMouseX(mouseX);
            double relativeY = this.getRelativeMouseY(mouseY, i);
            this.getListEntry(i).mouseReleased(i, (int)mouseX, (int)mouseY, button, (int)relativeX, (int)relativeY);
        }
        this.visible = true;
        return false;
    }

    public void handleMouseInput() {
        if (this.isMouseInList(this.mouseX, this.mouseY)) {
            if (this.minecraft.field_1729.method_1608() && this.mouseY >= this.y0 && this.mouseY <= this.y1) {
                int i = this.x0 + (this.width - this.getRowWidth()) / 2;
                int j = this.x0 + (this.width + this.getRowWidth()) / 2;
                int slotIndex = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                double relativeMouseY = this.getRelativeMouseY(this.mouseY, slotIndex);
                if (slotIndex > -1) {
                    this.method_25402(this.mouseX, this.mouseY, 0);
                } else if (this.mouseX >= i && this.mouseX <= j && relativeMouseY < 0.0) {
                    this.clickedHeader(this.mouseX - i, this.mouseY - this.y0 + (int)this.yo - 4);
                }
            }
            if (this.minecraft.field_1729.method_1608() && this.isVisible()) {
                if (this.yDrag == -1) {
                    boolean flag1 = true;
                    if (this.mouseY >= this.y0 && this.mouseY <= this.y1) {
                        int i2 = this.x0 + (this.width - this.getRowWidth()) / 2;
                        int j2 = this.x0 + (this.width + this.getRowWidth()) / 2;
                        int slotIndex = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                        double relativeMouseY = this.getRelativeMouseY(this.mouseY, slotIndex);
                        if (slotIndex > -1) {
                            this.method_25402(slotIndex, this.mouseX, this.mouseY);
                        } else if (this.mouseX >= i2 && this.mouseX <= j2 && relativeMouseY < 0.0) {
                            this.clickedHeader(this.mouseX - i2, this.mouseY - this.y0 + (int)this.yo - 4);
                            flag1 = false;
                        }
                        int i3 = this.getScrollbarPosition();
                        int j1 = i3 + 6;
                        if (this.mouseX >= i3 && this.mouseX <= j1) {
                            this.scrollMultiplier = -1.0f;
                            int maxScroll = this.getMaxScroll();
                            if (maxScroll < 1) {
                                maxScroll = 1;
                            }
                            int l1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                            l1 = class_3532.method_15340((int)l1, (int)32, (int)(this.y1 - this.y0 - 8));
                            this.scrollMultiplier /= (float)(this.y1 - this.y0 - l1) / (float)maxScroll;
                        } else {
                            this.scrollMultiplier = 1.0f;
                        }
                        this.yDrag = flag1 ? this.mouseY : -2;
                    } else {
                        this.yDrag = -2;
                    }
                } else if (this.yDrag >= 0) {
                    this.yo -= (double)((float)(this.mouseY - this.yDrag) * this.scrollMultiplier);
                    this.yDrag = this.mouseY;
                }
            } else {
                this.yDrag = -1;
            }
        }
    }

    @Override
    protected void renderList(class_4587 poseStack, int insideLeft, int insideTop, int mouseXIn, int mouseYIn, float partialTicks) {
        int insideHeight;
        int itemCount = this.getItemCount();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        int y = this.headerHeight + insideTop;
        int contentHeight = this.getMaxPosition();
        if (contentHeight < (insideHeight = this.y1 - this.y0 - 4)) {
            y += (insideHeight - contentHeight) / 2;
        }
        for (int i = 0; i < itemCount; ++i) {
            int entryHeight = this.listEntries.get(i).getHeight();
            int entryHeight2 = entryHeight - 4;
            if (y > this.y1 || y + entryHeight2 < this.y0) {
                this.updateItemPosition(i, insideLeft, y, partialTicks);
            }
            if (this.renderSelection && this.isSelectedItem(i)) {
                int i1 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int j1 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                RenderSystem.disableTexture();
                float f = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)1.0f);
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferbuilder.method_22912((double)i1, (double)(y + entryHeight2 + 2), 0.0).method_1344();
                bufferbuilder.method_22912((double)j1, (double)(y + entryHeight2 + 2), 0.0).method_1344();
                bufferbuilder.method_22912((double)j1, (double)(y - 2), 0.0).method_1344();
                bufferbuilder.method_22912((double)i1, (double)(y - 2), 0.0).method_1344();
                tesselator.method_1350();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferbuilder.method_22912((double)(i1 + 1), (double)(y + entryHeight2 + 1), 0.0).method_1344();
                bufferbuilder.method_22912((double)(j1 - 1), (double)(y + entryHeight2 + 1), 0.0).method_1344();
                bufferbuilder.method_22912((double)(j1 - 1), (double)(y - 1), 0.0).method_1344();
                bufferbuilder.method_22912((double)(i1 + 1), (double)(y - 1), 0.0).method_1344();
                tesselator.method_1350();
                RenderSystem.enableTexture();
            }
            this.renderItem(poseStack, i, insideLeft, y, entryHeight2, mouseXIn, mouseYIn, partialTicks);
            y += entryHeight;
        }
    }

    private double getRelativeMouseX(double mouseX) {
        int j = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
        return mouseX - (double)j;
    }

    private double getRelativeMouseY(double mouseY, int contentIndex) {
        int insideHeight;
        int k = this.y0 + 4 - this.getScroll() + this.getMaxPosition(contentIndex) + this.headerHeight;
        double relativeMouseY = mouseY - (double)k;
        int contentHeight = this.getMaxPosition();
        if (contentHeight < (insideHeight = this.y1 - this.y0 - 4)) {
            relativeMouseY -= (double)((float)(insideHeight - contentHeight) / 2.0f);
        }
        return relativeMouseY;
    }

    public void init(List<class_4068> renderables) {
        for (IScrollEntry entry : this.listEntries) {
            entry.init(renderables);
        }
    }

    public void updateScreen() {
        for (IScrollEntry entry : this.listEntries) {
            entry.updateScreen();
        }
    }

    public void drawTooltip(class_4587 poseStack, class_437 guiScreen, int mouseX, int mouseY) {
        for (IScrollEntry entry : this.listEntries) {
            entry.drawTooltip(poseStack, guiScreen, mouseX, mouseY);
        }
    }

    @Override
    public boolean method_25400(char eventChar, int eventKey) {
        for (IScrollEntry entry : this.listEntries) {
            entry.charTyped(eventChar, eventKey);
        }
        return false;
    }

    public void onGuiClosed() {
        for (IScrollEntry entry : this.listEntries) {
            entry.onGuiClosed();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static interface IScrollEntry {
        public void init(List<class_4068> var1);

        public void updateScreen();

        public void drawTooltip(class_4587 var1, class_437 var2, int var3, int var4);

        public boolean charTyped(char var1, int var2);

        public void onGuiClosed();

        public int getHeight();

        public void updatePosition(int var1, int var2, int var3, float var4);

        public void drawEntry(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean mousePressed(int var1, int var2, int var3, int var4, int var5, int var6);

        public void mouseReleased(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

