/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmode;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.BuildActionHandler;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmode.BuildMode;
import dev.huskcasaca.effortless.entity.player.EffortlessDataProvider;
import dev.huskcasaca.effortless.entity.player.ModeSettings;
import dev.huskcasaca.effortless.network.Packets;
import dev.huskcasaca.effortless.network.protocol.player.ClientboundPlayerBuildModePacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerSetBuildModePacket;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class BuildModeHelper {
    public static ModeSettings getModeSettings(class_1657 player) {
        return ((EffortlessDataProvider)player).getModeSettings();
    }

    public static String getTranslatedModeOptionName(class_1657 player) {
        BuildMode mode = BuildModeHelper.getModeSettings(player).buildMode();
        if (mode == BuildMode.DISABLE) {
            return class_1074.method_4662((String)mode.getNameKey(), (Object[])new Object[0]);
        }
        StringBuilder modeName = new StringBuilder();
        for (BuildMode.Option option : mode.getOptions()) {
            modeName.append(class_1074.method_4662((String)BuildActionHandler.getOptionSetting(option).getNameKey(), (Object[])new Object[0]));
            modeName.append(" ");
        }
        return modeName + class_1074.method_4662((String)mode.getNameKey(), (Object[])new Object[0]);
    }

    public static void setModeSettings(class_1657 player, ModeSettings modeSettings) {
        if (player == null) {
            Effortless.log("Cannot set buildmode settings, player is null");
            return;
        }
        ((EffortlessDataProvider)player).setModeSettings(modeSettings);
    }

    public static BuildMode getBuildMode(class_1657 player) {
        return BuildModeHelper.getModeSettings(player).buildMode();
    }

    public static void setBuildMode(class_1657 player, BuildMode mode) {
        ModeSettings modeSettings = BuildModeHelper.getModeSettings(player);
        modeSettings = new ModeSettings(mode, modeSettings.enableMagnet());
        BuildModeHelper.setModeSettings(player, modeSettings);
    }

    public static void sync(class_1657 player) {
        if (player instanceof class_3222) {
            Packets.sendToClient(new ClientboundPlayerBuildModePacket(BuildModeHelper.getModeSettings(player)), (class_3222)player);
        } else {
            Packets.sendToServer(new ServerboundPlayerSetBuildModePacket(BuildModeHelper.getModeSettings(player)));
        }
    }

    public static boolean isEnableMagnet(class_1657 player) {
        return BuildModeHelper.getModeSettings(player).enableMagnet();
    }

    public static void setEnableMagnet(class_1657 player, boolean enableMagnet) {
        ModeSettings modeSettings = BuildModeHelper.getModeSettings(player);
        modeSettings = new ModeSettings(modeSettings.buildMode(), enableMagnet);
        BuildModeHelper.setModeSettings(player, modeSettings);
    }

    public static String getSanitizeMessage(ModeSettings modeSettings, class_1657 player) {
        int maxReach = ReachHelper.getMaxReachDistance(player);
        String error = "";
        return error;
    }

    public static ModeSettings sanitize(ModeSettings modeSettings, class_1657 player) {
        return modeSettings;
    }
}

