/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmode.threeclick;

import dev.huskcasaca.effortless.building.BuildAction;
import dev.huskcasaca.effortless.building.BuildActionHandler;
import dev.huskcasaca.effortless.buildmode.ThreeClickBuildable;
import dev.huskcasaca.effortless.buildmode.twoclick.Floor;
import dev.huskcasaca.effortless.buildmode.twoclick.Line;
import dev.huskcasaca.effortless.buildmode.twoclick.Wall;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2338;

public class Cube
extends ThreeClickBuildable {
    public static List<class_2338> getFloorBlocksUsingCubeFill(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        if (BuildActionHandler.getCubeFilling() == BuildAction.CUBE_SKELETON) {
            Floor.addHollowFloorBlocks(list, x1, x2, y1, z1, z2);
        } else {
            Floor.addFloorBlocks(list, x1, x2, y1, z1, z2);
        }
        return list;
    }

    public static List<class_2338> getCubeBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        switch (BuildActionHandler.getCubeFilling()) {
            case CUBE_FULL: {
                Cube.addCubeBlocks(list, x1, x2, y1, y2, z1, z2);
                break;
            }
            case CUBE_HOLLOW: {
                Cube.addHollowCubeBlocks(list, x1, x2, y1, y2, z1, z2);
                break;
            }
            case CUBE_SKELETON: {
                Cube.addSkeletonCubeBlocks(list, x1, x2, y1, y2, z1, z2);
            }
        }
        return list;
    }

    public static void addCubeBlocks(List<class_2338> list, int x1, int x2, int y1, int y2, int z1, int z2) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                int m = y1;
                while (y1 < y2 ? m <= y2 : m >= y2) {
                    list.add(new class_2338(l, m, n));
                    m += y1 < y2 ? 1 : -1;
                }
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    public static void addHollowCubeBlocks(List<class_2338> list, int x1, int x2, int y1, int y2, int z1, int z2) {
        Wall.addXWallBlocks(list, x1, y1, y2, z1, z2);
        Wall.addXWallBlocks(list, x2, y1, y2, z1, z2);
        Wall.addZWallBlocks(list, x1, x2, y1, y2, z1);
        Wall.addZWallBlocks(list, x1, x2, y1, y2, z2);
        Floor.addFloorBlocks(list, x1, x2, y1, z1, z2);
        Floor.addFloorBlocks(list, x1, x2, y2, z1, z2);
    }

    public static void addSkeletonCubeBlocks(List<class_2338> list, int x1, int x2, int y1, int y2, int z1, int z2) {
        Line.addXLineBlocks(list, x1, x2, y1, z1);
        Line.addXLineBlocks(list, x1, x2, y1, z2);
        Line.addXLineBlocks(list, x1, x2, y2, z1);
        Line.addXLineBlocks(list, x1, x2, y2, z2);
        Line.addYLineBlocks(list, y1, y2, x1, z1);
        Line.addYLineBlocks(list, y1, y2, x1, z2);
        Line.addYLineBlocks(list, y1, y2, x2, z1);
        Line.addYLineBlocks(list, y1, y2, x2, z2);
        Line.addZLineBlocks(list, z1, z2, x1, y1);
        Line.addZLineBlocks(list, z1, z2, x1, y2);
        Line.addZLineBlocks(list, z1, z2, x2, y1);
        Line.addZLineBlocks(list, z1, z2, x2, y2);
    }

    @Override
    protected class_2338 findSecondPos(class_1657 player, class_2338 firstPos, boolean skipRaytrace) {
        return Floor.findFloor(player, firstPos, skipRaytrace);
    }

    @Override
    protected class_2338 findThirdPos(class_1657 player, class_2338 firstPos, class_2338 secondPos, boolean skipRaytrace) {
        return Cube.findHeight(player, secondPos, skipRaytrace);
    }

    @Override
    protected List<class_2338> getIntermediateBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Cube.getFloorBlocksUsingCubeFill(player, x1, y1, z1, x2, y2, z2);
    }

    @Override
    public List<class_2338> getFinalBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int z3) {
        return Cube.getCubeBlocks(player, x1, y1, z1, x3, y3, z3);
    }
}

