/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmodifier;

import dev.huskcasaca.effortless.buildmodifier.BlockSet;
import dev.huskcasaca.effortless.buildmodifier.UndoRedo;
import dev.huskcasaca.effortless.buildmodifier.array.Array;
import dev.huskcasaca.effortless.buildmodifier.mirror.Mirror;
import dev.huskcasaca.effortless.buildmodifier.mirror.RadialMirror;
import dev.huskcasaca.effortless.entity.player.EffortlessDataProvider;
import dev.huskcasaca.effortless.entity.player.ModifierSettings;
import dev.huskcasaca.effortless.network.Packets;
import dev.huskcasaca.effortless.network.protocol.player.ClientboundPlayerBuildModifierPacket;
import dev.huskcasaca.effortless.render.BlockPreviewRenderer;
import dev.huskcasaca.effortless.utils.CompatHelper;
import dev.huskcasaca.effortless.utils.InventoryHelper;
import dev.huskcasaca.effortless.utils.SurvivalHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class BuildModifierHandler {
    public static void onBlockPlaced(class_1657 player, List<class_2338> startCoordinates, class_2350 hitSide, class_243 hitVec, boolean placeStartPos) {
        class_1937 level = player.field_6002;
        hitVec = new class_243(Math.abs(hitVec.field_1352 - (double)((int)hitVec.field_1352)), Math.abs(hitVec.field_1351 - (double)((int)hitVec.field_1351)), Math.abs(hitVec.field_1350 - (double)((int)hitVec.field_1350)));
        List<class_2338> coordinates = BuildModifierHandler.findCoordinates(player, startCoordinates);
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        Map<class_2338, class_2680> blockStates = BuildModifierHandler.findBlockStates(player, startCoordinates, hitVec, hitSide, itemStacks);
        if (blockStates.size() == 0 || coordinates.size() != blockStates.size()) {
            return;
        }
        ArrayList<class_2680> previousBlockStates = new ArrayList<class_2680>(coordinates.size());
        ArrayList<class_2680> newBlockStates = new ArrayList<class_2680>(coordinates.size());
        for (class_2338 coordinate : coordinates) {
            previousBlockStates.add(level.method_8320(coordinate));
        }
        if (level.field_9236) {
            int i;
            BlockPreviewRenderer.getInstance().onBlocksPlaced();
            HashMap<class_2248, Integer> blockLeft = new HashMap<class_2248, Integer>();
            int n = i = placeStartPos ? 0 : 1;
            while (i < coordinates.size()) {
                class_2338 blockPos = coordinates.get(i);
                class_2680 blockState = blockStates.get(blockPos);
                class_1799 itemStack = itemStacks.get(i);
                if (!blockLeft.containsKey(blockState.method_26204())) {
                    blockLeft.put(blockState.method_26204(), InventoryHelper.findTotalBlocksInInventory(player, blockState.method_26204()));
                }
                Integer count = blockLeft.getOrDefault(blockState.method_26204(), 0);
                if ((player.method_7337() || count > 0) && level.method_8477(blockPos)) {
                    SurvivalHelper.placeBlock(level, player, blockPos, blockState, itemStack.method_7972(), hitSide, hitVec, false, false, false);
                    if (!player.method_7337()) {
                        blockLeft.put(blockState.method_26204(), count - 1);
                    }
                }
                ++i;
            }
            for (class_2338 coordinate : coordinates) {
                newBlockStates.add(level.method_8320(coordinate));
            }
        } else {
            int i;
            int n = i = placeStartPos ? 0 : 1;
            while (i < coordinates.size()) {
                class_2338 blockPos = coordinates.get(i);
                class_2680 blockState = blockStates.get(blockPos);
                class_1799 itemStack = itemStacks.get(i);
                if (!(!level.method_8477(blockPos) || itemStack.method_7960() && (itemStack = InventoryHelper.findItemStackInInventory(player, blockState.method_26204())).method_7960())) {
                    SurvivalHelper.placeBlock(level, player, blockPos, blockState, itemStack, hitSide, hitVec, false, false, false);
                }
                ++i;
            }
            for (class_2338 coordinate : coordinates) {
                newBlockStates.add(level.method_8320(coordinate));
            }
        }
        if (!placeStartPos) {
            previousBlockStates.set(0, class_2246.field_10124.method_9564());
        }
        if (Collections.frequency(newBlockStates, class_2246.field_10124.method_9564()) != newBlockStates.size()) {
            class_2338 firstPos = startCoordinates.get(0);
            class_2338 secondPos = startCoordinates.get(startCoordinates.size() - 1);
            UndoRedo.addUndo(player, new BlockSet(coordinates, previousBlockStates, newBlockStates, hitVec, firstPos, secondPos));
        }
    }

    public static void onBlockBroken(class_1657 player, List<class_2338> startCoordinates, boolean breakStartPos) {
        int i;
        class_1937 level = player.field_6002;
        List<class_2338> coordinates = BuildModifierHandler.findCoordinates(player, startCoordinates);
        if (coordinates.isEmpty()) {
            return;
        }
        ArrayList<class_2680> previousBlockStates = new ArrayList<class_2680>(coordinates.size());
        ArrayList<class_2680> newBlockStates = new ArrayList<class_2680>(coordinates.size());
        for (class_2338 coordinate : coordinates) {
            previousBlockStates.add(level.method_8320(coordinate));
        }
        if (level.field_9236) {
            BlockPreviewRenderer.getInstance().onBlocksBroken();
        }
        boolean onlyInstaBreaking = !player.method_7337() && level.method_8320(startCoordinates.get(0)).method_26214((class_1922)level, startCoordinates.get(0)) == 0.0f;
        int n = i = breakStartPos ? 0 : 1;
        while (i < coordinates.size()) {
            class_2338 coordinate = coordinates.get(i);
            if (!(!level.method_8477(coordinate) || level.method_22347(coordinate) || onlyInstaBreaking && level.method_8320(coordinate).method_26214((class_1922)level, coordinate) != 0.0f)) {
                SurvivalHelper.breakBlock(level, player, coordinate, false);
            }
            ++i;
        }
        for (class_2338 coordinate : coordinates) {
            newBlockStates.add(level.method_8320(coordinate));
        }
        if (!breakStartPos) {
            newBlockStates.set(0, class_2246.field_10124.method_9564());
        }
        class_2338 firstPos = startCoordinates.get(0);
        class_2338 secondPos = startCoordinates.get(startCoordinates.size() - 1);
        class_243 hitVec = new class_243(0.5, 0.5, 0.5);
        UndoRedo.addUndo(player, new BlockSet(coordinates, previousBlockStates, newBlockStates, hitVec, firstPos, secondPos));
    }

    public static List<class_2338> findCoordinates(class_1657 player, List<class_2338> posList) {
        LinkedHashSet<class_2338> coordinates = new LinkedHashSet<class_2338>(posList);
        for (class_2338 blockPos : posList) {
            Set<class_2338> arrayCoordinates = Array.findCoordinates(player, blockPos);
            coordinates.addAll(arrayCoordinates);
            coordinates.addAll(Mirror.findCoordinates(player, blockPos));
            coordinates.addAll(RadialMirror.findCoordinates(player, blockPos));
            for (class_2338 coordinate : arrayCoordinates) {
                coordinates.addAll(Mirror.findCoordinates(player, coordinate));
                coordinates.addAll(RadialMirror.findCoordinates(player, coordinate));
            }
        }
        return coordinates.stream().toList();
    }

    public static List<class_2338> findCoordinates(class_1657 player, class_2338 blockPos) {
        return BuildModifierHandler.findCoordinates(player, new ArrayList<class_2338>(Collections.singletonList(blockPos)));
    }

    public static Map<class_2338, class_2680> findBlockStates(class_1657 player, List<class_2338> posList, class_243 hitVec, class_2350 facing, List<class_1799> itemStacks) {
        class_2680 blockState;
        LinkedHashMap<class_2338, class_2680> blockStates = new LinkedHashMap<class_2338, class_2680>();
        itemStacks.clear();
        class_1799 itemStack = player.method_5998(class_1268.field_5808);
        if (itemStack.method_7960() || !CompatHelper.isItemBlockProxy(itemStack)) {
            itemStack = player.method_5998(class_1268.field_5810);
        }
        if (itemStack.method_7960() || !CompatHelper.isItemBlockProxy(itemStack)) {
            return Collections.emptyMap();
        }
        class_1799 itemBlock = class_1799.field_8037;
        itemBlock = itemStack.method_7909() instanceof class_1747 ? itemStack : CompatHelper.getItemBlockFromStack(itemStack);
        for (class_2338 blockPos : posList) {
            if (!(itemStack.method_7909() instanceof class_1747)) {
                itemBlock = CompatHelper.getItemBlockFromStack(itemStack);
            }
            if ((blockState = BuildModifierHandler.getBlockStateFromItem(itemBlock, player, blockPos, facing, hitVec, class_1268.field_5808)) == null) continue;
            blockStates.put(blockPos, blockState);
            itemStacks.add(itemBlock);
        }
        for (class_2338 blockPos : posList) {
            blockState = BuildModifierHandler.getBlockStateFromItem(itemBlock, player, blockPos, facing, hitVec, class_1268.field_5808);
            if (blockState == null) continue;
            Map<class_2338, class_2680> arrayBlockStates = Array.findBlockStates(player, blockPos, blockState, itemStack, itemStacks);
            blockStates.putAll(arrayBlockStates);
            blockStates.putAll(Mirror.findBlockStates(player, blockPos, blockState, itemStack, itemStacks));
            blockStates.putAll(RadialMirror.findBlockStates(player, blockPos, blockState, itemStack, itemStacks));
            for (class_2338 coordinate : Array.findCoordinates(player, blockPos)) {
                class_2680 blockState1 = arrayBlockStates.get(coordinate);
                if (blockState1 == null) continue;
                blockStates.putAll(Mirror.findBlockStates(player, coordinate, blockState1, itemStack, itemStacks));
                blockStates.putAll(RadialMirror.findBlockStates(player, coordinate, blockState1, itemStack, itemStacks));
            }
        }
        return blockStates;
    }

    public static boolean isEnabled(ModifierSettings modifierSettings, class_2338 startPos) {
        return Array.isEnabled(modifierSettings.arraySettings()) || Mirror.isEnabled(modifierSettings.mirrorSettings(), startPos) || RadialMirror.isEnabled(modifierSettings.radialMirrorSettings(), startPos) || modifierSettings.enableQuickReplace();
    }

    public static class_2680 getBlockStateFromItem(class_1799 itemStack, class_1657 player, class_2338 blockPos, class_2350 facing, class_243 hitVec, class_1268 hand) {
        class_3965 hitresult = new class_3965(hitVec, facing, blockPos, false);
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1747) {
            return ((class_1747)class_1792.method_7867((class_2248)((class_1747)item).method_7711())).method_7707(new class_1750(player, hand, itemStack, hitresult));
        }
        return class_2248.method_9503((class_1792)item).method_9605(new class_1750(new class_1838(player, hand, new class_3965(hitVec, facing, blockPos, false))));
    }

    public static boolean compareCoordinates(List<class_2338> coordinates1, List<class_2338> coordinates2) {
        if (coordinates1 == null && coordinates2 == null) {
            return true;
        }
        if (coordinates1 == null || coordinates2 == null) {
            return false;
        }
        if (coordinates1.size() == coordinates2.size()) {
            if (coordinates1.size() == 1) {
                return coordinates1.get(0).equals((Object)coordinates2.get(0));
            }
            return true;
        }
        return false;
    }

    public static void handleNewPlayer(class_3222 player) {
        Packets.sendToClient(new ClientboundPlayerBuildModifierPacket(((EffortlessDataProvider)player).getModifierSettings()), player);
    }
}

