/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmodifier.mirror;

import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.buildmodifier.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2315;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;

public class Mirror
implements Modifier {
    public static Set<class_2338> findCoordinates(class_1657 player, class_2338 startPos) {
        LinkedHashSet<class_2338> coordinates = new LinkedHashSet<class_2338>();
        MirrorSettings mirrorSettings = BuildModifierHelper.getModifierSettings(player).mirrorSettings();
        if (!Mirror.isEnabled(mirrorSettings, startPos)) {
            return Collections.emptySet();
        }
        if (mirrorSettings.mirrorX) {
            Mirror.coordinateMirrorX(mirrorSettings, startPos, coordinates);
        }
        if (mirrorSettings.mirrorY) {
            Mirror.coordinateMirrorY(mirrorSettings, startPos, coordinates);
        }
        if (mirrorSettings.mirrorZ) {
            Mirror.coordinateMirrorZ(mirrorSettings, startPos, coordinates);
        }
        return coordinates;
    }

    private static void coordinateMirrorX(MirrorSettings mirrorSettings, class_2338 oldBlockPos, HashSet<class_2338> coordinates) {
        double x = mirrorSettings.position.field_1352 + (mirrorSettings.position.field_1352 - (double)oldBlockPos.method_10263() - 0.5);
        class_2338 newBlockPos = new class_2338(x, (double)oldBlockPos.method_10264(), (double)oldBlockPos.method_10260());
        coordinates.add(newBlockPos);
        if (mirrorSettings.mirrorY) {
            Mirror.coordinateMirrorY(mirrorSettings, newBlockPos, coordinates);
        }
        if (mirrorSettings.mirrorZ) {
            Mirror.coordinateMirrorZ(mirrorSettings, newBlockPos, coordinates);
        }
    }

    private static void coordinateMirrorY(MirrorSettings mirrorSettings, class_2338 oldBlockPos, HashSet<class_2338> coordinates) {
        double y = mirrorSettings.position.field_1351 + (mirrorSettings.position.field_1351 - (double)oldBlockPos.method_10264() - 0.5);
        class_2338 newBlockPos = new class_2338((double)oldBlockPos.method_10263(), y, (double)oldBlockPos.method_10260());
        coordinates.add(newBlockPos);
        if (mirrorSettings.mirrorZ) {
            Mirror.coordinateMirrorZ(mirrorSettings, newBlockPos, coordinates);
        }
    }

    private static void coordinateMirrorZ(MirrorSettings mirrorSettings, class_2338 oldBlockPos, HashSet<class_2338> coordinates) {
        double z = mirrorSettings.position.field_1350 + (mirrorSettings.position.field_1350 - (double)oldBlockPos.method_10260() - 0.5);
        class_2338 newBlockPos = new class_2338((double)oldBlockPos.method_10263(), (double)oldBlockPos.method_10264(), z);
        coordinates.add(newBlockPos);
    }

    public static Map<class_2338, class_2680> findBlockStates(class_1657 player, class_2338 startPos, class_2680 blockState, class_1799 itemStack, List<class_1799> itemStacks) {
        LinkedHashMap<class_2338, class_2680> blockStates = new LinkedHashMap<class_2338, class_2680>();
        MirrorSettings mirrorSettings = BuildModifierHelper.getModifierSettings(player).mirrorSettings();
        if (!Mirror.isEnabled(mirrorSettings, startPos)) {
            return Collections.emptyMap();
        }
        class_1263 bagInventory = null;
        if (mirrorSettings.mirrorX) {
            Mirror.blockStateMirrorX(player, mirrorSettings, startPos, blockState, bagInventory, itemStack, class_1268.field_5808, blockStates, itemStacks);
        }
        if (mirrorSettings.mirrorY) {
            Mirror.blockStateMirrorY(player, mirrorSettings, startPos, blockState, bagInventory, itemStack, class_1268.field_5808, blockStates, itemStacks);
        }
        if (mirrorSettings.mirrorZ) {
            Mirror.blockStateMirrorZ(player, mirrorSettings, startPos, blockState, bagInventory, itemStack, class_1268.field_5808, blockStates, itemStacks);
        }
        return blockStates;
    }

    private static void blockStateMirrorX(class_1657 player, MirrorSettings mirrorSettings, class_2338 oldBlockPos, class_2680 oldBlockState, class_1263 bagInventory, class_1799 itemStack, class_1268 hand, Map<class_2338, class_2680> blockStates, List<class_1799> itemStacks) {
        double x = mirrorSettings.position.field_1352 + (mirrorSettings.position.field_1352 - (double)oldBlockPos.method_10263() - 0.5);
        class_2338 newBlockPos = new class_2338(x, (double)oldBlockPos.method_10264(), (double)oldBlockPos.method_10260());
        class_2680 newBlockState = oldBlockState == null ? null : oldBlockState.method_26185(class_2415.field_11301);
        blockStates.put(newBlockPos, newBlockState);
        itemStacks.add(itemStack);
        if (mirrorSettings.mirrorY) {
            Mirror.blockStateMirrorY(player, mirrorSettings, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
        if (mirrorSettings.mirrorZ) {
            Mirror.blockStateMirrorZ(player, mirrorSettings, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
    }

    private static void blockStateMirrorY(class_1657 player, MirrorSettings mirrorSettings, class_2338 oldBlockPos, class_2680 oldBlockState, class_1263 bagInventory, class_1799 itemStack, class_1268 hand, Map<class_2338, class_2680> blockStates, List<class_1799> itemStacks) {
        double y = mirrorSettings.position.field_1351 + (mirrorSettings.position.field_1351 - (double)oldBlockPos.method_10264() - 0.5);
        class_2338 newBlockPos = new class_2338((double)oldBlockPos.method_10263(), y, (double)oldBlockPos.method_10260());
        class_2680 newBlockState = oldBlockState == null ? null : Mirror.getVerticalMirror(oldBlockState);
        blockStates.put(newBlockPos, newBlockState);
        itemStacks.add(itemStack);
        if (mirrorSettings.mirrorZ) {
            Mirror.blockStateMirrorZ(player, mirrorSettings, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
    }

    private static void blockStateMirrorZ(class_1657 player, MirrorSettings mirrorSettings, class_2338 oldBlockPos, class_2680 oldBlockState, class_1263 bagInventory, class_1799 itemStack, class_1268 hand, Map<class_2338, class_2680> blockStates, List<class_1799> itemStacks) {
        double z = mirrorSettings.position.field_1350 + (mirrorSettings.position.field_1350 - (double)oldBlockPos.method_10260() - 0.5);
        class_2338 newBlockPos = new class_2338((double)oldBlockPos.method_10263(), (double)oldBlockPos.method_10264(), z);
        class_2680 newBlockState = oldBlockState == null ? null : oldBlockState.method_26185(class_2415.field_11300);
        blockStates.put(newBlockPos, newBlockState);
        itemStacks.add(itemStack);
    }

    public static boolean isEnabled(MirrorSettings mirrorSettings, class_2338 startPos) {
        if (mirrorSettings == null || !mirrorSettings.enabled || !mirrorSettings.mirrorX && !mirrorSettings.mirrorY && !mirrorSettings.mirrorZ) {
            return false;
        }
        return !((double)startPos.method_10263() + 0.5 < mirrorSettings.position.field_1352 - (double)mirrorSettings.radius || (double)startPos.method_10263() + 0.5 > mirrorSettings.position.field_1352 + (double)mirrorSettings.radius || (double)startPos.method_10264() + 0.5 < mirrorSettings.position.field_1351 - (double)mirrorSettings.radius || (double)startPos.method_10264() + 0.5 > mirrorSettings.position.field_1351 + (double)mirrorSettings.radius || (double)startPos.method_10260() + 0.5 < mirrorSettings.position.field_1350 - (double)mirrorSettings.radius || (double)startPos.method_10260() + 0.5 > mirrorSettings.position.field_1350 + (double)mirrorSettings.radius);
    }

    private static class_2680 getVerticalMirror(class_2680 blockState) {
        if (blockState.method_26204() instanceof class_2510) {
            if (blockState.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617) {
                return (class_2680)blockState.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
            }
            return (class_2680)blockState.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12617);
        }
        if (blockState.method_26204() instanceof class_2482) {
            if (blockState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12682) {
                return blockState;
            }
            if (blockState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
                return (class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
            }
            return (class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
        }
        if (blockState.method_26204() instanceof class_2318) {
            if (blockState.method_11654((class_2769)class_2318.field_10927) == class_2350.field_11033) {
                return (class_2680)blockState.method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11036);
            }
            if (blockState.method_11654((class_2769)class_2318.field_10927) == class_2350.field_11036) {
                return (class_2680)blockState.method_11657((class_2769)class_2318.field_10927, (Comparable)class_2350.field_11033);
            }
        }
        if (blockState.method_26204() instanceof class_2315) {
            if (blockState.method_11654((class_2769)class_2315.field_10918) == class_2350.field_11033) {
                return (class_2680)blockState.method_11657((class_2769)class_2315.field_10918, (Comparable)class_2350.field_11036);
            }
            if (blockState.method_11654((class_2769)class_2315.field_10918) == class_2350.field_11036) {
                return (class_2680)blockState.method_11657((class_2769)class_2315.field_10918, (Comparable)class_2350.field_11033);
            }
        }
        return blockState;
    }

    public record MirrorSettings(boolean enabled, class_243 position, boolean mirrorX, boolean mirrorY, boolean mirrorZ, int radius, boolean drawLines, boolean drawPlanes) {
        public MirrorSettings() {
            this(false, new class_243(0.5, 64.5, 0.5), true, false, false, 16, true, true);
        }

        public List<class_2350.class_2351> getMirrorAxis() {
            ArrayList<class_2350.class_2351> directions = new ArrayList<class_2350.class_2351>();
            if (this.mirrorX) {
                directions.add(class_2350.class_2351.field_11048);
            }
            if (this.mirrorY) {
                directions.add(class_2350.class_2351.field_11052);
            }
            if (this.mirrorZ) {
                directions.add(class_2350.class_2351.field_11051);
            }
            return directions;
        }

        public int reach() {
            return this.radius * 2;
        }

        public MirrorSettings clone(boolean enabled) {
            return new MirrorSettings(enabled, this.position, this.mirrorX, this.mirrorY, this.mirrorZ, this.radius, this.drawLines, this.drawPlanes);
        }
    }
}

