/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.huskcasaca.effortless.config.EffortlessConfig;
import dev.huskcasaca.effortless.config.PreviewConfig;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;

public class ConfigManager {
    public static final ConfigManager INSTANCE = new ConfigManager();
    public static final Integer quickReplaceMiningLevel = -1;
    private final Gson gson;
    private final File configFile;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private EffortlessConfig config;

    public ConfigManager() {
        this.gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
        this.configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "effortless.config");
        this.readConfig(false);
    }

    public static EffortlessConfig getGlobalConfig() {
        return INSTANCE.getConfig();
    }

    public static PreviewConfig getGlobalPreviewConfig() {
        return ConfigManager.getGlobalConfig().getPreviewConfig();
    }

    public void readConfig(boolean async) {
        Runnable task = () -> {
            try {
                if (this.configFile.exists()) {
                    String fileContents = FileUtils.readFileToString((File)this.configFile, (Charset)Charset.defaultCharset());
                    this.config = (EffortlessConfig)this.gson.fromJson(fileContents, EffortlessConfig.class);
                    if (this.config.isValid()) {
                        this.writeConfig(true);
                    }
                } else {
                    this.writeNewConfig();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writeNewConfig();
            }
        };
        if (async) {
            this.executor.execute(task);
        } else {
            task.run();
        }
    }

    public void writeNewConfig() {
        this.config = new EffortlessConfig();
        this.writeConfig(false);
    }

    public void writeConfig(boolean async) {
        Runnable task = () -> {
            try {
                if (this.config != null) {
                    String serialized = this.gson.toJson((Object)this.config);
                    FileUtils.writeStringToFile((File)this.configFile, (String)serialized, (Charset)Charset.defaultCharset());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        if (async) {
            this.executor.execute(task);
        } else {
            task.run();
        }
    }

    public EffortlessConfig getConfig() {
        return this.config;
    }
}

