/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.building;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.EffortlessClient;
import dev.huskcasaca.effortless.building.BuildAction;
import dev.huskcasaca.effortless.buildmode.BuildMode;
import dev.huskcasaca.effortless.buildmode.BuildModeHelper;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.buildmodifier.UndoRedo;
import dev.huskcasaca.effortless.entity.player.ModifierSettings;
import net.minecraft.class_124;
import net.minecraft.class_1657;

public class BuildActionHandler {
    private static BuildAction buildSpeed = BuildAction.SPEED_NORMAL;
    private static BuildAction lineThickness = BuildAction.THICKNESS_1;
    private static BuildAction planeFilling = BuildAction.PLANE_FULL;
    private static BuildAction cubeFilling = BuildAction.CUBE_FULL;
    private static BuildAction raisedEdge = BuildAction.RAISE_SHORT_EDGE;
    private static BuildAction circleStart = BuildAction.CIRCLE_START_CORNER;
    private static BuildAction orientation = BuildAction.FACE_HORIZONTAL;

    public static BuildAction getOptionSetting(BuildMode.Option option) {
        return switch (option) {
            default -> throw new IncompatibleClassChangeError();
            case BuildMode.Option.BUILD_SPEED -> BuildActionHandler.getBuildSpeed();
            case BuildMode.Option.LINE_THICKNESS -> BuildActionHandler.getLineThickness();
            case BuildMode.Option.PLANE_FILLING -> BuildActionHandler.getPlaneFilling();
            case BuildMode.Option.CUBE_FILLING -> BuildActionHandler.getCubeFilling();
            case BuildMode.Option.RAISED_EDGE -> BuildActionHandler.getRaisedEdge();
            case BuildMode.Option.CIRCLE_START -> BuildActionHandler.getCircleStart();
            case BuildMode.Option.ORIENTATION -> BuildActionHandler.getOrientation();
        };
    }

    public static BuildAction getBuildSpeed() {
        return buildSpeed;
    }

    public static BuildAction getPlaneFilling() {
        return planeFilling;
    }

    public static BuildAction getCubeFilling() {
        return cubeFilling;
    }

    public static BuildAction getRaisedEdge() {
        return raisedEdge;
    }

    public static BuildAction getLineThickness() {
        return lineThickness;
    }

    public static BuildAction getCircleStart() {
        return circleStart;
    }

    public static BuildAction getOrientation() {
        return orientation;
    }

    public static BuildAction[] getOptions() {
        return new BuildAction[]{BuildActionHandler.getBuildSpeed(), BuildActionHandler.getLineThickness(), BuildActionHandler.getPlaneFilling(), BuildActionHandler.getCubeFilling(), BuildActionHandler.getRaisedEdge(), BuildActionHandler.getCircleStart(), BuildActionHandler.getOrientation()};
    }

    public static void performAction(class_1657 player, BuildAction action) {
        if (action == null) {
            return;
        }
        switch (action) {
            case UNDO: {
                UndoRedo.undo(player);
                break;
            }
            case REDO: {
                UndoRedo.redo(player);
                break;
            }
            case REPLACE: {
                BuildModifierHelper.cycleReplaceMode(player);
                ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings(player);
                Effortless.log(player, class_124.field_1065 + "Replace " + class_124.field_1070 + (modifierSettings.enableReplace() ? (modifierSettings.enableQuickReplace() ? class_124.field_1060 + "QUICK" : class_124.field_1060 + "ON") : class_124.field_1061 + "OFF") + class_124.field_1070, true);
                break;
            }
            case MAGNET: {
                BuildModeHelper.setEnableMagnet(player, !BuildModeHelper.isEnableMagnet(player));
                Effortless.log(player, class_124.field_1065 + "Item Magnet " + class_124.field_1070 + (BuildModeHelper.isEnableMagnet(player) ? class_124.field_1060 + "ON" : class_124.field_1061 + "OFF") + class_124.field_1070, true);
                break;
            }
            case MODIFIER: {
                if (!player.field_6002.field_9236) break;
                EffortlessClient.openModifierSettings();
                break;
            }
            case OPEN_PLAYER_SETTINGS: {
                if (!player.field_6002.field_9236) break;
                EffortlessClient.openPlayerSettings();
                break;
            }
            case SETTINGS: {
                if (!player.field_6002.field_9236) break;
                EffortlessClient.openSettings();
                break;
            }
            case SPEED_NORMAL: {
                buildSpeed = BuildAction.SPEED_NORMAL;
                break;
            }
            case SPEED_FAST: {
                buildSpeed = BuildAction.SPEED_FAST;
                break;
            }
            case THICKNESS_1: {
                lineThickness = BuildAction.THICKNESS_1;
                break;
            }
            case THICKNESS_3: {
                lineThickness = BuildAction.THICKNESS_3;
                break;
            }
            case THICKNESS_5: {
                lineThickness = BuildAction.THICKNESS_5;
                break;
            }
            case PLANE_FULL: {
                planeFilling = BuildAction.PLANE_FULL;
                break;
            }
            case PLANE_HOLLOW: {
                planeFilling = BuildAction.PLANE_HOLLOW;
                break;
            }
            case CUBE_FULL: {
                cubeFilling = BuildAction.CUBE_FULL;
                break;
            }
            case CUBE_HOLLOW: {
                cubeFilling = BuildAction.CUBE_HOLLOW;
                break;
            }
            case CUBE_SKELETON: {
                cubeFilling = BuildAction.CUBE_SKELETON;
                break;
            }
            case RAISE_SHORT_EDGE: {
                raisedEdge = BuildAction.RAISE_SHORT_EDGE;
                break;
            }
            case RAISE_LONG_EDGE: {
                raisedEdge = BuildAction.RAISE_LONG_EDGE;
                break;
            }
            case CIRCLE_START_CENTER: {
                circleStart = BuildAction.CIRCLE_START_CENTER;
                break;
            }
            case CIRCLE_START_CORNER: {
                circleStart = BuildAction.CIRCLE_START_CORNER;
                break;
            }
            case FACE_HORIZONTAL: {
                orientation = BuildAction.FACE_HORIZONTAL;
                break;
            }
            case FACE_VERTICAL: {
                orientation = BuildAction.FACE_VERTICAL;
            }
        }
        if (player.field_6002.field_9236 && action != BuildAction.REPLACE && action != BuildAction.MODIFIER && action != BuildAction.OPEN_PLAYER_SETTINGS) {
            Effortless.logTranslate(player, "", action.getNameKey(), "", true);
        }
    }
}

