/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.building;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.entity.player.EffortlessDataProvider;
import dev.huskcasaca.effortless.entity.player.ReachSettings;
import dev.huskcasaca.effortless.network.Packets;
import dev.huskcasaca.effortless.network.protocol.player.ClientboundPlayerReachPacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerSetBuildReachPacket;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class ReachHelper {
    public static int MIN_MAX_REACH_DISTANCE = 1;
    public static int MAX_MAX_REACH_DISTANCE = 512;
    public static int MIN_MAX_BLOCK_PLACE_PER_AXIS = 1;
    public static int MAX_MAX_BLOCK_PLACE_PER_AXIS = 512;
    public static int MIN_MAX_BLOCK_PLACE_AT_ONCE = 1;
    public static int MAX_MAX_BLOCK_PLACE_AT_ONCE = 100000;
    public static int MIN_UNDO_STACK_SIZE = 0;
    public static int MAX_UNDO_STACK_SIZE = 100;

    public static ReachSettings getReachSettings(class_1657 player) {
        return ((EffortlessDataProvider)player).getReachSettings();
    }

    public static void setReachSettings(class_1657 player, ReachSettings reachSettings) {
        if (player == null) {
            Effortless.log("Cannot set reach settings, player is null");
            return;
        }
        ((EffortlessDataProvider)player).setReachSettings(reachSettings);
    }

    public static String getSanitizeMessage(ReachSettings modeSettings, class_1657 player) {
        int maxReach = ReachHelper.getMaxReachDistance(player);
        String error = "";
        return error;
    }

    public static ReachSettings sanitize(ReachSettings reachSettings, class_1657 player) {
        return new ReachSettings(Math.max(MIN_MAX_REACH_DISTANCE, Math.min(reachSettings.maxReachDistance(), MAX_MAX_REACH_DISTANCE)), Math.max(MIN_MAX_BLOCK_PLACE_PER_AXIS, Math.min(reachSettings.maxBlockPlacePerAxis(), MAX_MAX_BLOCK_PLACE_PER_AXIS)), Math.max(MIN_MAX_BLOCK_PLACE_AT_ONCE, Math.min(reachSettings.maxBlockPlaceAtOnce(), MAX_MAX_BLOCK_PLACE_AT_ONCE)), reachSettings.canBreakFar(), reachSettings.enableUndoRedo(), Math.max(MIN_UNDO_STACK_SIZE, Math.min(reachSettings.undoStackSize(), MAX_UNDO_STACK_SIZE)));
    }

    public static void handleNewPlayer(class_3222 player) {
        if (!player.field_6002.field_9236) {
            Packets.sendToClient(new ClientboundPlayerReachPacket(((EffortlessDataProvider)player).getReachSettings()), player);
        }
    }

    public static int getMaxReachDistance(class_1657 player) {
        return ReachHelper.getReachSettings(player).maxReachDistance();
    }

    public static void setMaxReachDistance(class_1657 player, int maxReachDistance) {
        ReachSettings reachSettings = ReachHelper.getReachSettings(player);
        reachSettings = new ReachSettings(maxReachDistance, reachSettings.maxBlockPlacePerAxis(), reachSettings.maxBlockPlaceAtOnce(), reachSettings.canBreakFar(), reachSettings.enableUndoRedo(), reachSettings.undoStackSize());
        ReachHelper.setReachSettings(player, reachSettings);
    }

    public static int getPlacementReach(class_1657 player) {
        return ReachHelper.getMaxReachDistance(player) / 4;
    }

    public static int getMaxBlockPlacePerAxis(class_1657 player) {
        return ReachHelper.getReachSettings(player).maxBlockPlacePerAxis();
    }

    public static void setMaxBlockPlacePerAxis(class_1657 player, int maxBlockPlacePerAxis) {
        ReachSettings reachSettings = ReachHelper.getReachSettings(player);
        reachSettings = new ReachSettings(reachSettings.maxReachDistance(), maxBlockPlacePerAxis, reachSettings.maxBlockPlaceAtOnce(), reachSettings.canBreakFar(), reachSettings.enableUndoRedo(), reachSettings.undoStackSize());
        ReachHelper.setReachSettings(player, reachSettings);
    }

    public static int getMaxBlockPlaceAtOnce(class_1657 player) {
        return ReachHelper.getReachSettings(player).maxBlockPlaceAtOnce();
    }

    public static void setMaxBlockPlaceAtOnce(class_1657 player, int maxBlockPlaceAtOnce) {
        ReachSettings reachSettings = ReachHelper.getReachSettings(player);
        reachSettings = new ReachSettings(reachSettings.maxReachDistance(), reachSettings.maxBlockPlacePerAxis(), maxBlockPlaceAtOnce, reachSettings.canBreakFar(), reachSettings.enableUndoRedo(), reachSettings.undoStackSize());
        ReachHelper.setReachSettings(player, reachSettings);
    }

    public static boolean isCanBreakFar(class_1657 player) {
        return ReachHelper.getReachSettings(player).canBreakFar();
    }

    public static void setCanBreakFar(class_1657 player, boolean canBreakFar) {
        ReachSettings reachSettings = ReachHelper.getReachSettings(player);
        reachSettings = new ReachSettings(reachSettings.maxReachDistance(), reachSettings.maxBlockPlacePerAxis(), reachSettings.maxBlockPlaceAtOnce(), canBreakFar, reachSettings.enableUndoRedo(), reachSettings.undoStackSize());
        ReachHelper.setReachSettings(player, reachSettings);
    }

    public static boolean isEnableUndo(class_1657 player) {
        return ReachHelper.getReachSettings(player).enableUndoRedo();
    }

    public static void setEnableUndoRedo(class_1657 player, boolean enableUndoRedo) {
        ReachSettings reachSettings = ReachHelper.getReachSettings(player);
        reachSettings = new ReachSettings(reachSettings.maxReachDistance(), reachSettings.maxBlockPlacePerAxis(), reachSettings.maxBlockPlaceAtOnce(), reachSettings.canBreakFar(), enableUndoRedo, reachSettings.undoStackSize());
        ReachHelper.setReachSettings(player, reachSettings);
    }

    public static int getUndoStackSize(class_1657 player) {
        return ReachHelper.getReachSettings(player).undoStackSize();
    }

    public static void setUndoStackSize(class_1657 player, int undoStackSize) {
        ReachSettings reachSettings = ReachHelper.getReachSettings(player);
        reachSettings = new ReachSettings(reachSettings.maxReachDistance(), reachSettings.maxBlockPlacePerAxis(), reachSettings.maxBlockPlaceAtOnce(), reachSettings.canBreakFar(), reachSettings.enableUndoRedo(), undoStackSize);
        ReachHelper.setReachSettings(player, reachSettings);
    }

    public static void sync(class_1657 player) {
        if (player instanceof class_3222) {
            Packets.sendToClient(new ClientboundPlayerReachPacket(ReachHelper.getReachSettings(player)), (class_3222)player);
        } else {
            Packets.sendToServer(new ServerboundPlayerSetBuildReachPacket(ReachHelper.getReachSettings(player)));
        }
    }
}

