/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmode.twoclick;

import dev.huskcasaca.effortless.building.BuildAction;
import dev.huskcasaca.effortless.building.BuildActionHandler;
import dev.huskcasaca.effortless.buildmode.TwoClickBuildable;
import dev.huskcasaca.effortless.buildmode.twoclick.Floor;
import dev.huskcasaca.effortless.buildmode.twoclick.Wall;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3532;

public class Circle
extends TwoClickBuildable {
    private static float distance(float a1, float b1, float a2, float b2) {
        return class_3532.method_15355((float)((a2 - a1) * (a2 - a1) + (b2 - b1) * (b2 - b1)));
    }

    public static float calculateEllipseRadius(float centerA, float centerB, float radiusA, float radiusB, int a, int b) {
        float theta = (float)class_3532.method_15349((double)((float)b - centerB), (double)((float)a - centerA));
        float part1 = radiusA * radiusA * class_3532.method_15374((float)theta) * class_3532.method_15374((float)theta);
        float part2 = radiusB * radiusB * class_3532.method_15362((float)theta) * class_3532.method_15362((float)theta);
        return radiusA * radiusB / class_3532.method_15355((float)(part1 + part2));
    }

    public static List<class_2338> getFloorCircleBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        float centerX = x1;
        float centerZ = z1;
        if (BuildActionHandler.getCircleStart() == BuildAction.CIRCLE_START_CORNER) {
            centerX = (float)x1 + (float)(x2 - x1) / 2.0f;
            centerZ = (float)z1 + (float)(z2 - z1) / 2.0f;
        } else {
            x1 = (int)(centerX - ((float)x2 - centerX));
            z1 = (int)(centerZ - ((float)z2 - centerZ));
        }
        float radiusX = class_3532.method_15379((float)((float)x2 - centerX));
        float radiusZ = class_3532.method_15379((float)((float)z2 - centerZ));
        if (BuildActionHandler.getPlaneFilling() == BuildAction.PLANE_FULL) {
            Circle.addCircleBlocks(list, x1, y1, z1, x2, y2, z2, centerX, centerZ, radiusX, radiusZ);
        } else {
            Circle.addHollowCircleBlocks(list, x1, y1, z1, x2, y2, z2, centerX, centerZ, radiusX, radiusZ);
        }
        return list;
    }

    public static void addCircleBlocks(List<class_2338> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerX, float centerZ, float radiusX, float radiusZ) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                float radius;
                float distance = Circle.distance(l, n, centerX, centerZ);
                if (distance < (radius = Circle.calculateEllipseRadius(centerX, centerZ, radiusX, radiusZ, l, n)) + 0.4f) {
                    list.add(new class_2338(l, y1, n));
                }
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    public static void addHollowCircleBlocks(List<class_2338> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerX, float centerZ, float radiusX, float radiusZ) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                float radius;
                float distance = Circle.distance(l, n, centerX, centerZ);
                if (distance < (radius = Circle.calculateEllipseRadius(centerX, centerZ, radiusX, radiusZ, l, n)) + 0.4f && distance > radius - 0.6f) {
                    list.add(new class_2338(l, y1, n));
                }
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    public static List<class_2338> getWallCircleBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        float centerX = x1;
        float centerY = y1;
        float centerZ = z1;
        if (BuildActionHandler.getCircleStart() == BuildAction.CIRCLE_START_CORNER) {
            centerX = (float)x1 + (float)(x2 - x1) / 2.0f;
            centerY = (float)y1 + (float)(y2 - y1) / 2.0f;
            centerZ = (float)z1 + (float)(z2 - z1) / 2.0f;
        } else {
            x1 = (int)(centerX - ((float)x2 - centerX));
            y1 = (int)(centerY - ((float)y2 - centerY));
            z1 = (int)(centerZ - ((float)z2 - centerZ));
        }
        float radiusX = class_3532.method_15379((float)((float)x2 - centerX));
        float radiusY = class_3532.method_15379((float)((float)y2 - centerY));
        float radiusZ = class_3532.method_15379((float)((float)z2 - centerZ));
        if (x1 == x2) {
            if (BuildActionHandler.getPlaneFilling() == BuildAction.PLANE_FULL) {
                Circle.addXWallCircleBlocks(list, x1, y1, z1, x2, y2, z2, centerY, centerZ, radiusY, radiusZ);
            } else {
                Circle.addXHollowWallCircleBlocks(list, x1, y1, z1, x2, y2, z2, centerY, centerZ, radiusY, radiusZ);
            }
        } else if (BuildActionHandler.getPlaneFilling() == BuildAction.PLANE_FULL) {
            Circle.addZWallCircleBlocks(list, x1, y1, z1, x2, y2, z2, centerY, centerX, radiusY, radiusX);
        } else {
            Circle.addZHollowWallCircleBlocks(list, x1, y1, z1, x2, y2, z2, centerY, centerZ, radiusY, radiusZ);
        }
        return list;
    }

    public static void addXWallCircleBlocks(List<class_2338> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerY, float centerZ, float radiusY, float radiusZ) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            int z = z1;
            while (z1 < z2 ? z <= z2 : z >= z2) {
                float radius;
                float distance = Circle.distance(y, z, centerY, centerZ);
                if (distance < (radius = Circle.calculateEllipseRadius(centerY, centerZ, radiusY, radiusZ, y, z)) + 0.4f) {
                    list.add(new class_2338(x1, y, z));
                }
                z += z1 < z2 ? 1 : -1;
            }
            y += y1 < y2 ? 1 : -1;
        }
    }

    public static void addZWallCircleBlocks(List<class_2338> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerY, float centerX, float radiusY, float radiusX) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            int x = x1;
            while (x1 < x2 ? x <= x2 : x >= x2) {
                float radius;
                float distance = Circle.distance(y, x, centerY, centerX);
                if (distance < (radius = Circle.calculateEllipseRadius(centerY, centerX, radiusY, radiusX, y, x)) + 0.4f) {
                    list.add(new class_2338(x, y, z1));
                }
                x += x1 < x2 ? 1 : -1;
            }
            y += y1 < y2 ? 1 : -1;
        }
    }

    public static void addXHollowWallCircleBlocks(List<class_2338> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerY, float centerZ, float radiusY, float radiusZ) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            int z = z1;
            while (z1 < z2 ? z <= z2 : z >= z2) {
                float radius;
                float distance = Circle.distance(y, z, centerY, centerZ);
                if (distance < (radius = Circle.calculateEllipseRadius(centerY, centerZ, radiusY, radiusZ, y, z)) + 0.4f && distance > radius - 0.6f) {
                    list.add(new class_2338(x1, y, z));
                }
                z += z1 < z2 ? 1 : -1;
            }
            y += y1 < y2 ? 1 : -1;
        }
    }

    public static void addZHollowWallCircleBlocks(List<class_2338> list, int x1, int y1, int z1, int x2, int y2, int z2, float centerY, float centerX, float radiusY, float radiusX) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            int x = x1;
            while (x1 < x2 ? x <= x2 : x >= x2) {
                float radius;
                float distance = Circle.distance(y, x, centerY, centerX);
                if (distance < (radius = Circle.calculateEllipseRadius(centerY, centerX, radiusY, radiusX, y, x)) + 0.4f && distance > radius - 0.6f) {
                    list.add(new class_2338(x, y, z1));
                }
                x += x1 < x2 ? 1 : -1;
            }
            y += y1 < y2 ? 1 : -1;
        }
    }

    @Override
    protected class_2338 findSecondPos(class_1657 player, class_2338 firstPos, boolean skipRaytrace) {
        if (BuildActionHandler.getOrientation() == BuildAction.FACE_HORIZONTAL) {
            return Floor.findFloor(player, firstPos, skipRaytrace);
        }
        return Wall.findWall(player, firstPos, skipRaytrace);
    }

    @Override
    public List<class_2338> getFinalBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (BuildActionHandler.getOrientation() == BuildAction.FACE_HORIZONTAL) {
            return Circle.getFloorCircleBlocks(player, x1, y1, z1, x2, y2, z2);
        }
        return Circle.getWallCircleBlocks(player, x1, y1, z1, x2, y2, z2);
    }
}

