/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmode.twoclick;

import dev.huskcasaca.effortless.building.BuildAction;
import dev.huskcasaca.effortless.building.BuildActionHandler;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmode.BuildModeHandler;
import dev.huskcasaca.effortless.buildmode.TwoClickBuildable;
import dev.huskcasaca.effortless.buildmode.twoclick.Line;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class Floor
extends TwoClickBuildable {
    public static class_2338 findFloor(class_1657 player, class_2338 firstPos, boolean skipRaytrace) {
        class_243 look = BuildModeHandler.getPlayerLookVec(player);
        class_243 start = new class_243(player.method_23317(), player.method_23318() + (double)player.method_5751(), player.method_23321());
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>(3);
        class_243 yBound = BuildModeHandler.findYBound(firstPos.method_10264(), start, look);
        criteriaList.add(new Criteria(yBound, start));
        int reach = ReachHelper.getPlacementReach(player) * 4;
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        Criteria selected = (Criteria)criteriaList.get(0);
        return new class_2338(class_3532.method_15357((double)selected.planeBound.field_1352), class_3532.method_15357((double)selected.planeBound.field_1351), class_3532.method_15357((double)selected.planeBound.field_1350));
    }

    public static List<class_2338> getFloorBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        if (BuildActionHandler.getPlaneFilling() == BuildAction.PLANE_FULL) {
            Floor.addFloorBlocks(list, x1, x2, y1, z1, z2);
        } else {
            Floor.addHollowFloorBlocks(list, x1, x2, y1, z1, z2);
        }
        return list;
    }

    public static void addFloorBlocks(List<class_2338> list, int x1, int x2, int y, int z1, int z2) {
        int l = x1;
        while (x1 < x2 ? l <= x2 : l >= x2) {
            int n = z1;
            while (z1 < z2 ? n <= z2 : n >= z2) {
                list.add(new class_2338(l, y, n));
                n += z1 < z2 ? 1 : -1;
            }
            l += x1 < x2 ? 1 : -1;
        }
    }

    public static void addHollowFloorBlocks(List<class_2338> list, int x1, int x2, int y, int z1, int z2) {
        Line.addXLineBlocks(list, x1, x2, y, z1);
        Line.addXLineBlocks(list, x1, x2, y, z2);
        Line.addZLineBlocks(list, z1, z2, x1, y);
        Line.addZLineBlocks(list, z1, z2, x2, y);
    }

    @Override
    protected class_2338 findSecondPos(class_1657 player, class_2338 firstPos, boolean skipRaytrace) {
        return Floor.findFloor(player, firstPos, skipRaytrace);
    }

    @Override
    public List<class_2338> getFinalBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Floor.getFloorBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    static class Criteria {
        class_243 planeBound;
        double distToPlayerSq;

        Criteria(class_243 planeBound, class_243 start) {
            this.planeBound = planeBound;
            this.distToPlayerSq = this.planeBound.method_1020(start).method_1027();
        }

        public boolean isValid(class_243 start, class_243 look, int reach, class_1657 player, boolean skipRaytrace) {
            return BuildModeHandler.isCriteriaValid(start, look, reach, player, skipRaytrace, this.planeBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

