/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmode.twoclick;

import dev.huskcasaca.effortless.building.BuildAction;
import dev.huskcasaca.effortless.building.BuildActionHandler;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmode.BuildModeHandler;
import dev.huskcasaca.effortless.buildmode.TwoClickBuildable;
import dev.huskcasaca.effortless.buildmode.twoclick.Line;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class Wall
extends TwoClickBuildable {
    public static class_2338 findWall(class_1657 player, class_2338 firstPos, boolean skipRaytrace) {
        class_243 look = BuildModeHandler.getPlayerLookVec(player);
        class_243 start = new class_243(player.method_23317(), player.method_23318() + (double)player.method_5751(), player.method_23321());
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>(3);
        class_243 xBound = BuildModeHandler.findXBound(firstPos.method_10263(), start, look);
        criteriaList.add(new Criteria(xBound, firstPos, start, look));
        class_243 zBound = BuildModeHandler.findZBound(firstPos.method_10260(), start, look);
        criteriaList.add(new Criteria(zBound, firstPos, start, look));
        int reach = ReachHelper.getPlacementReach(player) * 4;
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        Criteria selected = (Criteria)criteriaList.get(0);
        if (criteriaList.size() > 1) {
            for (int i = 1; i < criteriaList.size(); ++i) {
                Criteria criteria2 = (Criteria)criteriaList.get(i);
                if (!(criteria2.distToPlayerSq < selected.distToPlayerSq) || !(Math.abs(criteria2.angle) - Math.abs(selected.angle) < 3.0)) continue;
                selected = criteria2;
            }
        }
        return new class_2338(class_3532.method_15357((double)selected.planeBound.field_1352), class_3532.method_15357((double)selected.planeBound.field_1351), class_3532.method_15357((double)selected.planeBound.field_1350));
    }

    public static List<class_2338> getWallBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        if (x1 == x2) {
            if (BuildActionHandler.getPlaneFilling() == BuildAction.PLANE_FULL) {
                Wall.addXWallBlocks(list, x1, y1, y2, z1, z2);
            } else {
                Wall.addXHollowWallBlocks(list, x1, y1, y2, z1, z2);
            }
        } else if (BuildActionHandler.getPlaneFilling() == BuildAction.PLANE_FULL) {
            Wall.addZWallBlocks(list, x1, x2, y1, y2, z1);
        } else {
            Wall.addZHollowWallBlocks(list, x1, x2, y1, y2, z1);
        }
        return list;
    }

    public static void addXWallBlocks(List<class_2338> list, int x, int y1, int y2, int z1, int z2) {
        int z = z1;
        while (z1 < z2 ? z <= z2 : z >= z2) {
            int y = y1;
            while (y1 < y2 ? y <= y2 : y >= y2) {
                list.add(new class_2338(x, y, z));
                y += y1 < y2 ? 1 : -1;
            }
            z += z1 < z2 ? 1 : -1;
        }
    }

    public static void addZWallBlocks(List<class_2338> list, int x1, int x2, int y1, int y2, int z) {
        int x = x1;
        while (x1 < x2 ? x <= x2 : x >= x2) {
            int y = y1;
            while (y1 < y2 ? y <= y2 : y >= y2) {
                list.add(new class_2338(x, y, z));
                y += y1 < y2 ? 1 : -1;
            }
            x += x1 < x2 ? 1 : -1;
        }
    }

    public static void addXHollowWallBlocks(List<class_2338> list, int x, int y1, int y2, int z1, int z2) {
        Line.addZLineBlocks(list, z1, z2, x, y1);
        Line.addZLineBlocks(list, z1, z2, x, y2);
        Line.addYLineBlocks(list, y1, y2, x, z1);
        Line.addYLineBlocks(list, y1, y2, x, z2);
    }

    public static void addZHollowWallBlocks(List<class_2338> list, int x1, int x2, int y1, int y2, int z) {
        Line.addXLineBlocks(list, x1, x2, y1, z);
        Line.addXLineBlocks(list, x1, x2, y2, z);
        Line.addYLineBlocks(list, y1, y2, x1, z);
        Line.addYLineBlocks(list, y1, y2, x2, z);
    }

    @Override
    protected class_2338 findSecondPos(class_1657 player, class_2338 firstPos, boolean skipRaytrace) {
        return Wall.findWall(player, firstPos, skipRaytrace);
    }

    @Override
    public List<class_2338> getFinalBlocks(class_1657 player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Wall.getWallBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    static class Criteria {
        class_243 planeBound;
        double distToPlayerSq;
        double angle;

        Criteria(class_243 planeBound, class_2338 firstPos, class_243 start, class_243 look) {
            this.planeBound = planeBound;
            this.distToPlayerSq = this.planeBound.method_1020(start).method_1027();
            class_243 wall = this.planeBound.method_1020(class_243.method_24954((class_2382)firstPos));
            this.angle = wall.field_1352 * look.field_1352 + wall.field_1350 * look.field_1350;
        }

        public boolean isValid(class_243 start, class_243 look, int reach, class_1657 player, boolean skipRaytrace) {
            return BuildModeHandler.isCriteriaValid(start, look, reach, player, skipRaytrace, this.planeBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

