/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.buildmodifier.mirror;

import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.buildmodifier.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class RadialMirror
implements Modifier {
    public static Set<class_2338> findCoordinates(class_1657 player, class_2338 startPos) {
        LinkedHashSet<class_2338> coordinates = new LinkedHashSet<class_2338>();
        RadialMirrorSettings radialMirrorSettings = BuildModifierHelper.getModifierSettings(player).radialMirrorSettings();
        if (!RadialMirror.isEnabled(radialMirrorSettings, startPos)) {
            return Collections.emptySet();
        }
        double sliceAngle = Math.PI * 2 / (double)radialMirrorSettings.slices;
        class_243 startVec = new class_243((double)((float)startPos.method_10263() + 0.5f), (double)((float)startPos.method_10264() + 0.5f), (double)((float)startPos.method_10260() + 0.5f));
        class_243 relStartVec = startVec.method_1020(radialMirrorSettings.position);
        double startAngleToCenter = class_3532.method_15349((double)relStartVec.field_1352, (double)relStartVec.field_1350);
        if (startAngleToCenter < 0.0) {
            startAngleToCenter += Math.PI;
        }
        double startAngleInSlice = startAngleToCenter % sliceAngle;
        for (int i = 1; i < radialMirrorSettings.slices; ++i) {
            double curAngle = sliceAngle * (double)i;
            if (radialMirrorSettings.alternate && i % 2 == 1) {
                curAngle = curAngle - startAngleInSlice + (sliceAngle - startAngleInSlice);
            }
            class_243 relNewVec = relStartVec.method_1024((float)curAngle);
            class_243 relNewVecOffset = radialMirrorSettings.position.method_1019(relNewVec);
            class_2382 relNewVecOffsetInt = new class_2382(class_3532.method_15357((double)relNewVecOffset.field_1352), class_3532.method_15357((double)relNewVecOffset.field_1351), class_3532.method_15357((double)relNewVecOffset.field_1350));
            class_2338 newBlockPos = new class_2338(relNewVecOffsetInt);
            if (coordinates.contains(newBlockPos) || newBlockPos.equals((Object)startPos)) continue;
            coordinates.add(newBlockPos);
        }
        return coordinates;
    }

    public static Map<class_2338, class_2680> findBlockStates(class_1657 player, class_2338 startPos, class_2680 blockState, class_1799 itemStack, List<class_1799> itemStacks) {
        LinkedHashMap<class_2338, class_2680> blockStates = new LinkedHashMap<class_2338, class_2680>();
        RadialMirrorSettings radialMirrorSettings = BuildModifierHelper.getModifierSettings(player).radialMirrorSettings();
        if (!RadialMirror.isEnabled(radialMirrorSettings, startPos)) {
            return Collections.emptyMap();
        }
        double sliceAngle = Math.PI * 2 / (double)radialMirrorSettings.slices;
        class_243 startVec = new class_243((double)((float)startPos.method_10263() + 0.5f), (double)((float)startPos.method_10264() + 0.5f), (double)((float)startPos.method_10260() + 0.5f));
        class_243 relStartVec = startVec.method_1020(radialMirrorSettings.position);
        double startAngleToCenter = class_3532.method_15349((double)relStartVec.field_1352, (double)relStartVec.field_1350);
        double startAngleToCenterMod = startAngleToCenter < 0.0 ? startAngleToCenter + Math.PI : startAngleToCenter;
        double startAngleInSlice = startAngleToCenterMod % sliceAngle;
        blockState = RadialMirror.rotateOriginalBlockState(player, startPos, startAngleToCenter, blockState);
        for (int i = 1; i < radialMirrorSettings.slices; ++i) {
            class_2680 newBlockState = blockState;
            double curAngle = sliceAngle * (double)i;
            if (radialMirrorSettings.alternate && i % 2 == 1) {
                curAngle = curAngle - startAngleInSlice + (sliceAngle - startAngleInSlice);
            }
            class_243 relNewVec = relStartVec.method_1024((float)curAngle);
            class_243 relNewVecOffset = radialMirrorSettings.position.method_1019(relNewVec);
            class_2382 relNewVecOffsetInt = new class_2382(class_3532.method_15357((double)relNewVecOffset.field_1352), class_3532.method_15357((double)relNewVecOffset.field_1351), class_3532.method_15357((double)relNewVecOffset.field_1350));
            class_2338 newBlockPos = new class_2338(relNewVecOffsetInt);
            newBlockState = RadialMirror.rotateBlockState(player, startPos, relNewVec, newBlockState, radialMirrorSettings.alternate && i % 2 == 1);
            blockStates.putIfAbsent(newBlockPos, newBlockState);
            itemStacks.add(itemStack);
        }
        return blockStates;
    }

    private static class_2680 rotateOriginalBlockState(class_1657 player, class_2338 startPos, double startAngleToCenter, class_2680 blockState) {
        class_2680 newBlockState = blockState;
        if (startAngleToCenter < -2.3593360828459344 || startAngleToCenter > 2.3530528975387552) {
            newBlockState = blockState.method_26186(class_2470.field_11464);
        } else if (startAngleToCenter < -0.7885397560510381) {
            newBlockState = blockState.method_26186(class_2470.field_11465);
        } else if (startAngleToCenter > 0.7822565707438585) {
            newBlockState = blockState.method_26186(class_2470.field_11463);
        }
        return newBlockState;
    }

    private static class_2680 rotateBlockState(class_1657 player, class_2338 startPos, class_243 relVec, class_2680 blockState, boolean alternate) {
        class_2680 newBlockState;
        double angleToCenter = class_3532.method_15349((double)relVec.field_1352, (double)relVec.field_1350);
        if (angleToCenter < -2.3593360828459344 || angleToCenter > 2.3530528975387552) {
            newBlockState = blockState.method_26186(class_2470.field_11464);
            if (alternate) {
                newBlockState = newBlockState.method_26185(class_2415.field_11301);
            }
        } else if (angleToCenter < -0.7885397560510381) {
            newBlockState = blockState.method_26186(class_2470.field_11463);
            if (alternate) {
                newBlockState = newBlockState.method_26185(class_2415.field_11300);
            }
        } else if (angleToCenter > 0.7822565707438585) {
            newBlockState = blockState.method_26186(class_2470.field_11465);
            if (alternate) {
                newBlockState = newBlockState.method_26185(class_2415.field_11300);
            }
        } else {
            newBlockState = blockState;
            if (alternate) {
                newBlockState = newBlockState.method_26185(class_2415.field_11301);
            }
        }
        return newBlockState;
    }

    public static boolean isEnabled(RadialMirrorSettings radialMirrorSettings, class_2338 startPos) {
        if (radialMirrorSettings == null || !radialMirrorSettings.enabled()) {
            return false;
        }
        return !((double)(radialMirrorSettings.radius * radialMirrorSettings.radius) < new class_243((double)startPos.method_10263() + 0.5, (double)startPos.method_10264() + 0.5, (double)startPos.method_10260() + 0.5).method_1020(radialMirrorSettings.position).method_1027());
    }

    public record RadialMirrorSettings(boolean enabled, class_243 position, int slices, boolean alternate, int radius, boolean drawLines, boolean drawPlanes) {
        public RadialMirrorSettings() {
            this(false, new class_243(0.5, 64.5, 0.5), 3, false, 16, true, true);
        }

        public int reach() {
            return this.radius * 2;
        }

        public RadialMirrorSettings clone(boolean enabled) {
            return new RadialMirrorSettings(enabled, this.position, this.slices, this.alternate, this.radius, this.drawLines, this.drawPlanes);
        }
    }
}

