/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.mixin;

import dev.huskcasaca.effortless.building.BuildActionHandler;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmode.BuildModeHandler;
import dev.huskcasaca.effortless.buildmode.BuildModeHelper;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.network.Packets;
import dev.huskcasaca.effortless.network.protocol.player.ServerEffortlessPacketListener;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerBreakBlockPacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerBuildActionPacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerPlaceBlockPacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerSetBuildModePacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerSetBuildModifierPacket;
import dev.huskcasaca.effortless.network.protocol.player.ServerboundPlayerSetBuildReachPacket;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2600;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7648;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class ServerPacketListenerMixin
implements ServerEffortlessPacketListener {
    @Shadow
    public class_3222 field_14140;
    @Shadow
    @Final
    private MinecraftServer field_14148;

    @Shadow
    public abstract void method_14369(class_2596<?> var1, @Nullable class_7648 var2);

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void send(class_2596<?> packet, @Nullable class_7648 packetSendListener, CallbackInfo ci) {
        class_2960 resourceLocation = Packets.getKey(packet);
        if (resourceLocation == null) {
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        packet.method_11052(buf);
        this.method_14369((class_2596<?>)new class_2658(resourceLocation, buf), packetSendListener);
        ci.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")}, cancellable=true)
    void handleCustomPayload(class_2817 serverboundCustomPayloadPacket, CallbackInfo ci) {
        class_2960 resourceLocation = serverboundCustomPayloadPacket.method_36169();
        class_2540 friendlyByteBuf = null;
        if (Objects.equals(resourceLocation.method_12836(), "effortless")) {
            try {
                friendlyByteBuf = serverboundCustomPayloadPacket.method_36170();
                Packets.getDeserializer(resourceLocation).apply(friendlyByteBuf).method_11054((class_2547)this);
            }
            finally {
                if (friendlyByteBuf != null) {
                    // empty if block
                }
            }
            ci.cancel();
        }
    }

    @Override
    public void handle(ServerboundPlayerBreakBlockPacket packet) {
        class_2600.method_11073((class_2596)packet, (class_2547)this, (class_3218)this.field_14140.method_14220());
        BuildModeHandler.onBlockBrokenPacketReceived((class_1657)this.field_14140, packet);
    }

    @Override
    public void handle(ServerboundPlayerBuildActionPacket packet) {
        class_2600.method_11073((class_2596)packet, (class_2547)this, (class_3218)this.field_14140.method_14220());
        BuildActionHandler.performAction((class_1657)this.field_14140, packet.action());
    }

    @Override
    public void handle(ServerboundPlayerPlaceBlockPacket packet) {
        class_2600.method_11073((class_2596)packet, (class_2547)this, (class_3218)this.field_14140.method_14220());
        BuildModeHandler.onBlockPlacedPacketReceived((class_1657)this.field_14140, packet);
    }

    @Override
    public void handle(ServerboundPlayerSetBuildModePacket packet) {
        class_2600.method_11073((class_2596)packet, (class_2547)this, (class_3218)this.field_14140.method_14220());
        BuildModeHelper.setModeSettings((class_1657)this.field_14140, BuildModeHelper.sanitize(packet.modeSettings(), (class_1657)this.field_14140));
        BuildModeHandler.initializeMode((class_1657)this.field_14140);
    }

    @Override
    public void handle(ServerboundPlayerSetBuildModifierPacket packet) {
        class_2600.method_11073((class_2596)packet, (class_2547)this, (class_3218)this.field_14140.method_14220());
        BuildModifierHelper.setModifierSettings((class_1657)this.field_14140, BuildModifierHelper.sanitize(packet.modifierSettings(), (class_1657)this.field_14140));
    }

    @Override
    public void handle(ServerboundPlayerSetBuildReachPacket packet) {
        class_2600.method_11073((class_2596)packet, (class_2547)this, (class_3218)this.field_14140.method_14220());
        ReachHelper.setReachSettings((class_1657)this.field_14140, ReachHelper.sanitize(packet.reachSettings(), (class_1657)this.field_14140));
        BuildModeHandler.initializeMode((class_1657)this.field_14140);
    }
}

