/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.screen.buildmodifier;

import dev.huskcasaca.effortless.Effortless;
import dev.huskcasaca.effortless.building.ReachHelper;
import dev.huskcasaca.effortless.buildmodifier.BuildModifierHelper;
import dev.huskcasaca.effortless.buildmodifier.array.Array;
import dev.huskcasaca.effortless.entity.player.ModifierSettings;
import dev.huskcasaca.effortless.screen.widget.Checkbox;
import dev.huskcasaca.effortless.screen.widget.ExpandableScrollEntry;
import dev.huskcasaca.effortless.screen.widget.NumberField;
import dev.huskcasaca.effortless.screen.widget.ScrollPane;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class ArraySettingsPane
extends ExpandableScrollEntry {
    protected List<NumberField> arrayNumberFieldList = new ArrayList<NumberField>();
    private Checkbox buttonArrayEnabled;
    private NumberField textArrayOffsetX;
    private NumberField textArrayOffsetY;
    private NumberField textArrayOffsetZ;
    private NumberField textArrayCount;

    public ArraySettingsPane(ScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public void init(List<class_4068> renderables) {
        super.init(renderables);
        int y = this.top;
        this.buttonArrayEnabled = new Checkbox(this.left - 15 + 8, y, "", false){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                ArraySettingsPane.this.setCollapsed(!ArraySettingsPane.this.buttonArrayEnabled.isChecked());
            }
        };
        renderables.add((class_4068)this.buttonArrayEnabled);
        y = this.top + 20;
        this.textArrayOffsetX = new NumberField(this.font, renderables, this.left + 60, y, 90, 18);
        this.textArrayOffsetX.setNumber(0.0);
        this.textArrayOffsetX.setTooltip((class_2561)class_2561.method_43470((String)"How much each copy is shifted."));
        this.arrayNumberFieldList.add(this.textArrayOffsetX);
        this.textArrayOffsetY = new NumberField(this.font, renderables, this.left + 60, y + 24, 90, 18);
        this.textArrayOffsetY.setNumber(0.0);
        this.textArrayOffsetY.setTooltip((class_2561)class_2561.method_43470((String)"How much each copy is shifted."));
        this.arrayNumberFieldList.add(this.textArrayOffsetY);
        this.textArrayOffsetZ = new NumberField(this.font, renderables, this.left + 60, y + 48, 90, 18);
        this.textArrayOffsetZ.setNumber(0.0);
        this.textArrayOffsetZ.setTooltip((class_2561)class_2561.method_43470((String)"How much each copy is shifted."));
        this.arrayNumberFieldList.add(this.textArrayOffsetZ);
        this.textArrayCount = new NumberField(this.font, renderables, this.left + 200, y, 80, 18);
        this.textArrayCount.setNumber(5.0);
        this.textArrayCount.setTooltip((class_2561)class_2561.method_43470((String)"How many copies should be made."));
        this.arrayNumberFieldList.add(this.textArrayCount);
        ModifierSettings modifierSettings = BuildModifierHelper.getModifierSettings((class_1657)this.mc.field_1724);
        if (modifierSettings != null) {
            Array.ArraySettings arraySettings = modifierSettings.arraySettings();
            this.buttonArrayEnabled.setIsChecked(arraySettings.enabled());
            this.textArrayOffsetX.setNumber(arraySettings.offset().method_10263());
            this.textArrayOffsetY.setNumber(arraySettings.offset().method_10264());
            this.textArrayOffsetZ.setNumber(arraySettings.offset().method_10260());
            this.textArrayCount.setNumber(arraySettings.count());
        }
        this.setCollapsed(!this.buttonArrayEnabled.isChecked());
    }

    @Override
    public void updateScreen() {
        this.arrayNumberFieldList.forEach(NumberField::update);
    }

    @Override
    public void drawEntry(class_4587 poseStack, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int yy = y;
        int offset = 8;
        this.buttonArrayEnabled.method_25394(poseStack, mouseX, mouseY, partialTicks);
        if (this.buttonArrayEnabled.isChecked()) {
            this.buttonArrayEnabled.method_46419(yy);
            this.font.method_1729(poseStack, "Array enabled", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            int positionOffsetX0 = this.left + 8;
            int positionOffsetX1 = this.left + 160;
            int positionOffsetY0 = y + 24;
            int positionOffsetY1 = y + 48;
            int textOffsetX = 40;
            int componentOffsetX = 15;
            int componentOffsetY = -5;
            this.font.method_1729(poseStack, "Offset", (float)positionOffsetX0, (float)positionOffsetY0, 0xFFFFFF);
            this.font.method_1729(poseStack, "X", (float)(positionOffsetX0 + textOffsetX), (float)positionOffsetY0, 0xFFFFFF);
            this.font.method_1729(poseStack, "Y", (float)(positionOffsetX0 + textOffsetX), (float)(positionOffsetY0 + 24), 0xFFFFFF);
            this.font.method_1729(poseStack, "Z", (float)(positionOffsetX0 + textOffsetX), (float)(positionOffsetY0 + 48), 0xFFFFFF);
            this.textArrayOffsetX.y = positionOffsetY0 + componentOffsetY;
            this.textArrayOffsetY.y = positionOffsetY0 + componentOffsetY + 24;
            this.textArrayOffsetZ.y = positionOffsetY0 + componentOffsetY + 48;
            this.font.method_1729(poseStack, "Count", (float)positionOffsetX1, (float)positionOffsetY0, 0xFFFFFF);
            this.textArrayCount.y = positionOffsetY0 + componentOffsetY;
            int currentReach = Math.max(-1, this.getArrayReach());
            int maxReach = ReachHelper.getMaxReachDistance((class_1657)this.mc.field_1724);
            class_124 reachColor = this.isCurrentReachValid(currentReach, maxReach) ? class_124.field_1080 : class_124.field_1061;
            String reachText = "Reach  " + reachColor + currentReach + class_124.field_1080 + "/" + class_124.field_1080 + maxReach;
            this.font.method_1729(poseStack, reachText, (float)positionOffsetX1, (float)positionOffsetY1, 0xFFFFFF);
            this.arrayNumberFieldList.forEach(numberField -> numberField.drawNumberField(poseStack, mouseX, mouseY, partialTicks));
        } else {
            this.buttonArrayEnabled.method_46419(yy);
            this.font.method_1729(poseStack, "Array disabled", (float)(this.left + offset), (float)(yy + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(class_4587 poseStack, class_437 guiScreen, int mouseX, int mouseY) {
        if (this.buttonArrayEnabled.isChecked()) {
            this.arrayNumberFieldList.forEach(numberField -> numberField.drawTooltip(poseStack, this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (NumberField numberField : this.arrayNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideArrayEnabledLabel;
        this.arrayNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideArrayEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideArrayEnabledLabel) {
            this.buttonArrayEnabled.method_25354(this.mc.method_1483());
            this.buttonArrayEnabled.method_25348(mouseX, mouseY);
        }
        return true;
    }

    public Array.ArraySettings getArraySettings() {
        boolean arrayEnabled = this.buttonArrayEnabled.isChecked();
        class_2338 arrayOffset = new class_2338(0, 0, 0);
        try {
            arrayOffset = new class_2338(class_3532.method_15357((double)this.textArrayOffsetX.getNumber()), class_3532.method_15357((double)this.textArrayOffsetY.getNumber()), class_3532.method_15357((double)this.textArrayOffsetZ.getNumber()));
        }
        catch (NullPointerException | NumberFormatException ex) {
            Effortless.log((class_1657)this.mc.field_1724, "Array offset not a valid number.");
        }
        int arrayCount = 5;
        try {
            arrayCount = (int)this.textArrayCount.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            Effortless.log((class_1657)this.mc.field_1724, "Array count not a valid number.");
        }
        return new Array.ArraySettings(arrayEnabled, (class_2382)arrayOffset, arrayCount);
    }

    @Override
    protected String getName() {
        return "Array";
    }

    @Override
    protected int getExpandedHeight() {
        return 96;
    }

    private int getArrayReach() {
        try {
            double x = Math.abs(this.textArrayOffsetX.getNumber());
            double y = Math.abs(this.textArrayOffsetY.getNumber());
            double z = Math.abs(this.textArrayOffsetZ.getNumber());
            double largestOffset = Math.max(Math.max(x, y), z);
            double count = this.textArrayCount.getNumber();
            return (int)(count > 1.0 ? largestOffset * count : 0.0);
        }
        catch (NullPointerException | NumberFormatException ex) {
            return 0;
        }
    }

    private boolean isCurrentReachValid(int currentReach, int maxReach) {
        return currentReach <= maxReach && currentReach > -1;
    }
}

