/*
 * Decompiled with CFR 0.152.
 */
package dev.huskcasaca.effortless.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public abstract class Slot
extends class_362
implements class_4068 {
    protected final class_310 minecraft;
    protected final int itemHeight;
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected int yDrag = -2;
    protected double yo;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public Slot(class_310 minecraft, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.y0 = topIn;
        this.y1 = bottomIn;
        this.itemHeight = slotHeightIn;
        this.x0 = 0;
        this.x1 = width;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int p_selectItem_1_, int p_selectItem_2_, double p_selectItem_3_, double p_selectItem_5_) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected void updateItemPosition(int p_updateItemPosition_1_, int p_updateItemPosition_2_, int p_updateItemPosition_3_, float partialTicks) {
    }

    protected abstract void renderItem(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    protected void renderHeader(int p_renderHeader_1_, int p_renderHeader_2_, class_289 tesselator) {
    }

    protected void clickedHeader(int p_clickedHeader_1_, int p_clickedHeader_2_) {
    }

    public int getItemAtPosition(double posX, double posY) {
        int i = this.x0 + this.width / 2 - this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2 + this.getRowWidth() / 2;
        int k = class_3532.method_15357((double)(posY - (double)this.y0)) - this.headerHeight + (int)this.yo - 4;
        int l = k / this.itemHeight;
        return posX < (double)this.getScrollbarPosition() && posX >= (double)i && posX <= (double)j && l >= 0 && k >= 0 && l < this.getItemCount() ? l : -1;
    }

    protected void capYPosition() {
        this.yo = class_3532.method_15350((double)this.yo, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScroll() {
        return (int)this.yo;
    }

    public boolean isMouseInList(double posX, double posY) {
        return posY >= (double)this.y0 && posY <= (double)this.y1 && posX >= (double)this.x0 && posX <= (double)this.x1;
    }

    public abstract void method_25394(class_4587 var1, int var2, int var3, float var4);

    protected void updateScrollingState(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
        this.scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.getScrollbarPosition() && p_updateScrollingState_1_ < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (this.isVisible() && this.isMouseInList(mouseX, mouseY)) {
            int i = this.getItemAtPosition(mouseX, mouseY);
            if (i == -1 && button == 0) {
                this.clickedHeader((int)(mouseX - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.y0) + (int)this.yo - 4);
                return true;
            }
            if (i != -1 && this.selectItem(i, button, mouseX, mouseY)) {
                if (this.method_25396().size() > i) {
                    this.method_25395(this.method_25396().get(i));
                }
                this.method_25398(true);
                return true;
            }
            return this.scrolling;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null) {
            this.method_25399().method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (super.method_25403(mouseX, mouseY, button, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (this.isVisible() && button == 0 && this.scrolling) {
            if (mouseY < (double)this.y0) {
                this.yo = 0.0;
            } else if (mouseY > (double)this.y1) {
                this.yo = this.getMaxScroll();
            } else {
                double d0 = this.getMaxScroll();
                if (d0 < 1.0) {
                    d0 = 1.0;
                }
                int i = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                double d1 = d0 / (double)(this.y1 - this.y0 - (i = class_3532.method_15340((int)i, (int)32, (int)(this.y1 - this.y0 - 8))));
                if (d1 < 1.0) {
                    d1 = 1.0;
                }
                this.yo += p_mouseDragged_8_ * d1;
                this.capYPosition();
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrolled) {
        if (!this.isVisible()) {
            return false;
        }
        this.yo -= scrolled * (double)this.itemHeight / 2.0;
        return true;
    }

    public boolean method_25404(int i, int j, int k) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.method_25404(i, j, k)) {
            return true;
        }
        if (i == 264) {
            this.moveSelection(1);
            return true;
        }
        if (i == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int i) {
    }

    public boolean method_25400(char eventChar, int eventKey) {
        return this.isVisible() && super.method_25400(eventChar, eventKey);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.isMouseInList(mouseX, mouseY);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(class_4587 poseStack, int insideLeft, int insideTop, int mouseXIn, int mouseYIn, float partialTicks) {
        int i = this.getItemCount();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        for (int j = 0; j < i; ++j) {
            int k = insideTop + j * this.itemHeight + this.headerHeight;
            int l = this.itemHeight - 4;
            if (k > this.y1 || k + l < this.y0) {
                this.updateItemPosition(j, insideLeft, k, partialTicks);
            }
            if (this.renderSelection && this.isSelectedItem(j)) {
                int i1 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int j1 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                float f = this.method_25370() ? 1.0f : 0.5f;
                RenderSystem.setShaderColor((float)f, (float)f, (float)f, (float)1.0f);
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferbuilder.method_22912((double)i1, (double)(k + l + 2), 0.0).method_1344();
                bufferbuilder.method_22912((double)j1, (double)(k + l + 2), 0.0).method_1344();
                bufferbuilder.method_22912((double)j1, (double)(k - 2), 0.0).method_1344();
                bufferbuilder.method_22912((double)i1, (double)(k - 2), 0.0).method_1344();
                tesselator.method_1350();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bufferbuilder.method_22912((double)(i1 + 1), (double)(k + l + 1), 0.0).method_1344();
                bufferbuilder.method_22912((double)(j1 - 1), (double)(k + l + 1), 0.0).method_1344();
                bufferbuilder.method_22912((double)(j1 - 1), (double)(k - 1), 0.0).method_1344();
                bufferbuilder.method_22912((double)(i1 + 1), (double)(k - 1), 0.0).method_1344();
                tesselator.method_1350();
            }
            this.renderItem(poseStack, j, insideLeft, k, l, mouseXIn, mouseYIn, partialTicks);
        }
    }

    public boolean method_25370() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }
}

