/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.helper.FixedStack;
import nl.requios.effortlessbuilding.helper.InventoryHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;

public class UndoRedo {
    private static final Map<UUID, FixedStack<BlockSet>> undoStacksClient = new HashMap<UUID, FixedStack<BlockSet>>();
    private static final Map<UUID, FixedStack<BlockSet>> undoStacksServer = new HashMap<UUID, FixedStack<BlockSet>>();
    private static final Map<UUID, FixedStack<BlockSet>> redoStacksClient = new HashMap<UUID, FixedStack<BlockSet>>();
    private static final Map<UUID, FixedStack<BlockSet>> redoStacksServer = new HashMap<UUID, FixedStack<BlockSet>>();

    public static void addUndo(Player player, BlockSet blockSet) {
        Map<UUID, FixedStack<BlockSet>> undoStacks;
        Map<UUID, FixedStack<BlockSet>> map = undoStacks = player.f_19853_.f_46443_ ? undoStacksClient : undoStacksServer;
        if (blockSet.getCoordinates().size() != blockSet.getPreviousBlockStates().size() || blockSet.getCoordinates().size() != blockSet.getNewBlockStates().size()) {
            EffortlessBuilding.logger.error("Coordinates and blockstate lists are not equal length. Coordinates: {}. Previous blockstates: {}. New blockstates: {}.", (Object)blockSet.getCoordinates().size(), (Object)blockSet.getPreviousBlockStates().size(), (Object)blockSet.getNewBlockStates().size());
        }
        if (!undoStacks.containsKey(player.m_142081_())) {
            undoStacks.put(player.m_142081_(), new FixedStack<BlockSet>(new BlockSet[((Integer)BuildConfig.survivalBalancers.undoStackSize.get()).intValue()]));
        }
        undoStacks.get(player.m_142081_()).push(blockSet);
    }

    private static void addRedo(Player player, BlockSet blockSet) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.f_19853_.f_46443_ ? redoStacksClient : redoStacksServer;
        if (!redoStacks.containsKey(player.m_142081_())) {
            redoStacks.put(player.m_142081_(), new FixedStack<BlockSet>(new BlockSet[((Integer)BuildConfig.survivalBalancers.undoStackSize.get()).intValue()]));
        }
        redoStacks.get(player.m_142081_()).push(blockSet);
    }

    public static boolean undo(Player player) {
        Map<UUID, FixedStack<BlockSet>> undoStacks;
        Map<UUID, FixedStack<BlockSet>> map = undoStacks = player.f_19853_.f_46443_ ? undoStacksClient : undoStacksServer;
        if (!undoStacks.containsKey(player.m_142081_())) {
            return false;
        }
        FixedStack<BlockSet> undoStack = undoStacks.get(player.m_142081_());
        if (undoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = undoStack.pop();
        List<BlockPos> coordinates = blockSet.getCoordinates();
        List<BlockState> previousBlockStates = blockSet.getPreviousBlockStates();
        List<BlockState> newBlockStates = blockSet.getNewBlockStates();
        Vec3 hitVec = blockSet.getHitVec();
        List<ItemStack> itemStacks = UndoRedo.findItemStacksInInventory(player, previousBlockStates);
        if (player.f_19853_.f_46443_) {
            BlockPreviewRenderer.onBlocksBroken(coordinates, itemStacks, newBlockStates, blockSet.getSecondPos(), blockSet.getFirstPos());
        } else {
            for (int i = 0; i < coordinates.size(); ++i) {
                BlockPos coordinate = coordinates.get(i);
                ItemStack itemStack = itemStacks.get(i);
                if (previousBlockStates.get(i).equals(newBlockStates.get(i))) continue;
                BlockState previousBlockState = Blocks.f_50016_.m_49966_();
                if (itemStack.m_41720_() instanceof BlockItem) {
                    previousBlockState = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
                }
                if (!player.f_19853_.m_46749_(coordinate)) continue;
                if (itemStack.m_41619_()) {
                    itemStack = UndoRedo.findItemStackInInventory(player, previousBlockStates.get(i));
                    if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof BlockItem) {
                        previousBlockState = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
                    } else {
                        if (previousBlockStates.get(i).m_60734_() != Blocks.f_50016_) {
                            EffortlessBuilding.logTranslate(player, "", previousBlockStates.get(i).m_60734_().m_7705_(), " not found in inventory", true);
                        }
                        previousBlockState = Blocks.f_50016_.m_49966_();
                    }
                }
                if (itemStack.m_41619_()) {
                    SurvivalHelper.breakBlock(player.f_19853_, player, coordinate, true);
                }
                SurvivalHelper.placeBlock(player.f_19853_, player, coordinate, previousBlockState, itemStack, Direction.UP, hitVec, true, false, false);
            }
        }
        UndoRedo.addRedo(player, blockSet);
        return true;
    }

    public static boolean redo(Player player) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.f_19853_.f_46443_ ? redoStacksClient : redoStacksServer;
        if (!redoStacks.containsKey(player.m_142081_())) {
            return false;
        }
        FixedStack<BlockSet> redoStack = redoStacks.get(player.m_142081_());
        if (redoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = redoStack.pop();
        List<BlockPos> coordinates = blockSet.getCoordinates();
        List<BlockState> previousBlockStates = blockSet.getPreviousBlockStates();
        List<BlockState> newBlockStates = blockSet.getNewBlockStates();
        Vec3 hitVec = blockSet.getHitVec();
        List<ItemStack> itemStacks = UndoRedo.findItemStacksInInventory(player, newBlockStates);
        if (player.f_19853_.f_46443_) {
            BlockPreviewRenderer.onBlocksPlaced(coordinates, itemStacks, newBlockStates, blockSet.getFirstPos(), blockSet.getSecondPos());
        } else {
            for (int i = 0; i < coordinates.size(); ++i) {
                BlockPos coordinate = coordinates.get(i);
                ItemStack itemStack = itemStacks.get(i);
                if (previousBlockStates.get(i).equals(newBlockStates.get(i))) continue;
                BlockState newBlockState = Blocks.f_50016_.m_49966_();
                if (itemStack.m_41720_() instanceof BlockItem) {
                    newBlockState = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
                }
                if (!player.f_19853_.m_46749_(coordinate)) continue;
                if (itemStack.m_41619_()) {
                    itemStack = UndoRedo.findItemStackInInventory(player, newBlockStates.get(i));
                    if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof BlockItem) {
                        newBlockState = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
                    } else {
                        if (newBlockStates.get(i).m_60734_() != Blocks.f_50016_) {
                            EffortlessBuilding.logTranslate(player, "", newBlockStates.get(i).m_60734_().m_7705_(), " not found in inventory", true);
                        }
                        newBlockState = Blocks.f_50016_.m_49966_();
                    }
                }
                if (itemStack.m_41619_()) {
                    SurvivalHelper.breakBlock(player.f_19853_, player, coordinate, true);
                }
                SurvivalHelper.placeBlock(player.f_19853_, player, coordinate, newBlockState, itemStack, Direction.UP, hitVec, true, false, false);
            }
        }
        UndoRedo.addUndo(player, blockSet);
        return true;
    }

    public static void clear(Player player) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> undoStacks = player.f_19853_.f_46443_ ? undoStacksClient : undoStacksServer;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.f_19853_.f_46443_ ? redoStacksClient : redoStacksServer;
        if (undoStacks.containsKey(player.m_142081_())) {
            undoStacks.get(player.m_142081_()).clear();
        }
        if (redoStacks.containsKey(player.m_142081_())) {
            redoStacks.get(player.m_142081_()).clear();
        }
    }

    private static List<ItemStack> findItemStacksInInventory(Player player, List<BlockState> blockStates) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(blockStates.size());
        for (BlockState blockState : blockStates) {
            itemStacks.add(UndoRedo.findItemStackInInventory(player, blockState));
        }
        return itemStacks;
    }

    private static ItemStack findItemStackInInventory(Player player, BlockState blockState) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (blockState == null) {
            return itemStack;
        }
        itemStack = InventoryHelper.findItemStackInInventory(player, blockState.m_60734_());
        if (itemStack.m_41619_() && !player.f_19853_.f_46443_) {
            List itemsDropped = Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)player.f_19853_), (BlockPos)BlockPos.f_121853_, null);
            for (ItemStack itemStackDropped : itemsDropped) {
                if (!(itemStackDropped.m_41720_() instanceof BlockItem)) continue;
                Block block = ((BlockItem)itemStackDropped.m_41720_()).m_40614_();
                itemStack = InventoryHelper.findItemStackInInventory(player, block);
            }
        }
        return itemStack;
    }
}

