/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;

@Mod.EventBusSubscriber
public class ModeCapabilityManager {
    @CapabilityInject(value=IModeCapability.class)
    public static final Capability<IModeCapability> MODE_CAPABILITY = null;

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        LazyOptional original = event.getOriginal().getCapability(MODE_CAPABILITY, null);
        LazyOptional clone = event.getEntity().getCapability(MODE_CAPABILITY, null);
        clone.ifPresent(cloneModeCapability -> original.ifPresent(originalModeCapability -> cloneModeCapability.setModeData(originalModeCapability.getModeData())));
    }

    public static interface IModeCapability {
        public ModeSettingsManager.ModeSettings getModeData();

        public void setModeData(ModeSettingsManager.ModeSettings var1);
    }

    public static class Provider
    extends CapabilityProvider<Provider>
    implements ICapabilitySerializable<Tag> {
        private IModeCapability instance = new ModeCapability();
        private LazyOptional<IModeCapability> modeCapabilityOptional = LazyOptional.of(() -> this.instance);

        public Provider() {
            super(Provider.class);
            this.gatherCapabilities();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == MODE_CAPABILITY) {
                return this.modeCapabilityOptional.cast();
            }
            return LazyOptional.empty();
        }

        public void invalidateCaps() {
            super.invalidateCaps();
            this.modeCapabilityOptional.invalidate();
        }

        public void reviveCaps() {
            super.reviveCaps();
            this.modeCapabilityOptional = LazyOptional.of(() -> this.instance);
        }

        public Tag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            ModeSettingsManager.ModeSettings modeSettings = this.instance.getModeData();
            if (modeSettings == null) {
                modeSettings = new ModeSettingsManager.ModeSettings();
            }
            return compound;
        }

        public void deserializeNBT(Tag nbt) {
            CompoundTag compound = (CompoundTag)nbt;
            ModeSettingsManager.ModeSettings modeSettings = new ModeSettingsManager.ModeSettings(BuildModes.BuildModeEnum.NORMAL);
            this.instance.setModeData(modeSettings);
        }
    }

    public static class ModeCapability
    implements IModeCapability {
        private ModeSettingsManager.ModeSettings modeSettings;

        @Override
        public ModeSettingsManager.ModeSettings getModeData() {
            return this.modeSettings;
        }

        @Override
        public void setModeData(ModeSettingsManager.ModeSettings modeSettings) {
            this.modeSettings = modeSettings;
        }
    }
}

