/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;

@Mod.EventBusSubscriber
public class ModifierCapabilityManager {
    @CapabilityInject(value=IModifierCapability.class)
    public static final Capability<IModifierCapability> MODIFIER_CAPABILITY = null;

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        LazyOptional original = event.getOriginal().getCapability(MODIFIER_CAPABILITY, null);
        LazyOptional clone = event.getEntity().getCapability(MODIFIER_CAPABILITY, null);
        clone.ifPresent(cloneModifierCapability -> original.ifPresent(originalModifierCapability -> cloneModifierCapability.setModifierData(originalModifierCapability.getModifierData())));
    }

    public static interface IModifierCapability {
        public ModifierSettingsManager.ModifierSettings getModifierData();

        public void setModifierData(ModifierSettingsManager.ModifierSettings var1);
    }

    public static class Provider
    extends CapabilityProvider<Provider>
    implements INBTSerializable<Tag> {
        private final IModifierCapability instance = new ModifierCapability();
        private LazyOptional<IModifierCapability> modifierCapabilityOptional = LazyOptional.of(() -> this.instance);

        public Provider() {
            super(Provider.class);
            this.gatherCapabilities();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == MODIFIER_CAPABILITY) {
                return this.modifierCapabilityOptional.cast();
            }
            return LazyOptional.empty();
        }

        public void invalidateCaps() {
            super.invalidateCaps();
            this.modifierCapabilityOptional.invalidate();
        }

        public void reviveCaps() {
            super.reviveCaps();
            this.modifierCapabilityOptional = LazyOptional.of(() -> this.instance);
        }

        public Tag serializeNBT() {
            Mirror.MirrorSettings m;
            CompoundTag compound = new CompoundTag();
            ModifierSettingsManager.ModifierSettings modifierSettings = this.instance.getModifierData();
            if (modifierSettings == null) {
                modifierSettings = new ModifierSettingsManager.ModifierSettings();
            }
            if ((m = modifierSettings.getMirrorSettings()) == null) {
                m = new Mirror.MirrorSettings();
            }
            compound.m_128379_("mirrorEnabled", m.enabled);
            compound.m_128347_("mirrorPosX", m.position.f_82479_);
            compound.m_128347_("mirrorPosY", m.position.f_82480_);
            compound.m_128347_("mirrorPosZ", m.position.f_82481_);
            compound.m_128379_("mirrorX", m.mirrorX);
            compound.m_128379_("mirrorY", m.mirrorY);
            compound.m_128379_("mirrorZ", m.mirrorZ);
            compound.m_128405_("mirrorRadius", m.radius);
            compound.m_128379_("mirrorDrawLines", m.drawLines);
            compound.m_128379_("mirrorDrawPlanes", m.drawPlanes);
            Array.ArraySettings a = modifierSettings.getArraySettings();
            if (a == null) {
                a = new Array.ArraySettings();
            }
            compound.m_128379_("arrayEnabled", a.enabled);
            compound.m_128405_("arrayOffsetX", a.offset.m_123341_());
            compound.m_128405_("arrayOffsetY", a.offset.m_123342_());
            compound.m_128405_("arrayOffsetZ", a.offset.m_123343_());
            compound.m_128405_("arrayCount", a.count);
            compound.m_128405_("reachUpgrade", modifierSettings.getReachUpgrade());
            RadialMirror.RadialMirrorSettings r = modifierSettings.getRadialMirrorSettings();
            if (r == null) {
                r = new RadialMirror.RadialMirrorSettings();
            }
            compound.m_128379_("radialMirrorEnabled", r.enabled);
            compound.m_128347_("radialMirrorPosX", r.position.f_82479_);
            compound.m_128347_("radialMirrorPosY", r.position.f_82480_);
            compound.m_128347_("radialMirrorPosZ", r.position.f_82481_);
            compound.m_128405_("radialMirrorSlices", r.slices);
            compound.m_128379_("radialMirrorAlternate", r.alternate);
            compound.m_128405_("radialMirrorRadius", r.radius);
            compound.m_128379_("radialMirrorDrawLines", r.drawLines);
            compound.m_128379_("radialMirrorDrawPlanes", r.drawPlanes);
            return compound;
        }

        public void deserializeNBT(Tag nbt) {
            CompoundTag compound = (CompoundTag)nbt;
            boolean mirrorEnabled = compound.m_128471_("mirrorEnabled");
            Vec3 mirrorPosition = new Vec3(compound.m_128459_("mirrorPosX"), compound.m_128459_("mirrorPosY"), compound.m_128459_("mirrorPosZ"));
            boolean mirrorX = compound.m_128471_("mirrorX");
            boolean mirrorY = compound.m_128471_("mirrorY");
            boolean mirrorZ = compound.m_128471_("mirrorZ");
            int mirrorRadius = compound.m_128451_("mirrorRadius");
            boolean mirrorDrawLines = compound.m_128471_("mirrorDrawLines");
            boolean mirrorDrawPlanes = compound.m_128471_("mirrorDrawPlanes");
            Mirror.MirrorSettings mirrorSettings = new Mirror.MirrorSettings(mirrorEnabled, mirrorPosition, mirrorX, mirrorY, mirrorZ, mirrorRadius, mirrorDrawLines, mirrorDrawPlanes);
            boolean arrayEnabled = compound.m_128471_("arrayEnabled");
            BlockPos arrayOffset = new BlockPos(compound.m_128451_("arrayOffsetX"), compound.m_128451_("arrayOffsetY"), compound.m_128451_("arrayOffsetZ"));
            int arrayCount = compound.m_128451_("arrayCount");
            Array.ArraySettings arraySettings = new Array.ArraySettings(arrayEnabled, arrayOffset, arrayCount);
            int reachUpgrade = compound.m_128451_("reachUpgrade");
            boolean radialMirrorEnabled = compound.m_128471_("radialMirrorEnabled");
            Vec3 radialMirrorPosition = new Vec3(compound.m_128459_("radialMirrorPosX"), compound.m_128459_("radialMirrorPosY"), compound.m_128459_("radialMirrorPosZ"));
            int radialMirrorSlices = compound.m_128451_("radialMirrorSlices");
            boolean radialMirrorAlternate = compound.m_128471_("radialMirrorAlternate");
            int radialMirrorRadius = compound.m_128451_("radialMirrorRadius");
            boolean radialMirrorDrawLines = compound.m_128471_("radialMirrorDrawLines");
            boolean radialMirrorDrawPlanes = compound.m_128471_("radialMirrorDrawPlanes");
            RadialMirror.RadialMirrorSettings radialMirrorSettings = new RadialMirror.RadialMirrorSettings(radialMirrorEnabled, radialMirrorPosition, radialMirrorSlices, radialMirrorAlternate, radialMirrorRadius, radialMirrorDrawLines, radialMirrorDrawPlanes);
            ModifierSettingsManager.ModifierSettings modifierSettings = new ModifierSettingsManager.ModifierSettings(mirrorSettings, arraySettings, radialMirrorSettings, false, reachUpgrade);
            this.instance.setModifierData(modifierSettings);
        }
    }

    public static class ModifierCapability
    implements IModifierCapability {
        private ModifierSettingsManager.ModifierSettings modifierSettings;

        @Override
        public ModifierSettingsManager.ModifierSettings getModifierData() {
            return this.modifierSettings;
        }

        @Override
        public void setModifierData(ModifierSettingsManager.ModifierSettings modifierSettings) {
            this.modifierSettings = modifierSettings;
        }
    }
}

