/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;

public class ModeActionMessage {
    private ModeOptions.ActionEnum action;

    public ModeActionMessage() {
    }

    public ModeActionMessage(ModeOptions.ActionEnum action) {
        this.action = action;
    }

    public static void encode(ModeActionMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.action.ordinal());
    }

    public static ModeActionMessage decode(FriendlyByteBuf buf) {
        ModeOptions.ActionEnum action = ModeOptions.ActionEnum.values()[buf.readInt()];
        return new ModeActionMessage(action);
    }

    public static class Handler {
        public static void handle(ModeActionMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Player player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                ModeOptions.performAction(player, message.action);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

